/*
 * Decompiled with CFR 0.152.
 */
package it.bz.opendatahub.alpinebits.examples.inventory.middleware;

import it.bz.opendatahub.alpinebits.common.context.RequestContextKey;
import it.bz.opendatahub.alpinebits.common.exception.AlpineBitsException;
import it.bz.opendatahub.alpinebits.db.PersistenceContextKey;
import it.bz.opendatahub.alpinebits.examples.inventory.middleware.InventoryPushService;
import it.bz.opendatahub.alpinebits.mapping.entity.GenericResponse;
import it.bz.opendatahub.alpinebits.mapping.entity.inventory.HotelDescriptiveContentNotifRequest;
import it.bz.opendatahub.alpinebits.middleware.Context;
import it.bz.opendatahub.alpinebits.middleware.Key;
import it.bz.opendatahub.alpinebits.middleware.Middleware;
import it.bz.opendatahub.alpinebits.middleware.MiddlewareChain;
import javax.persistence.EntityManager;

public class InventoryPushMiddleware
implements Middleware {
    private final Key<HotelDescriptiveContentNotifRequest> requestKey;
    private final Key<GenericResponse> responseKey;

    public InventoryPushMiddleware(Key<HotelDescriptiveContentNotifRequest> requestKey, Key<GenericResponse> responseKey) {
        this.requestKey = requestKey;
        this.responseKey = responseKey;
    }

    public void handleContext(Context ctx, MiddlewareChain chain) {
        GenericResponse response = this.invokeService(ctx);
        ctx.put(this.responseKey, (Object)response);
    }

    private GenericResponse invokeService(Context ctx) {
        String action = (String)ctx.getOrThrow(RequestContextKey.REQUEST_ACTION);
        HotelDescriptiveContentNotifRequest hotelDescriptiveContentNotifRequest = (HotelDescriptiveContentNotifRequest)ctx.getOrThrow(this.requestKey);
        EntityManager em = (EntityManager)ctx.getOrThrow(PersistenceContextKey.ENTITY_MANAGER);
        InventoryPushService service = new InventoryPushService(em);
        if ("OTA_HotelDescriptiveContentNotif:Inventory".equals(action)) {
            return service.writeBasic(hotelDescriptiveContentNotifRequest);
        }
        if ("OTA_HotelDescriptiveContentNotif:Info".equals(action)) {
            return service.writeHotelInfo(hotelDescriptiveContentNotifRequest);
        }
        throw new AlpineBitsException("No implementation for action found", 500);
    }
}

