package it.bz.opendatahub.alpinebits.examples.inventory.mapper;

import it.bz.opendatahub.alpinebits.examples.inventory.entity.ImageItemEntity;
import it.bz.opendatahub.alpinebits.examples.inventory.entity.TextItemDescriptionEntity;
import it.bz.opendatahub.alpinebits.mapping.entity.inventory.ImageItem;
import it.bz.opendatahub.alpinebits.mapping.entity.inventory.TextItemDescription;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.mapstruct.factory.Mappers;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2019-08-28T11:40:34+0000",
    comments = "version: 1.2.0.Final, compiler: javac, environment: Java 1.8.0_191 (Oracle Corporation)"
)
public class ImageItemEntityMapperImpl implements ImageItemEntityMapper {

    private final TextItemDescriptionEntityMapper textItemDescriptionEntityMapper = Mappers.getMapper( TextItemDescriptionEntityMapper.class );

    @Override
    public ImageItemEntity toImageItemEntity(ImageItem imageItem) {
        if ( imageItem == null ) {
            return null;
        }

        ImageItemEntity imageItemEntity = new ImageItemEntity();

        imageItemEntity.setCategory( imageItem.getCategory() );
        imageItemEntity.setUrl( imageItem.getUrl() );
        imageItemEntity.setCopyrightNotice( imageItem.getCopyrightNotice() );
        imageItemEntity.setDescriptions( textItemDescriptionListToTextItemDescriptionEntityList( imageItem.getDescriptions() ) );

        return imageItemEntity;
    }

    @Override
    public ImageItem toImageItem(ImageItemEntity imageItemEntity) {
        if ( imageItemEntity == null ) {
            return null;
        }

        ImageItem imageItem = new ImageItem();

        imageItem.setCategory( imageItemEntity.getCategory() );
        imageItem.setUrl( imageItemEntity.getUrl() );
        imageItem.setCopyrightNotice( imageItemEntity.getCopyrightNotice() );
        imageItem.setDescriptions( textItemDescriptionEntityListToTextItemDescriptionList( imageItemEntity.getDescriptions() ) );

        return imageItem;
    }

    protected List<TextItemDescriptionEntity> textItemDescriptionListToTextItemDescriptionEntityList(List<TextItemDescription> list) {
        if ( list == null ) {
            return null;
        }

        List<TextItemDescriptionEntity> list1 = new ArrayList<TextItemDescriptionEntity>( list.size() );
        for ( TextItemDescription textItemDescription : list ) {
            list1.add( textItemDescriptionEntityMapper.toTextItemDescriptionEntity( textItemDescription ) );
        }

        return list1;
    }

    protected List<TextItemDescription> textItemDescriptionEntityListToTextItemDescriptionList(List<TextItemDescriptionEntity> list) {
        if ( list == null ) {
            return null;
        }

        List<TextItemDescription> list1 = new ArrayList<TextItemDescription>( list.size() );
        for ( TextItemDescriptionEntity textItemDescriptionEntity : list ) {
            list1.add( textItemDescriptionEntityMapper.toTextItemDescription( textItemDescriptionEntity ) );
        }

        return list1;
    }
}
