/*
 * Decompiled with CFR 0.152.
 */
package it.bz.opendatahub.alpinebits.examples.inventory.mapper;

import it.bz.opendatahub.alpinebits.examples.inventory.entity.ImageItemEntity;
import it.bz.opendatahub.alpinebits.examples.inventory.entity.TextItemDescriptionEntity;
import it.bz.opendatahub.alpinebits.examples.inventory.mapper.ImageItemEntityMapper;
import it.bz.opendatahub.alpinebits.examples.inventory.mapper.TextItemDescriptionEntityMapper;
import it.bz.opendatahub.alpinebits.mapping.entity.inventory.ImageItem;
import it.bz.opendatahub.alpinebits.mapping.entity.inventory.TextItemDescription;
import java.util.ArrayList;
import java.util.List;
import org.mapstruct.factory.Mappers;

public class ImageItemEntityMapperImpl
implements ImageItemEntityMapper {
    private final TextItemDescriptionEntityMapper textItemDescriptionEntityMapper = (TextItemDescriptionEntityMapper)Mappers.getMapper(TextItemDescriptionEntityMapper.class);

    public ImageItemEntity toImageItemEntity(ImageItem imageItem) {
        if (imageItem == null) {
            return null;
        }
        ImageItemEntity imageItemEntity = new ImageItemEntity();
        imageItemEntity.setCategory(imageItem.getCategory());
        imageItemEntity.setUrl(imageItem.getUrl());
        imageItemEntity.setCopyrightNotice(imageItem.getCopyrightNotice());
        imageItemEntity.setDescriptions(this.textItemDescriptionListToTextItemDescriptionEntityList(imageItem.getDescriptions()));
        return imageItemEntity;
    }

    public ImageItem toImageItem(ImageItemEntity imageItemEntity) {
        if (imageItemEntity == null) {
            return null;
        }
        ImageItem imageItem = new ImageItem();
        imageItem.setCategory(imageItemEntity.getCategory());
        imageItem.setUrl(imageItemEntity.getUrl());
        imageItem.setCopyrightNotice(imageItemEntity.getCopyrightNotice());
        imageItem.setDescriptions(this.textItemDescriptionEntityListToTextItemDescriptionList(imageItemEntity.getDescriptions()));
        return imageItem;
    }

    protected List<TextItemDescriptionEntity> textItemDescriptionListToTextItemDescriptionEntityList(List<TextItemDescription> list) {
        if (list == null) {
            return null;
        }
        ArrayList<TextItemDescriptionEntity> list1 = new ArrayList<TextItemDescriptionEntity>(list.size());
        for (TextItemDescription textItemDescription : list) {
            list1.add(this.textItemDescriptionEntityMapper.toTextItemDescriptionEntity(textItemDescription));
        }
        return list1;
    }

    protected List<TextItemDescription> textItemDescriptionEntityListToTextItemDescriptionList(List<TextItemDescriptionEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<TextItemDescription> list1 = new ArrayList<TextItemDescription>(list.size());
        for (TextItemDescriptionEntity textItemDescriptionEntity : list) {
            list1.add(this.textItemDescriptionEntityMapper.toTextItemDescription(textItemDescriptionEntity));
        }
        return list1;
    }
}

