/*
 * Decompiled with CFR 0.152.
 */
package it.burning.cron;

import it.burning.cron.CronExpressionParser;
import it.burning.utils.RxReplace;
import it.burning.utils.UTF8Control;
import java.util.Calendar;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CronExpressionDescriptor {
    private static final CronExpressionParser.Options DEFAULT_OPTIONS = new CronExpressionParser.Options();
    private static final String EMPTY_STRING = "";
    private static final String LOCALIZATION_BUNDLE = "localization";
    private final Pattern specialCharactersSearchPattern = Pattern.compile("[/\\-,*]");
    private final Pattern lastDayOffsetPattern = Pattern.compile("L-(\\d{1,2})");
    private final Pattern weekDayNumberMatches = Pattern.compile("(\\d{1,2}W)|(W\\d{1,2})");
    private final Pattern yearPattern = Pattern.compile("(\\d{4})");
    private final Pattern segmentRangesOrMultipleSearchPattern = Pattern.compile("[/\\-,]");
    private final Pattern segmentAnyOrMultipleSearchPattern = Pattern.compile("[*,]");
    private final RxReplace stripTrailingChars = new RxReplace("[\\,\\s]*$"){

        @Override
        public String replacement() {
            return CronExpressionDescriptor.EMPTY_STRING;
        }
    };
    private String expression;
    private String[] expressionParts;
    private Locale locale;
    private ResourceBundle localization;
    private boolean parsed;
    private CronExpressionParser.Options options;
    private boolean use24HourTimeFormat;

    public void setOptions(CronExpressionParser.Options options) {
        if (options == null) {
            throw new RuntimeException("Options cannot be null");
        }
        this.options = options;
        this.use24HourTimeFormat = options.isUse24HourTimeFormat();
        this.locale = options.getLocale();
        this.localization = ResourceBundle.getBundle(LOCALIZATION_BUNDLE, this.locale, new UTF8Control());
    }

    public CronExpressionParser.Options getOptions() {
        return this.options;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ResourceBundle getLocalization() {
        return this.localization;
    }

    public boolean isUse24HourTimeFormat() {
        return this.use24HourTimeFormat;
    }

    public CronExpressionDescriptor() {
    }

    public CronExpressionDescriptor(String expression) {
        this(expression, DEFAULT_OPTIONS);
    }

    public CronExpressionDescriptor(String expression, CronExpressionParser.Options options) {
        if (expression == null || expression.isEmpty()) {
            throw new IllegalArgumentException("The expression to be described cannot be null or empty");
        }
        this.parsed = false;
        this.expression = expression;
        this.options = options;
        this.use24HourTimeFormat = options.isUse24HourTimeFormat();
        this.locale = options.getLocale();
        this.localization = ResourceBundle.getBundle(LOCALIZATION_BUNDLE, this.locale, new UTF8Control());
    }

    public void setExpression(String expression) {
        this.setExpression(expression, DEFAULT_OPTIONS);
    }

    public void setExpression(String expression, CronExpressionParser.Options options) {
        if (expression == null || expression.isEmpty()) {
            throw new IllegalArgumentException("The expression to be described cannot be null or empty");
        }
        if (options == null) {
            throw new IllegalArgumentException("Options cannot be null when setting a new expression");
        }
        this.parsed = false;
        this.expression = expression;
        this.options = options;
        this.use24HourTimeFormat = options.isUse24HourTimeFormat();
        this.locale = options.getLocale();
        this.localization = ResourceBundle.getBundle(LOCALIZATION_BUNDLE, this.locale, new UTF8Control());
    }

    public String getDescription() {
        return this.getDescription(DescriptionType.FULL);
    }

    public String getDescription(DescriptionType type) {
        String description;
        if (this.expression == null || this.expression.isEmpty() || this.options == null) {
            throw new IllegalArgumentException("The expression to parse and the options to use cannot be null or empty");
        }
        try {
            if (!this.parsed) {
                CronExpressionParser parser = new CronExpressionParser(this.expression, this.options);
                this.expressionParts = parser.parse();
                this.parsed = true;
            }
            switch (type) {
                case TIMEOFDAY: {
                    description = this.GetTimeOfDayDescription();
                    break;
                }
                case HOURS: {
                    description = this.GetHoursDescription();
                    break;
                }
                case MINUTES: {
                    description = this.GetMinutesDescription();
                    break;
                }
                case SECONDS: {
                    description = this.GetSecondsDescription();
                    break;
                }
                case DAYOFMONTH: {
                    description = this.GetDayOfMonthDescription();
                    break;
                }
                case MONTH: {
                    description = this.GetMonthDescription();
                    break;
                }
                case DAYOFWEEK: {
                    description = this.GetDayOfWeekDescription();
                    break;
                }
                case YEAR: {
                    description = this.GetYearDescription();
                    break;
                }
                default: {
                    description = this.getFullDescription();
                    break;
                }
            }
        }
        catch (Exception e) {
            if (!this.options.isThrowExceptionOnParseError()) {
                description = e.getMessage();
            }
            throw e;
        }
        description = description.substring(0, 1).toUpperCase() + description.substring(1);
        return description;
    }

    protected String getFullDescription() {
        String description;
        block2: {
            try {
                String timeSegment = this.GetTimeOfDayDescription();
                String dayOfMonthDesc = this.GetDayOfMonthDescription();
                String monthDesc = this.GetMonthDescription();
                String dayOfWeekDesc = this.GetDayOfWeekDescription();
                String yearDesc = this.GetYearDescription();
                description = String.format("%s%s%s%s%s", timeSegment, dayOfMonthDesc, dayOfWeekDesc, monthDesc, yearDesc);
                description = this.transformVerbosity(description, this.options.isVerbose());
            }
            catch (Exception e) {
                description = this.getString("AnErrorOccuredWhenGeneratingTheExpressionD");
                if (!this.options.isThrowExceptionOnParseError()) break block2;
                throw new RuntimeException(description, e);
            }
        }
        return description;
    }

    protected String GetTimeOfDayDescription() {
        String secondsExpression = this.expressionParts[0];
        String minuteExpression = this.expressionParts[1];
        String hourExpression = this.expressionParts[2];
        StringBuilder description = new StringBuilder();
        if (!(this.specialCharactersSearchPattern.matcher(minuteExpression).find() || this.specialCharactersSearchPattern.matcher(hourExpression).find() || this.specialCharactersSearchPattern.matcher(secondsExpression).find())) {
            description.append(this.getString("AtSpace")).append(this.formatTime(hourExpression, minuteExpression, secondsExpression));
        } else if (secondsExpression.equals(EMPTY_STRING) && minuteExpression.contains("-") && !minuteExpression.contains(",") && !this.specialCharactersSearchPattern.matcher(hourExpression).find()) {
            String[] minuteParts = minuteExpression.split("-");
            description.append(String.format(this.getString("EveryMinuteBetweenX0AndX1"), this.formatTime(hourExpression, minuteParts[0]), this.formatTime(hourExpression, minuteParts[1])));
        } else if (secondsExpression.equals(EMPTY_STRING) && hourExpression.contains(",") && !hourExpression.contains("-") && !this.specialCharactersSearchPattern.matcher(minuteExpression).find()) {
            String[] hourParts = hourExpression.split(",");
            description.append(this.getString("At"));
            for (int i = 0; i < hourParts.length; ++i) {
                description.append(" ").append(this.formatTime(hourParts[i], minuteExpression));
                if (i < hourParts.length - 2) {
                    description.append(",");
                }
                if (i != hourParts.length - 2) continue;
                description.append(this.getString("SpaceAnd"));
            }
        } else {
            String secondsDescription = this.GetSecondsDescription();
            String minutesDescription = this.GetMinutesDescription();
            String hoursDescription = this.GetHoursDescription();
            description.append(secondsDescription);
            if (description.length() > 0 && minutesDescription.length() > 0) {
                description.append(", ");
            }
            description.append(minutesDescription);
            if (description.length() > 0 && hourExpression.length() > 0) {
                description.append(", ");
            }
            description.append(hoursDescription);
        }
        return description.toString();
    }

    protected String GetSecondsDescription() {
        return this.getSegmentDescription(this.expressionParts[0], this.getString("EverySecond"), desc -> desc, desc -> String.format(this.getString("EveryX0Seconds"), desc), desc -> this.getString("SecondsX0ThroughX1PastTheMinute"), desc -> {
            try {
                int i = Integer.parseInt(desc);
                if (desc.equals("0")) {
                    return EMPTY_STRING;
                }
                if (i < 20) {
                    return this.getString("AtX0SecondsPastTheMinute");
                }
                String specialized = this.getString("AtX0SecondsPastTheMinuteGt20");
                if (specialized != null) {
                    return specialized;
                }
                return this.getString("AtX0SecondsPastTheMinute");
            }
            catch (NumberFormatException e) {
                return this.getString("AtX0SecondsPastTheMinute");
            }
        }, desc -> {
            String specialized = this.getString("ComaMinX0ThroughMinX1");
            if (specialized != null) {
                return specialized;
            }
            return this.getString("ComaX0ThroughX1");
        });
    }

    protected String GetMinutesDescription() {
        String secondsExpression = this.expressionParts[0];
        return this.getSegmentDescription(this.expressionParts[1], this.getString("EveryMinute"), desc -> desc, desc -> String.format(this.getString("EveryX0Minutes"), desc), desc -> this.getString("MinutesX0ThroughX1PastTheHour"), desc -> {
            try {
                int target = Integer.parseInt(desc);
                if (desc.equals("0") && secondsExpression.equals(EMPTY_STRING)) {
                    return EMPTY_STRING;
                }
                if (target < 20) {
                    return this.getString("AtX0MinutesPastTheHour");
                }
                String specialFormat = this.getString("AtX0MinutesPastTheHourGt20");
                if (specialFormat != null && !specialFormat.isEmpty()) {
                    return specialFormat;
                }
                return this.getString("AtX0MinutesPastTheHour");
            }
            catch (NumberFormatException e) {
                return this.getString("AtX0MinutesPastTheHour");
            }
        }, desc -> {
            String specialFormat = this.getString("ComaMinX0ThroughMinX1");
            if (specialFormat != null && !specialFormat.isEmpty()) {
                return specialFormat;
            }
            return this.getString("ComaX0ThroughX1");
        });
    }

    protected String GetHoursDescription() {
        String expression = this.expressionParts[2];
        return this.getSegmentDescription(expression, this.getString("EveryHour"), desc -> this.formatTime(desc, "0"), desc -> String.format(this.getString("EveryX0Hours"), desc), desc -> this.getString("BetweenX0AndX1"), desc -> this.getString("AtX0"), desc -> {
            String specialFormat = this.getString("ComaMinX0ThroughMinX1");
            if (specialFormat != null && !specialFormat.isEmpty()) {
                return specialFormat;
            }
            return this.getString("ComaX0ThroughX1");
        });
    }

    protected String GetDayOfWeekDescription() {
        String description = this.expressionParts[5].equals("*") ? EMPTY_STRING : this.getSegmentDescription(this.expressionParts[5], this.getString("ComaEveryDay"), desc -> {
            if (desc.equals("7")) {
                return EMPTY_STRING;
            }
            if (desc.contains("L")) {
                desc = desc.replace("L", EMPTY_STRING);
            }
            if (desc.contains("#")) {
                desc = desc.substring(0, desc.indexOf("#"));
            }
            int dayNum = Integer.parseInt(desc);
            return this.getString(CronExpressionParser.Day.values()[dayNum].name());
        }, desc -> String.format(this.getString("ComaEveryX0DaysOfTheWeek"), desc), desc -> this.getString("ComaX0ThroughX1"), desc -> {
            String format;
            if (desc.contains("#")) {
                String dayOfWeekOfMonthNumber = desc.substring(desc.indexOf("#") + 1);
                String dayOfWeekOfMonthDescription = null;
                switch (dayOfWeekOfMonthNumber) {
                    case "1": {
                        dayOfWeekOfMonthDescription = this.getString("First");
                        break;
                    }
                    case "2": {
                        dayOfWeekOfMonthDescription = this.getString("Second");
                        break;
                    }
                    case "3": {
                        dayOfWeekOfMonthDescription = this.getString("Third");
                        break;
                    }
                    case "4": {
                        dayOfWeekOfMonthDescription = this.getString("Fourth");
                        break;
                    }
                    case "5": {
                        dayOfWeekOfMonthDescription = this.getString("Fifth");
                    }
                }
                format = this.getString("ComaOnTheSpace") + dayOfWeekOfMonthDescription + this.getString("SpaceX0OfTheMonth");
            } else {
                format = desc.contains("L") ? this.getString("ComaOnTheLastX0OfTheMonth") : this.getString("ComaOnlyOnX0");
            }
            return format;
        }, desc -> this.getString("ComaX0ThroughX1"));
        return description;
    }

    protected String GetMonthDescription() {
        return this.getSegmentDescription(this.expressionParts[4], EMPTY_STRING, desc -> {
            int monthNum = Integer.parseInt(desc) - 1;
            return this.getString(CronExpressionParser.Month.values()[monthNum].name());
        }, desc -> String.format(this.getString("ComaEveryX0Months"), desc), desc -> {
            String specialFormat = this.getString("ComaMonthX0ThroughMonthX1");
            if (specialFormat != null && !specialFormat.isEmpty()) {
                return specialFormat;
            }
            return this.getString("ComaX0ThroughX1");
        }, desc -> this.getString("ComaOnlyInX0"), desc -> {
            String specialFormat = this.getString("ComaMonthX0ThroughMonthX1");
            if (specialFormat != null && !specialFormat.isEmpty()) {
                return specialFormat;
            }
            return this.getString("ComaX0ThroughX1");
        });
    }

    protected String GetDayOfMonthDescription() {
        String description;
        String expression;
        switch (expression = this.expressionParts[3]) {
            case "L": {
                description = this.getString("ComaOnTheLastDayOfTheMonth");
                break;
            }
            case "WL": 
            case "LW": {
                description = this.getString("ComaOnTheLastWeekdayOfTheMonth");
                break;
            }
            default: {
                Matcher weekDayNumberMatcher = this.weekDayNumberMatches.matcher(expression);
                if (weekDayNumberMatcher.matches()) {
                    int weekDayNumber = Integer.parseInt(weekDayNumberMatcher.group(0).replace("W", EMPTY_STRING));
                    String dayString = weekDayNumber == 1 ? this.getString("FirstWeekday") : String.format(this.getString("WeekdayNearestDayX0"), weekDayNumber);
                    description = String.format(this.getString("ComaOnTheX0OfTheMonth"), dayString);
                    break;
                }
                Matcher lastDayOffsetMatcher = this.lastDayOffsetPattern.matcher(expression);
                if (lastDayOffsetMatcher.matches()) {
                    String offSetDays = lastDayOffsetMatcher.group(1);
                    description = String.format(this.getString("CommaDaysBeforeTheLastDayOfTheMonth"), offSetDays);
                    break;
                }
                description = this.getSegmentDescription(expression, this.getString("ComaEveryDay"), desc -> desc, desc -> {
                    if (desc.equals("1")) {
                        return this.getString("ComaEveryDay");
                    }
                    return this.getString("ComaEveryX0Days");
                }, desc -> this.getString("ComaBetweenDayX0AndX1OfTheMonth"), desc -> this.getString("ComaOnDayX0OfTheMonth"), desc -> this.getString("ComaX0ThroughX1"));
            }
        }
        return description;
    }

    private String GetYearDescription() {
        return this.getSegmentDescription(this.expressionParts[6], EMPTY_STRING, desc -> {
            if (this.yearPattern.matcher(desc).matches()) {
                Calendar calendar = Calendar.getInstance(this.locale);
                calendar.set(Integer.parseInt(desc), 0, 1);
                return String.valueOf(calendar.get(1));
            }
            return desc;
        }, desc -> String.format(this.getString("ComaEveryX0Years"), desc), desc -> {
            String specialFormat = this.getString("ComaYearX0ThroughYearX1");
            if (specialFormat == null || !specialFormat.isEmpty()) {
                return specialFormat;
            }
            return this.getString("ComaX0ThroughX1");
        }, desc -> this.getString("ComaOnlyInYearX0"), desc -> {
            String specialFormat = this.getString("ComaYearX0ThroughYearX1");
            if (specialFormat == null || !specialFormat.isEmpty()) {
                return specialFormat;
            }
            return this.getString("ComaX0ThroughX1");
        });
    }

    protected String getSegmentDescription(String expression, String allDescription, GetDescription getSingleItemDescription, GetDescription getIntervalDescriptionFormat, GetDescription getBetweenDescriptionFormat, GetDescription getDescriptionFormat, GetDescription getRangeFormat) {
        String description = null;
        if (expression == null || expression.isEmpty()) {
            description = EMPTY_STRING;
        } else if (expression.equals("*")) {
            description = allDescription;
        } else if (!this.segmentRangesOrMultipleSearchPattern.matcher(expression).find()) {
            description = String.format(getDescriptionFormat.getFor(expression), getSingleItemDescription.getFor(expression));
        } else if (expression.contains("/")) {
            String[] segments = expression.split("/");
            description = String.format(getIntervalDescriptionFormat.getFor(segments[1]), getSingleItemDescription.getFor(segments[1]));
            if (segments[0].contains("-")) {
                String betweenSegmentDescription = this.GenerateBetweenSegmentDescription(segments[0], getBetweenDescriptionFormat, getSingleItemDescription);
                if (!betweenSegmentDescription.startsWith(", ")) {
                    description = description + ", ";
                }
                description = description + betweenSegmentDescription;
            } else if (!this.segmentAnyOrMultipleSearchPattern.matcher(expression).find()) {
                String rangeItemDescription = String.format(getDescriptionFormat.getFor(segments[0]), getSingleItemDescription.getFor(segments[0])).replace(", ", EMPTY_STRING);
                description = description + String.format(this.getString("CommaStartingX0"), rangeItemDescription);
            }
        } else if (expression.contains(",")) {
            String[] segments = expression.split(",");
            StringBuilder descriptionContent = new StringBuilder();
            for (int i = 0; i < segments.length; ++i) {
                if (i > 0 && segments.length > 2) {
                    descriptionContent.append(",");
                    if (i < segments.length - 1) {
                        descriptionContent.append(" ");
                    }
                }
                if (i > 0 && i == segments.length - 1) {
                    descriptionContent.append(this.getString("SpaceAndSpace"));
                }
                if (segments[i].contains("-")) {
                    String betweenSegmentDescription = this.GenerateBetweenSegmentDescription(segments[i], getRangeFormat, getSingleItemDescription);
                    betweenSegmentDescription = betweenSegmentDescription.replace(", ", EMPTY_STRING);
                    descriptionContent.append(betweenSegmentDescription);
                    continue;
                }
                descriptionContent.append(getSingleItemDescription.getFor(segments[i]));
            }
            description = String.format(getDescriptionFormat.getFor(expression), descriptionContent);
        } else if (expression.contains("-")) {
            description = this.GenerateBetweenSegmentDescription(expression, getBetweenDescriptionFormat, getSingleItemDescription);
        }
        return description;
    }

    protected String GenerateBetweenSegmentDescription(String betweenExpression, GetDescription getBetweenDescriptionFormat, GetDescription getSingleItemDescription) {
        String[] betweenSegments = betweenExpression.split("-");
        String betweenSegment1Description = getSingleItemDescription.getFor(betweenSegments[0]);
        String betweenSegment2Description = getSingleItemDescription.getFor(betweenSegments[1]).replace(":00", ":59");
        String betweenDescriptionFormat = getBetweenDescriptionFormat.getFor(betweenExpression);
        return String.format(betweenDescriptionFormat, betweenSegment1Description, betweenSegment2Description);
    }

    protected String formatTime(String hourExpression, String minuteExpression) {
        return this.formatTime(hourExpression, minuteExpression, EMPTY_STRING);
    }

    protected String formatTime(String hourExpression, String minuteExpression, String secondExpression) {
        String period = EMPTY_STRING;
        int hour = Integer.parseInt(hourExpression);
        if (!this.use24HourTimeFormat) {
            period = this.getString(hour >= 12 ? "PMPeriod" : "AMPeriod");
            if (period.length() > 0) {
                period = " " + period;
            }
            if (hour == 0) {
                hour = 12;
            }
            if (hour > 12) {
                hour -= 12;
            }
        }
        String hourString = String.format("%02d", hour);
        String minuteString = String.format("%02d", Integer.parseInt(minuteExpression));
        String secondString = EMPTY_STRING;
        if (!secondExpression.isEmpty()) {
            secondString = ":" + String.format("%02d", Integer.parseInt(secondExpression));
        }
        return String.format("%s:%s%s%s", hourString, minuteString, secondString, period);
    }

    protected String transformVerbosity(String description, boolean useVerboseFormat) {
        if (!useVerboseFormat) {
            description = description.replace(this.getString("ComaEveryMinute"), EMPTY_STRING);
            description = description.replace(this.getString("ComaEveryHour"), EMPTY_STRING);
            description = description.replace(this.getString("ComaEveryDay"), EMPTY_STRING);
            description = this.stripTrailingChars.replace(description);
        }
        return description;
    }

    protected String getString(String resourceName) {
        return this.getString(resourceName, true);
    }

    protected String getString(String resourceName, boolean emptyIfNotFound) {
        try {
            return this.localization.getString(resourceName);
        }
        catch (MissingResourceException e) {
            return emptyIfNotFound ? EMPTY_STRING : "{" + resourceName + "}";
        }
    }

    public static String getDescription(String expression) {
        return CronExpressionDescriptor.getDescription(expression, DEFAULT_OPTIONS);
    }

    public static String getDescription(String expression, CronExpressionParser.Options options) {
        return new CronExpressionDescriptor(expression, options).getDescription(DescriptionType.FULL);
    }

    public static void setDefaultLocale(String language) {
        DEFAULT_OPTIONS.setLocale(Locale.forLanguageTag(language));
    }

    public static void setDefaultLocale(Locale locale) {
        DEFAULT_OPTIONS.setLocale(locale);
    }

    public static void setDefaultLocale() {
        DEFAULT_OPTIONS.setLocale(Locale.getDefault());
    }

    public static enum DescriptionType {
        FULL,
        TIMEOFDAY,
        SECONDS,
        MINUTES,
        HOURS,
        DAYOFWEEK,
        MONTH,
        DAYOFMONTH,
        YEAR;

    }

    @FunctionalInterface
    private static interface GetDescription {
        public String getFor(String var1);
    }
}

