/*
 * Decompiled with CFR 0.152.
 */
package it.amattioli.springate;

import it.amattioli.applicate.sessions.ServiceFactory;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringServiceFactory
implements ServiceFactory,
ApplicationContextAware {
    private static final String BASE_CONFIG = "/it/amattioli/springate/base-config.xml";
    private ApplicationContext ctx;

    public SpringServiceFactory() {
    }

    public SpringServiceFactory(String ... springConfig) {
        ArrayList<String> configs = new ArrayList<String>(springConfig.length + 1);
        configs.add(BASE_CONFIG);
        configs.addAll(Arrays.asList(springConfig));
        this.ctx = new ClassPathXmlApplicationContext(configs.toArray(new String[configs.size()]));
    }

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        if (this.ctx == null) {
            this.ctx = ctx;
        }
    }

    public Object createService(String serviceName) {
        return this.ctx.getBean(serviceName);
    }

    public boolean knowsService(String serviceName) {
        return this.ctx.containsBean(serviceName);
    }
}

