package it.amattioli.springate;

import it.amattioli.applicate.sessions.ServiceFactory;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringServiceFactory implements ServiceFactory {
	private static final String BASE_CONFIG = "/it/amattioli/springate/base-config.xml";
	private ApplicationContext ctx;

	public SpringServiceFactory(String springConfig) {
		ctx = new ClassPathXmlApplicationContext(new String[] {BASE_CONFIG,springConfig});
	}

	public Object createService(String serviceName) {
		return ctx.getBean(serviceName);
	}

	public boolean knowsService(String serviceName) {
		return ctx.containsBean(serviceName);
	}

}
