/*
 * Decompiled with CFR 0.152.
 */
package com.wdullaer.materialdatetimepicker.date;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.util.AttributeSet;
import com.wdullaer.materialdatetimepicker.date.DatePickerController;
import com.wdullaer.materialdatetimepicker.date.DatePickerDialog;
import com.wdullaer.materialdatetimepicker.date.MonthView;

public class SimpleMonthView
extends MonthView {
    public SimpleMonthView(Context context, AttributeSet attr2, DatePickerController controller, Typeface font) {
        super(context, attr2, controller, font);
    }

    @Override
    public void drawMonthDay(Canvas canvas, int year, int month, int day, int x, int y, int startX, int stopX, int startY, int stopY) {
        if (this.mSelectedDay == day) {
            canvas.drawCircle((float)x, (float)(y - MINI_DAY_NUMBER_TEXT_SIZE / 3), (float)DAY_SELECTED_CIRCLE_SIZE, this.mSelectedCirclePaint);
        }
        if (this.isHighlighted(year, month, day) && this.mSelectedDay != day) {
            canvas.drawCircle((float)x, (float)(y + MINI_DAY_NUMBER_TEXT_SIZE - DAY_HIGHLIGHT_CIRCLE_MARGIN), (float)DAY_HIGHLIGHT_CIRCLE_SIZE, this.mSelectedCirclePaint);
            if (this.font != null) {
                this.mMonthNumPaint.setTypeface(Typeface.create((Typeface)this.font, (int)1));
            } else {
                this.mMonthNumPaint.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)1));
            }
        } else if (this.font != null) {
            this.mMonthNumPaint.setTypeface(Typeface.create((Typeface)this.font, (int)0));
        } else {
            this.mMonthNumPaint.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)0));
        }
        if (this.mController.isOutOfRange(year, month, day)) {
            this.mMonthNumPaint.setColor(this.mDisabledDayTextColor);
        } else if (this.mSelectedDay == day) {
            if (this.font != null) {
                this.mMonthNumPaint.setTypeface(Typeface.create((Typeface)this.font, (int)1));
            } else {
                this.mMonthNumPaint.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)1));
            }
            this.mMonthNumPaint.setColor(this.mSelectedDayTextColor);
        } else if (this.mHasToday && this.mToday == day) {
            this.mMonthNumPaint.setColor(this.mTodayNumberColor);
        } else {
            this.mMonthNumPaint.setColor(this.isHighlighted(year, month, day) ? this.mHighlightedDayTextColor : this.mDayTextColor);
        }
        canvas.drawText(String.format(this.mController.getLocale(), "%d", day), (float)x, (float)y, this.mMonthNumPaint);
    }

    @Override
    protected void initView() {
        this.mMonthTitlePaint = new Paint();
        if (this.mController.getVersion() == DatePickerDialog.Version.VERSION_1) {
            this.mMonthTitlePaint.setFakeBoldText(true);
        }
        this.mMonthTitlePaint.setAntiAlias(true);
        this.mMonthTitlePaint.setTextSize((float)MONTH_LABEL_TEXT_SIZE);
        if (this.font != null) {
            this.mMonthTitlePaint.setTypeface(this.font);
        }
        this.mMonthTitlePaint.setColor(this.mDayTextColor);
        this.mMonthTitlePaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthTitlePaint.setStyle(Paint.Style.FILL);
        this.mSelectedCirclePaint = new Paint();
        this.mSelectedCirclePaint.setFakeBoldText(true);
        this.mSelectedCirclePaint.setAntiAlias(true);
        this.mSelectedCirclePaint.setColor(this.mTodayNumberColor);
        this.mSelectedCirclePaint.setTextAlign(Paint.Align.CENTER);
        this.mSelectedCirclePaint.setStyle(Paint.Style.FILL);
        this.mSelectedCirclePaint.setAlpha(255);
        this.mMonthDayLabelPaint = new Paint();
        this.mMonthDayLabelPaint.setAntiAlias(true);
        this.mMonthDayLabelPaint.setTextSize((float)MONTH_DAY_LABEL_TEXT_SIZE);
        this.mMonthDayLabelPaint.setColor(this.mMonthDayTextColor);
        if (this.font != null) {
            this.mMonthDayLabelPaint.setTypeface(this.font);
        }
        this.mMonthDayLabelPaint.setStyle(Paint.Style.FILL);
        this.mMonthDayLabelPaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthDayLabelPaint.setFakeBoldText(true);
        this.mMonthNumPaint = new Paint();
        this.mMonthNumPaint.setAntiAlias(true);
        this.mMonthNumPaint.setTextSize((float)MINI_DAY_NUMBER_TEXT_SIZE);
        this.mMonthNumPaint.setStyle(Paint.Style.FILL);
        this.mMonthNumPaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthNumPaint.setFakeBoldText(false);
        if (this.font != null) {
            this.mMonthNumPaint.setTypeface(this.font);
        }
    }
}

