/*
 * Decompiled with CFR 0.152.
 */
package ir.mtajik.android.advancedsmsmanager.view;

import android.app.Dialog;
import android.content.Context;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import ir.mtajik.android.advancedsmsmanager.R;
import ir.mtajik.android.advancedsmsmanager.presenter.SendSmsPresenter;
import ir.mtajik.android.advancedsmsmanager.view.SendSmsView;

public class SendSmsViewImpl
implements SendSmsView {
    private Dialog dialog;
    private Dialog simChoseDialog;
    private View dialogView;
    private SendSmsPresenter presenter;
    private Context context;
    private ProgressBar progressBar;
    private int layoutId;
    private int twoSimLayoutId;
    private WindowManager.LayoutParams layoutParams;
    private int dialogWidth;
    private int dialogHeight;

    public SendSmsViewImpl(SendSmsPresenter presenter) {
        this.presenter = presenter;
        presenter.setView(this);
    }

    @Override
    public void renderView(Context context, String message) {
        this.context = context;
        this.showDialogForSendSms(context, message);
    }

    @Override
    public void renderSimChooserView(Context context, String sim1CarrierName, String sim2CarrierName) {
        this.context = context;
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.dialogView = this.twoSimLayoutId == 0 ? inflater.inflate(R.layout.sms_dialog, null) : inflater.inflate(this.twoSimLayoutId, null);
        this.dialogView = inflater.inflate(R.layout.simcard_choosing_dialog, null);
        TextView titleText = (TextView)this.dialogView.findViewById(R.id.dialog_title);
        titleText.setText((CharSequence)"Chose witch sim card to send sms");
        Button sim1Button = (Button)this.dialogView.findViewById(R.id.sim1_button);
        sim1Button.setText((CharSequence)("1. " + sim1CarrierName));
        sim1Button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SendSmsViewImpl.this.presenter.sendSmsFromSubscriptionIdIndex(0);
                SendSmsViewImpl.this.simChoseDialog.dismiss();
            }
        });
        Button sim2Button = (Button)this.dialogView.findViewById(R.id.sim2_button);
        sim2Button.setText((CharSequence)("2. " + sim2CarrierName));
        sim2Button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SendSmsViewImpl.this.presenter.sendSmsFromSubscriptionIdIndex(1);
                SendSmsViewImpl.this.simChoseDialog.dismiss();
            }
        });
        this.simChoseDialog = new Dialog(context);
        this.simChoseDialog.setContentView(this.dialogView);
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
        lp.width = -1;
        lp.height = -2;
        lp.flags = 2;
        lp.dimAmount = 0.5f;
        this.simChoseDialog.show();
        this.simChoseDialog.getWindow().setAttributes(lp);
    }

    @Override
    public void endView() {
        if (this.progressBar != null) {
            this.progressBar.setVisibility(4);
        }
        if (this.dialog != null) {
            this.dialog.dismiss();
        }
    }

    @Override
    public void showMessage(String message) {
        Toast.makeText((Context)this.context, (CharSequence)message, (int)0).show();
    }

    @Override
    public void showLoading() {
        if (this.progressBar != null) {
            this.progressBar.setVisibility(0);
        }
    }

    @Override
    public void hideLoading() {
        if (this.progressBar != null) {
            this.progressBar.setVisibility(4);
        }
    }

    @Override
    public void setCustomLayout(int id2) {
        this.layoutId = id2;
    }

    @Override
    public void setLayoutParam(WindowManager.LayoutParams layoutParams) {
        this.layoutParams = layoutParams;
    }

    @Override
    public void setHeightAndWidth(int height, int width) {
        this.dialogWidth = width;
        this.dialogHeight = height;
    }

    @Override
    public void setCustomLayoutForTwoSim(int id2) {
        this.twoSimLayoutId = id2;
    }

    private void showDialogForSendSms(Context context, String message) {
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.dialogView = this.layoutId == 0 ? inflater.inflate(R.layout.sms_dialog, null) : inflater.inflate(this.layoutId, null);
        TextView title = (TextView)this.dialogView.findViewById(R.id.dialog_title);
        title.setText((CharSequence)message);
        this.progressBar = (ProgressBar)this.dialogView.findViewById(R.id.progressBar_total);
        Button sendButton = (Button)this.dialogView.findViewById(R.id.send_button);
        sendButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SendSmsViewImpl.this.presenter.prepareSendSms();
            }
        });
        Button cancelButton = (Button)this.dialogView.findViewById(R.id.cancel_button);
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SendSmsViewImpl.this.presenter.cancelSendSms();
            }
        });
        this.dialog = new Dialog(context);
        this.dialog.setContentView(this.dialogView);
        if (this.layoutParams == null) {
            this.layoutParams = new WindowManager.LayoutParams();
            this.layoutParams.width = -1;
            this.layoutParams.height = -2;
            this.layoutParams.flags = 2;
            this.layoutParams.dimAmount = 0.5f;
        }
        if (this.dialogHeight != 0) {
            this.layoutParams.height = this.dpToPx(this.dialogHeight);
        }
        if (this.dialogWidth != 0) {
            this.layoutParams.width = this.dpToPx(this.dialogWidth);
        }
        this.dialog.show();
        this.dialog.getWindow().setAttributes(this.layoutParams);
    }

    private int dpToPx(int dp) {
        DisplayMetrics displayMetrics = this.context.getResources().getDisplayMetrics();
        return Math.round((float)dp * (displayMetrics.xdpi / 160.0f));
    }
}

