/*
 * Decompiled with CFR 0.152.
 */
package ir.mtajik.android.advancedsmsmanager.presenter;

import android.content.Context;
import android.os.Build;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import ir.mtajik.android.advancedsmsmanager.model.MySmsManager;
import ir.mtajik.android.advancedsmsmanager.model.SendSmsModel;
import ir.mtajik.android.advancedsmsmanager.presenter.SendSmsPresenter;
import ir.mtajik.android.advancedsmsmanager.view.SendSmsView;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class SendSmsPresenterImpl
implements SendSmsPresenter {
    private static ArrayList<Integer> carriersICC = new ArrayList();
    private static ArrayList<String> carriersNAME = new ArrayList();
    private static List<SubscriptionInfo> subInfoList = new ArrayList<SubscriptionInfo>();
    private static int mySmsId;
    private SendSmsView view;
    private Context context;
    private String body;
    private SendSmsModel model;
    private MySmsManager.SMSManagerCallBack callBack;
    private String carrierNameFilter;
    private List<Integer> smsIdList = new ArrayList<Integer>();
    private boolean needsSendSmsDialog = true;
    private boolean needsChoseSimDialog = true;

    public SendSmsPresenterImpl(SendSmsModel model, Context context) {
        this.context = context;
        this.model = model;
    }

    @Override
    public void closeDialog() {
        if (this.view != null) {
            this.view.endView();
        }
    }

    @Override
    public void startWiringUp(String message, String body, MySmsManager.SMSManagerCallBack callback) {
        this.callBack = callback;
        this.body = body;
        Random rand = new Random();
        int smsId = rand.nextInt(2999) + 1;
        while (this.smsIdList.indexOf(smsId) >= 0) {
            smsId = rand.nextInt(2999) + 1;
        }
        mySmsId = smsId;
        this.smsIdList.add(smsId);
        if (this.needsSendSmsDialog) {
            if (this.view != null) {
                this.view.renderView(this.context, message);
            }
        } else {
            this.prepareSendSms();
        }
    }

    @Override
    public void prepareSendSms() {
        block10: {
            if (this.view != null && this.needsSendSmsDialog) {
                this.view.showLoading();
            }
            if (Build.VERSION.SDK_INT >= 22) {
                try {
                    SubscriptionManager mSubscriptionManager = SubscriptionManager.from((Context)this.context);
                    subInfoList = mSubscriptionManager.getActiveSubscriptionInfoList();
                    if (subInfoList != null && subInfoList.size() > 1) {
                        carriersICC.add(0, subInfoList.get(0).getSubscriptionId());
                        carriersICC.add(1, subInfoList.get(1).getSubscriptionId());
                        carriersNAME.add(0, subInfoList.get(0).getCarrierName().toString());
                        carriersNAME.add(1, subInfoList.get(1).getCarrierName().toString());
                        this.view.hideLoading();
                        if (this.needsChoseSimDialog) {
                            this.view.renderSimChooserView(this.context, carriersNAME.get(0), carriersNAME.get(1));
                        } else if (this.findPositionOfCarrierFilterInCarrierNameList() != -1) {
                            this.sendSmsFromSubscriptionIdIndex(this.findPositionOfCarrierFilterInCarrierNameList());
                        } else {
                            this.view.showMessage("your selected carrier is not exists.");
                        }
                        break block10;
                    }
                    carriersICC.add(0, subInfoList.get(0).getSubscriptionId());
                    carriersNAME.add(0, subInfoList.get(0).getCarrierName().toString());
                    this.sendSmsFromSubscriptionIdIndex(0);
                }
                catch (Exception e) {
                    if (this.view != null) {
                        this.view.showMessage("Some things go wrong. Maybe there is no sim-card");
                        this.view.hideLoading();
                    }
                    break block10;
                }
            }
            this.sendSmsForOldPhones();
        }
    }

    @Override
    public void sendSmsFromSubscriptionIdIndex(int i) {
        if (this.view != null && this.needsSendSmsDialog) {
            this.view.showLoading();
        }
        this.sendSmsForNewPhones(mySmsId, this.body, subInfoList.size(), carriersICC.get(i), carriersNAME.size() > 0 ? carriersNAME.get(i) : "", this.callBack);
    }

    @Override
    public void cancelSendSms() {
        if (this.view != null) {
            this.view.endView();
        }
    }

    @Override
    public void removeView() {
    }

    @Override
    public void setView(SendSmsView view) {
        this.view = view;
    }

    @Override
    public void setCarrierNameFilter(String carrierNameFilter) {
        this.carrierNameFilter = carrierNameFilter;
    }

    @Override
    public void setNeedsSendSmsDialog(boolean ifNeeded) {
        this.needsSendSmsDialog = ifNeeded;
    }

    @Override
    public void setNeedsChoseSimDialog(boolean ifNeeded) {
        this.needsChoseSimDialog = ifNeeded;
    }

    private int findPositionOfCarrierFilterInCarrierNameList() {
        for (String carrierName : carriersNAME) {
            if (!carrierName.toLowerCase().contains(this.carrierNameFilter.toLowerCase())) continue;
            return carriersNAME.indexOf(carrierName);
        }
        return -1;
    }

    private void sendSmsForNewPhones(int smsId, String body, int carrierSlutCount, int carrierSlutNum, String carrierName, final MySmsManager.SMSManagerCallBack callBack) {
        this.model.generateSMSForMultiSimCards(smsId, body, carrierSlutCount, carrierSlutNum, carrierName, this.carrierNameFilter, new MySmsManager.SMSManagerCallBack(){

            @Override
            public void afterSuccessfulSMS(int smsId) {
                if (mySmsId == smsId && SendSmsPresenterImpl.this.view != null) {
                    SendSmsPresenterImpl.this.view.endView();
                }
                callBack.afterSuccessfulSMS(smsId);
            }

            @Override
            public void afterDelivered(int smsId) {
                callBack.afterDelivered(smsId);
            }

            @Override
            public void afterUnSuccessfulSMS(int smsId, String message) {
                if (mySmsId == smsId && SendSmsPresenterImpl.this.view != null) {
                    SendSmsPresenterImpl.this.view.hideLoading();
                }
                callBack.afterUnSuccessfulSMS(smsId, message);
            }

            @Override
            public void onCarrierNameNotMatch(int smsId, String message) {
                if (mySmsId == smsId && SendSmsPresenterImpl.this.view != null) {
                    SendSmsPresenterImpl.this.view.hideLoading();
                }
                callBack.onCarrierNameNotMatch(smsId, message);
            }
        });
    }

    private void sendSmsForOldPhones() {
        this.model.generateSMSForSingleSimCard(mySmsId, this.body, this.carrierNameFilter, new MySmsManager.SMSManagerCallBack(){

            @Override
            public void afterSuccessfulSMS(int smsId) {
                if (mySmsId == smsId && SendSmsPresenterImpl.this.view != null) {
                    SendSmsPresenterImpl.this.view.endView();
                }
                SendSmsPresenterImpl.this.callBack.afterSuccessfulSMS(smsId);
            }

            @Override
            public void afterDelivered(int smsId) {
                if (mySmsId == smsId && SendSmsPresenterImpl.this.view != null) {
                    SendSmsPresenterImpl.this.view.endView();
                }
                SendSmsPresenterImpl.this.callBack.afterDelivered(smsId);
            }

            @Override
            public void afterUnSuccessfulSMS(int smsId, String message) {
                if (mySmsId == smsId && SendSmsPresenterImpl.this.view != null) {
                    SendSmsPresenterImpl.this.view.endView();
                }
                SendSmsPresenterImpl.this.callBack.afterUnSuccessfulSMS(smsId, message);
            }

            @Override
            public void onCarrierNameNotMatch(int smsId, String message) {
                SendSmsPresenterImpl.this.callBack.onCarrierNameNotMatch(smsId, message);
            }
        });
    }

    public void setContext(Context context) {
        this.context = context;
    }
}

