/*
 * Decompiled with CFR 0.152.
 */
package ir.mtajik.android.advancedsmsmanager;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.WindowManager;
import ir.mtajik.android.advancedsmsmanager.dagger.DaggerSmsManagerComponent;
import ir.mtajik.android.advancedsmsmanager.dagger.SmsManagerModule;
import ir.mtajik.android.advancedsmsmanager.model.MySmsManager;
import ir.mtajik.android.advancedsmsmanager.presenter.SendSmsPresenter;
import ir.mtajik.android.advancedsmsmanager.view.SendSmsView;
import javax.inject.Inject;

public class SmsHandler {
    @Inject
    SendSmsPresenter presenter;
    @Inject
    SendSmsView view;
    private Context context;
    private String smsNumber;
    private int sendSmsCustomDialogId = 0;
    private int choseSimCustomDialogId = 0;
    private WindowManager.LayoutParams layoutParams = null;
    private boolean needsSendSmsDialog;
    private boolean needsChoseSimDialog;
    private String carrierNameFilter;
    private int dialogWidth = 0;
    private int dialogHeight = 0;

    public SmsHandler(Context context, String smsNumber, @Nullable Integer sendSmsCustomDialogId, @Nullable Integer choseSimCustomDialogId, boolean needsSendSmsDialog, boolean needsChoseSimDialog, String carrierNameFilter, WindowManager.LayoutParams layoutParams, int dialogWidth, int dialogHeight) {
        this.context = context;
        this.smsNumber = smsNumber;
        this.sendSmsCustomDialogId = sendSmsCustomDialogId;
        this.choseSimCustomDialogId = choseSimCustomDialogId;
        this.needsSendSmsDialog = needsSendSmsDialog;
        this.needsChoseSimDialog = needsChoseSimDialog;
        this.carrierNameFilter = carrierNameFilter;
        this.layoutParams = layoutParams;
        this.dialogWidth = dialogWidth;
        this.dialogHeight = dialogHeight;
        this.wireUp();
    }

    public static Builder builder(Context context, String smsNumber) {
        return new Builder(context, smsNumber);
    }

    public void sendSms(String dialogMessage, String smsBody, MySmsManager.SMSManagerCallBack callback) {
        this.presenter.startWiringUp(dialogMessage, smsBody, callback);
    }

    private void wireUp() {
        DaggerSmsManagerComponent.builder().smsManagerModule(new SmsManagerModule(this.smsNumber, this.context)).build().inject(this);
        this.presenter.setNeedsSendSmsDialog(this.needsSendSmsDialog);
        this.presenter.setCarrierNameFilter(this.carrierNameFilter);
        this.presenter.setNeedsChoseSimDialog(this.needsChoseSimDialog);
        this.view.setLayoutParam(this.layoutParams);
        this.view.setHeightAndWidth(this.dialogHeight, this.dialogWidth);
        this.view.setCustomLayout(this.sendSmsCustomDialogId);
        this.view.setCustomLayoutForTwoSim(this.choseSimCustomDialogId);
    }

    public static class Builder {
        private Context context;
        private String smsNumber;
        private int sendSmsCustomDialogId = 0;
        private int choseSimCustomDialogId = 0;
        private boolean needsSendSmsDialog = true;
        private boolean needsChoseSimDialog = true;
        private String carrierNameFilter;
        private WindowManager.LayoutParams layoutParams = null;
        private int dialogWidth = 0;
        private int dialogHeight = 0;

        public Builder(Context context, String smsNumber) {
            this.context = context;
            this.smsNumber = smsNumber;
        }

        public Builder withCustomDialogForSendSms(Integer sendSmsCustomDialogId) {
            this.sendSmsCustomDialogId = sendSmsCustomDialogId;
            return this;
        }

        public Builder withCustomDialogForChoseSim(Integer choseSimCustomDialogId) {
            this.choseSimCustomDialogId = choseSimCustomDialogId;
            return this;
        }

        public Builder needToShowSendSmsDialog(Boolean needDialog) {
            this.needsSendSmsDialog = needDialog;
            return this;
        }

        public Builder needSendSmsFromSpecificCarrierWithOutAskingUser(@NonNull String carrierNameFilter) {
            this.needsChoseSimDialog = false;
            this.carrierNameFilter = carrierNameFilter;
            return this;
        }

        public Builder withCarrierNameFilter(String carrierNameFilter) {
            this.carrierNameFilter = carrierNameFilter;
            return this;
        }

        public Builder withLayoutParams(WindowManager.LayoutParams layoutParams) {
            this.layoutParams = layoutParams;
            return this;
        }

        public Builder withWidth(int dialogWidth) {
            this.dialogWidth = dialogWidth;
            return this;
        }

        public Builder withHeight(int dialogHeight) {
            this.dialogHeight = dialogHeight;
            return this;
        }

        public SmsHandler build() {
            return new SmsHandler(this.context, this.smsNumber, this.sendSmsCustomDialogId, this.choseSimCustomDialogId, this.needsSendSmsDialog, this.needsChoseSimDialog, this.carrierNameFilter, this.layoutParams, this.dialogWidth, this.dialogHeight);
        }
    }
}

