/*
 * Decompiled with CFR 0.152.
 */
package ir.mtajik.android.advancedsmsmanager;

import android.content.Context;
import android.support.annotation.Nullable;
import ir.mtajik.android.advancedsmsmanager.dagger.DaggerSmsManagerComponent;
import ir.mtajik.android.advancedsmsmanager.dagger.SmsManagerModule;
import ir.mtajik.android.advancedsmsmanager.model.MySmsManager;
import ir.mtajik.android.advancedsmsmanager.presenter.SendSmsPresenter;
import ir.mtajik.android.advancedsmsmanager.view.SendSmsView;
import javax.inject.Inject;

public class SmsHandler {
    @Inject
    SendSmsPresenter presenter;
    @Inject
    SendSmsView view;
    private Context context;
    private String smsNumber;
    private int sendSmsCustomDialogId = 0;
    private int choseSimCustomDialogId = 0;
    private boolean needDialog;
    private String carrierNameFilter;

    public SmsHandler(Context context, String smsNumber, @Nullable Integer sendSmsCustomDialogId, @Nullable Integer choseSimCustomDialogId, boolean needDialog, String carrierNameFilter) {
        this.context = context;
        this.smsNumber = smsNumber;
        this.sendSmsCustomDialogId = sendSmsCustomDialogId;
        this.choseSimCustomDialogId = choseSimCustomDialogId;
        this.needDialog = needDialog;
        this.carrierNameFilter = carrierNameFilter;
        this.wireUp();
    }

    public static Builder builder(Context context, String smsNumber) {
        return new Builder(context, smsNumber);
    }

    public void sendSms(String dialogMessage, String smsBody, MySmsManager.SMSManagerCallBack callback) {
        this.presenter.startWiringUp(dialogMessage, smsBody, callback);
    }

    private void wireUp() {
        DaggerSmsManagerComponent.builder().smsManagerModule(new SmsManagerModule(this.smsNumber, this.context)).build().inject(this);
        this.presenter.setNeedDialog(this.needDialog);
        this.presenter.setCarrierNameFilter(this.carrierNameFilter);
        this.view.setCustomLayout(this.sendSmsCustomDialogId);
        this.view.setCustomLayoutForTwoSim(this.choseSimCustomDialogId);
    }

    public static class Builder {
        private Context context;
        private String smsNumber;
        private int sendSmsCustomDialogId = 0;
        private int choseSimCustomDialogId = 0;
        private boolean needDialog = true;
        private String carrierNameFilter;

        public Builder(Context context, String smsNumber) {
            this.context = context;
            this.smsNumber = smsNumber;
        }

        public Builder withCustomDialogForSendSms(Integer sendSmsCustomDialogId) {
            this.sendSmsCustomDialogId = sendSmsCustomDialogId;
            return this;
        }

        public Builder withCustomDialogForChoseSim(Integer choseSimCustomDialogId) {
            this.choseSimCustomDialogId = choseSimCustomDialogId;
            return this;
        }

        public Builder needToShowDialog(Boolean needDialog) {
            this.needDialog = needDialog;
            return this;
        }

        public Builder withCarrierNameFilter(String carrierNameFilter) {
            this.carrierNameFilter = carrierNameFilter;
            return this;
        }

        public SmsHandler build() {
            return new SmsHandler(this.context, this.smsNumber, this.sendSmsCustomDialogId, this.choseSimCustomDialogId, this.needDialog, this.carrierNameFilter);
        }
    }
}

