/*
 * Decompiled with CFR 0.152.
 */
package ir.mtajik.android.advancedsmsmanager.model;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.telephony.SmsManager;

public class MySmsManager {
    Context context;
    SMSManagerCallBack mySmsManagerCallBack = null;
    private String SENT = "SMS_SENT";
    private String DELIVERED = "SMS_DELIVERED";
    private String sms_number;
    private String mBody;
    private int carrierSlotNumber;
    private int carrierSlotCount;
    private int smsId = 0;
    private String carrierName;
    private String carrierNameFilter;

    public MySmsManager(String sms_number, Context context) {
        this.context = context;
        this.sms_number = sms_number;
    }

    public void generateSMS(int smsId, String body, SMSManagerCallBack callBack) {
        this.mySmsManagerCallBack = callBack;
        this.smsId = smsId;
        this.mBody = body;
        this.sendSMS(this.mBody);
    }

    public void generateSMS(int smsId, String body, int carrierSlotCount, int carrierSlutNumber, String carrierName, SMSManagerCallBack callBack) {
        this.mySmsManagerCallBack = callBack;
        this.smsId = smsId;
        this.initializeSmsManager(body, carrierSlotCount, carrierSlutNumber, carrierName);
        this.sendSMS(this.mBody);
    }

    public void initializeSmsManager(String body, int carrierSlotCount, int carrierSlotNumber, String cariername) {
        this.carrierSlotNumber = carrierSlotNumber;
        this.carrierName = cariername;
        this.mBody = body;
        this.carrierSlotCount = carrierSlotCount;
    }

    public void sendSMS(String message) {
        PendingIntent sentPI = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)new Intent(this.SENT), (int)0);
        PendingIntent deliveredPI = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)new Intent(this.DELIVERED), (int)0);
        BroadcastReceiver mySender = new BroadcastReceiver(){

            public void onReceive(Context arg0, Intent arg1) {
                switch (this.getResultCode()) {
                    case -1: {
                        MySmsManager.this.context.unregisterReceiver((BroadcastReceiver)this);
                        if (MySmsManager.this.mySmsManagerCallBack == null) break;
                        MySmsManager.this.mySmsManagerCallBack.afterSuccessfulSMS(MySmsManager.this.smsId);
                        break;
                    }
                    case 1: {
                        MySmsManager.this.context.unregisterReceiver((BroadcastReceiver)this);
                        if (MySmsManager.this.mySmsManagerCallBack == null) break;
                        MySmsManager.this.mySmsManagerCallBack.afterUnSuccessfulSMS(MySmsManager.this.smsId, "Generic failure");
                        break;
                    }
                    case 4: {
                        MySmsManager.this.context.unregisterReceiver((BroadcastReceiver)this);
                        if (MySmsManager.this.mySmsManagerCallBack == null) break;
                        MySmsManager.this.mySmsManagerCallBack.afterUnSuccessfulSMS(MySmsManager.this.smsId, "No service");
                        break;
                    }
                    case 3: {
                        MySmsManager.this.context.unregisterReceiver((BroadcastReceiver)this);
                        if (MySmsManager.this.mySmsManagerCallBack == null) break;
                        MySmsManager.this.mySmsManagerCallBack.afterUnSuccessfulSMS(MySmsManager.this.smsId, "Null PDU");
                        break;
                    }
                    case 2: {
                        MySmsManager.this.context.unregisterReceiver((BroadcastReceiver)this);
                        if (MySmsManager.this.mySmsManagerCallBack == null) break;
                        MySmsManager.this.mySmsManagerCallBack.afterUnSuccessfulSMS(MySmsManager.this.smsId, "Radio off");
                    }
                }
            }
        };
        this.context.registerReceiver(mySender, new IntentFilter(this.SENT));
        BroadcastReceiver myReceiver = new BroadcastReceiver(){

            public void onReceive(Context arg0, Intent arg1) {
                switch (this.getResultCode()) {
                    case -1: {
                        MySmsManager.this.context.unregisterReceiver((BroadcastReceiver)this);
                        MySmsManager.this.mySmsManagerCallBack.afterDelivered(MySmsManager.this.smsId);
                        break;
                    }
                    case 0: {
                        MySmsManager.this.context.unregisterReceiver((BroadcastReceiver)this);
                        if (MySmsManager.this.mySmsManagerCallBack == null) break;
                        MySmsManager.this.mySmsManagerCallBack.afterUnSuccessfulSMS(MySmsManager.this.smsId, "SMS not delivered");
                    }
                }
            }
        };
        this.context.registerReceiver(myReceiver, new IntentFilter(this.DELIVERED));
        SmsManager sms = SmsManager.getDefault();
        int subscriptionId = this.carrierSlotNumber;
        if (Build.VERSION.SDK_INT >= 22) {
            if (this.checkCarrierNameFilter()) {
                if (this.carrierSlotCount > 1) {
                    this.sendSms(message, sentPI, deliveredPI, SmsManager.getSmsManagerForSubscriptionId((int)subscriptionId));
                } else {
                    this.sendSms(message, sentPI, deliveredPI, sms);
                }
            } else {
                this.mySmsManagerCallBack.onCarrierNameNotMatch(this.smsId, "You had to send sms from: " + this.carrierNameFilter);
            }
        } else {
            this.sendSms(message, sentPI, deliveredPI, sms);
        }
    }

    private void sendSms(String message, PendingIntent sentPI, PendingIntent deliveredPI, SmsManager sms) {
        sms.sendTextMessage(this.sms_number, null, message, sentPI, deliveredPI);
    }

    private boolean checkCarrierNameFilter() {
        if (this.carrierNameFilter != null) {
            return this.carrierName.contains(this.carrierNameFilter);
        }
        return true;
    }

    public void setSms_number(String sms_number) {
        this.sms_number = sms_number;
    }

    public void setCarrierNameFilter(String carrierNameFilter) {
        this.carrierNameFilter = carrierNameFilter;
    }

    public static interface SMSManagerCallBack {
        public void afterSuccessfulSMS(int var1);

        public void afterDelivered(int var1);

        public void afterUnSuccessfulSMS(int var1, String var2);

        public void onCarrierNameNotMatch(int var1, String var2);
    }
}

