/*
 * Decompiled with CFR 0.152.
 */
package ir.mtajik.android.advancedsmsmanager.presenter;

import android.content.Context;
import android.os.Build;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import ir.mtajik.android.advancedsmsmanager.model.MySmsManager;
import ir.mtajik.android.advancedsmsmanager.model.SendSmsModel;
import ir.mtajik.android.advancedsmsmanager.presenter.SendSmsPresenter;
import ir.mtajik.android.advancedsmsmanager.view.SendSmsView;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class SendSmsPresenterImpl
implements SendSmsPresenter {
    private static ArrayList<Integer> carriersICC = new ArrayList();
    private static ArrayList<String> carriersNAME = new ArrayList();
    private static List<SubscriptionInfo> subInfoList = new ArrayList<SubscriptionInfo>();
    private static int mySmsId;
    private SendSmsView view;
    private Context context;
    private String body;
    private SendSmsModel model;
    private MySmsManager.SMSManagerCallBack callBack;
    private String carrierNameFilter;

    public SendSmsPresenterImpl(SendSmsModel model, Context context) {
        this.context = context;
        this.model = model;
    }

    @Override
    public void closeDialog() {
        if (this.view != null) {
            this.view.endView();
        }
    }

    @Override
    public void startWiringUp(String message, String body, MySmsManager.SMSManagerCallBack callback) {
        this.callBack = callback;
        this.body = body;
        Random rand = new Random();
        mySmsId = rand.nextInt(2999) + 1;
        if (this.view != null) {
            this.view.renderView(this.context, message);
        }
    }

    @Override
    public void prepareSendSms() {
        if (this.view != null) {
            this.view.showLoading();
        }
        if (Build.VERSION.SDK_INT >= 22) {
            SubscriptionManager mSubscriptionManager = SubscriptionManager.from((Context)this.context);
            subInfoList = mSubscriptionManager.getActiveSubscriptionInfoList();
            if (subInfoList != null && subInfoList.size() > 1) {
                carriersICC.add(0, subInfoList.get(0).getSubscriptionId());
                carriersICC.add(1, subInfoList.get(1).getSubscriptionId());
                carriersNAME.add(0, subInfoList.get(0).getCarrierName().toString());
                carriersNAME.add(1, subInfoList.get(1).getCarrierName().toString());
                this.view.hideLoading();
                this.view.renderSimChooserView(carriersNAME.get(0), carriersNAME.get(1));
            } else {
                carriersICC.add(0, subInfoList.get(0).getSubscriptionId());
                carriersNAME.add(0, subInfoList.get(0).getCarrierName().toString());
                this.sendSmsFromSubscriptionId(0);
            }
        } else {
            this.sendSmsForOldPhones();
        }
    }

    @Override
    public void sendSmsFromSubscriptionId(int i) {
        if (this.view != null) {
            this.view.showLoading();
        }
        this.sendSmsForNewPhones(mySmsId, this.body, subInfoList.size(), i, carriersNAME.size() > 0 ? carriersNAME.get(i) : "", this.callBack);
    }

    @Override
    public void cancelSendSms() {
        if (this.view != null) {
            this.view.endView();
        }
    }

    @Override
    public void removeView() {
    }

    @Override
    public void setView(SendSmsView view) {
        this.view = view;
    }

    private void sendSmsForNewPhones(int smsId, String body, int carrierSlutCount, int carrierSlutNum, String carrierName, final MySmsManager.SMSManagerCallBack callBack) {
        this.model.generateSMSForMultiSimCards(smsId, body, carrierSlutCount, carrierSlutNum, carrierName, this.carrierNameFilter, new MySmsManager.SMSManagerCallBack(){

            @Override
            public void afterSuccessfulSMS(int smsId) {
                if (mySmsId == smsId && SendSmsPresenterImpl.this.view != null) {
                    SendSmsPresenterImpl.this.view.endView();
                }
                callBack.afterSuccessfulSMS(smsId);
            }

            @Override
            public void afterDelivered(int smsId) {
                callBack.afterDelivered(smsId);
            }

            @Override
            public void afterUnSuccessfulSMS(int smsId, String message) {
                if (mySmsId == smsId && SendSmsPresenterImpl.this.view != null) {
                    SendSmsPresenterImpl.this.view.hideLoading();
                }
                callBack.afterUnSuccessfulSMS(smsId, message);
            }

            @Override
            public void onCarrierNameNotMatch(int smsId, String message) {
                if (mySmsId == smsId && SendSmsPresenterImpl.this.view != null) {
                    SendSmsPresenterImpl.this.view.hideLoading();
                }
                callBack.onCarrierNameNotMatch(smsId, message);
            }
        });
    }

    private void sendSmsForOldPhones() {
        this.model.generateSMSForSingleSimCard(mySmsId, this.body, this.carrierNameFilter, new MySmsManager.SMSManagerCallBack(){

            @Override
            public void afterSuccessfulSMS(int smsId) {
                SendSmsPresenterImpl.this.callBack.afterSuccessfulSMS(smsId);
            }

            @Override
            public void afterDelivered(int smsId) {
                SendSmsPresenterImpl.this.callBack.afterDelivered(smsId);
            }

            @Override
            public void afterUnSuccessfulSMS(int smsId, String message) {
                SendSmsPresenterImpl.this.callBack.afterUnSuccessfulSMS(smsId, message);
            }

            @Override
            public void onCarrierNameNotMatch(int smsId, String message) {
                SendSmsPresenterImpl.this.callBack.onCarrierNameNotMatch(smsId, message);
            }
        });
    }

    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public void setCarrierNameFilter(String carrierNameFilter) {
        this.carrierNameFilter = carrierNameFilter;
    }
}

