/*
 * Decompiled with CFR 0.152.
 */
package ir.mtajik.android.advancedsmsmanager.model;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.telephony.SmsManager;
import android.widget.Toast;

public class MySmsManager {
    Context context;
    SMSManagerCallBack mySmsManagerCallBack = null;
    private String SENT = "SMS_SENT";
    private String DELIVERED = "SMS_DELIVERED";
    private String sms_number;
    private String mBody;
    private int carrierSlotNumber;
    private int carrierSlotCount;
    private int smsId = 0;
    private String carrierName;
    private String carrierNameFilter;

    public MySmsManager(String sms_number, Context context) {
        this.context = context;
        this.sms_number = sms_number;
    }

    public void generateSMS(int smsId, String body, SMSManagerCallBack callBack) {
        this.mySmsManagerCallBack = callBack;
        this.smsId = smsId;
        this.mBody = body;
        this.sendSMS(this.mBody);
    }

    public void generateSMS(int smsId, String body, int carrierSlotCount, int carrierSlutNumber, String carrierName, SMSManagerCallBack callBack) {
        this.mySmsManagerCallBack = callBack;
        this.smsId = smsId;
        this.initializeSmsManager(body, carrierSlotCount, carrierSlutNumber, carrierName);
        this.sendSMS(this.mBody);
    }

    public void initializeSmsManager(String body, int carrierSlotCount, int carrierSlotNumber, String cariername) {
        this.carrierSlotNumber = carrierSlotNumber;
        this.carrierName = cariername;
        this.mBody = body;
        this.carrierSlotCount = carrierSlotCount;
    }

    public void sendSMS(String message) {
        PendingIntent sentPI = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)new Intent(this.SENT), (int)0);
        PendingIntent deliveredPI = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)new Intent(this.DELIVERED), (int)0);
        BroadcastReceiver mySender = new BroadcastReceiver(){

            public void onReceive(Context arg0, Intent arg1) {
                switch (this.getResultCode()) {
                    case -1: {
                        MySmsManager.this.context.unregisterReceiver((BroadcastReceiver)this);
                        if (MySmsManager.this.mySmsManagerCallBack == null) break;
                        MySmsManager.this.mySmsManagerCallBack.afterSuccessfulSMS(MySmsManager.this.smsId);
                        break;
                    }
                    case 1: {
                        Toast.makeText((Context)MySmsManager.this.context, (CharSequence)"\u062e\u0637\u0627 \u062f\u0631 \u0627\u0631\u0633\u0627\u0644", (int)0).show();
                        MySmsManager.this.context.unregisterReceiver((BroadcastReceiver)this);
                        if (MySmsManager.this.mySmsManagerCallBack == null) break;
                        MySmsManager.this.mySmsManagerCallBack.afterUnSuccessfulSMS(MySmsManager.this.smsId, "\u062e\u0637\u0627 \u062f\u0631 \u0627\u0631\u0633\u0627\u0644");
                        break;
                    }
                    case 4: {
                        MySmsManager.this.context.unregisterReceiver((BroadcastReceiver)this);
                        if (MySmsManager.this.mySmsManagerCallBack == null) break;
                        MySmsManager.this.mySmsManagerCallBack.afterUnSuccessfulSMS(MySmsManager.this.smsId, "\u0639\u062f\u0645 \u0648\u062c\u0648\u062f \u0633\u0631\u0648\u06cc\u0633 \u0634\u0628\u06a9\u0647");
                        break;
                    }
                    case 3: {
                        MySmsManager.this.context.unregisterReceiver((BroadcastReceiver)this);
                        if (MySmsManager.this.mySmsManagerCallBack == null) break;
                        MySmsManager.this.mySmsManagerCallBack.afterUnSuccessfulSMS(MySmsManager.this.smsId, " PDU \u062e\u0637\u0627\u06cc ");
                        break;
                    }
                    case 2: {
                        MySmsManager.this.context.unregisterReceiver((BroadcastReceiver)this);
                        if (MySmsManager.this.mySmsManagerCallBack == null) break;
                        MySmsManager.this.mySmsManagerCallBack.afterUnSuccessfulSMS(MySmsManager.this.smsId, "\u0639\u062f\u0645 \u0648\u062c\u0648\u062f \u0627\u0631\u062a\u0628\u0627\u0637 \u0631\u0627\u062f\u06cc\u0648\u06cc\u06cc");
                    }
                }
            }
        };
        this.context.registerReceiver(mySender, new IntentFilter(this.SENT));
        BroadcastReceiver myReceiver = new BroadcastReceiver(){

            public void onReceive(Context arg0, Intent arg1) {
                switch (this.getResultCode()) {
                    case -1: {
                        MySmsManager.this.context.unregisterReceiver((BroadcastReceiver)this);
                        MySmsManager.this.mySmsManagerCallBack.afterDelivered(MySmsManager.this.smsId);
                        break;
                    }
                    case 0: {
                        MySmsManager.this.context.unregisterReceiver((BroadcastReceiver)this);
                        if (MySmsManager.this.mySmsManagerCallBack == null) break;
                        MySmsManager.this.mySmsManagerCallBack.afterUnSuccessfulSMS(MySmsManager.this.smsId, "\u067e\u06cc\u0627\u0645\u06a9 \u0628\u0647 \u0645\u0642\u0635\u062f \u0646\u0631\u0633\u06cc\u062f");
                    }
                }
            }
        };
        this.context.registerReceiver(myReceiver, new IntentFilter(this.DELIVERED));
        SmsManager sms = SmsManager.getDefault();
        int subscriptionId = this.carrierSlotNumber;
        if (Build.VERSION.SDK_INT >= 22 && this.carrierSlotCount > 1) {
            if (this.checkCarrierNameFilter()) {
                SmsManager.getSmsManagerForSubscriptionId((int)subscriptionId).sendTextMessage(this.sms_number, null, message, sentPI, deliveredPI);
            } else {
                this.mySmsManagerCallBack.onCarrierNameNotMatch(this.smsId, "you can not send sms for this app from carrier:" + this.carrierName);
            }
        } else {
            sms.sendTextMessage(this.sms_number, null, message, sentPI, deliveredPI);
        }
    }

    private boolean checkCarrierNameFilter() {
        if (this.carrierNameFilter != null) {
            return this.carrierName.contains(this.carrierNameFilter);
        }
        return true;
    }

    public void setSms_number(String sms_number) {
        this.sms_number = sms_number;
    }

    public void setCarrierNameFilter(String carrierNameFilter) {
        this.carrierNameFilter = carrierNameFilter;
    }

    public static interface SMSManagerCallBack {
        public void afterSuccessfulSMS(int var1);

        public void afterDelivered(int var1);

        public void afterUnSuccessfulSMS(int var1, String var2);

        public void onCarrierNameNotMatch(int var1, String var2);
    }
}

