/*
 * Decompiled with CFR 0.152.
 */
package ir.mtajik.android.advancedPermissionsHandler;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AppCompatActivity;
import android.widget.Toast;
import ir.mtajik.android.advancedPermissionsHandler.MessageGenerator;
import java.util.ArrayList;
import java.util.List;

public abstract class PermissionHandlerActivity
extends AppCompatActivity
implements ActivityCompat.OnRequestPermissionsResultCallback {
    private static final int PERMISSION_CALLBACK_CONSTANT = 100;
    private static final int REQUEST_PERMISSION_SETTING = 101;
    SharedPreferences permissionStatus;
    private PermissionCallBack permissionCallBack;
    private String[] permissionsArray;
    private List<String> remainedPermissionsList = new ArrayList<String>();
    private Context context;
    private AppCompatActivity mActivity = new AppCompatActivity();
    private boolean mSticky = false;
    private String customMessage;

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 101 && this.permissionCallBack != null) {
            if (!this.checkIfNotGrantedOneOfPermissions()) {
                this.permissionCallBack.onPermissionsGranted();
            } else {
                this.permissionCallBack.onPermissionsDenied(this.convertListToArray(this.remainedPermissionsList));
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 100) {
            this.updatePermissionRequestStatus(permissions, grantResults);
            if (this.permissionCallBack != null) {
                if (this.remainedPermissionsList.size() == 0) {
                    this.permissionCallBack.onPermissionsGranted();
                } else if (this.mSticky) {
                    this.checkPermissionStuff();
                } else {
                    this.permissionCallBack.onPermissionsDenied(this.convertListToArray(this.remainedPermissionsList));
                }
            }
        }
    }

    public void askForPermission(String[] permissions, String message, boolean sticky, PermissionCallBack permissionGranted) {
        this.initialize(permissions, message, sticky, permissionGranted);
        this.checkPermissionStuff();
    }

    public void askForPermission(String[] permissions, boolean sticky, PermissionCallBack permissionGranted) {
        this.initialize(permissions, null, sticky, permissionGranted);
        this.checkPermissionStuff();
    }

    public void openSettingsForPermission() {
        Toast.makeText((Context)this, (CharSequence)MessageGenerator.makeToastDialogMessage(this.convertListToArray(this.remainedPermissionsList), (Context)this), (int)1).show();
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)this.getPackageName(), null);
        intent.setData(uri);
        this.startActivityForResult(intent, 101);
    }

    public String[] convertListToArray(List<String> list) {
        String[] converted = new String[this.remainedPermissionsList.size()];
        return list.toArray(converted);
    }

    private void updatePermissionRequestStatus(String[] permissions, int[] grantResults) {
        this.remainedPermissionsList.clear();
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] != 0) {
                this.remainedPermissionsList.add(permissions[i]);
                continue;
            }
            this.permissionStatus.edit().putBoolean(permissions[i], false).apply();
        }
    }

    private void checkPermissionStuff() {
        if (Build.VERSION.SDK_INT < 23 || this.checkIfNotGrantedOneOfPermissions()) {
            if (this.shouldShowRequestPermissionRationaleForAll()) {
                this.showPermissionDialog(this.convertListToArray(this.remainedPermissionsList));
            } else if (this.checkIfUserDeniedOneOfOurPermissionsBefore()) {
                this.openSettingsForPermission();
            } else {
                Toast.makeText((Context)this, (CharSequence)MessageGenerator.makeToastDialogMessage(this.permissionsArray, (Context)this), (int)0).show();
                this.askForPermission(this.permissionsArray);
            }
            this.updateAllPermissionToAskedOnce();
        } else if (this.permissionCallBack != null) {
            this.permissionCallBack.onPermissionsGranted();
        }
    }

    private void updateAllPermissionToAskedOnce() {
        for (String permission2 : this.permissionsArray) {
            this.permissionStatus.edit().putBoolean(permission2, true).apply();
        }
    }

    private boolean checkIfUserDeniedOneOfOurPermissionsBefore() {
        boolean ifJustOneIsDeniedForEver = false;
        this.remainedPermissionsList.clear();
        for (String permission2 : this.permissionsArray) {
            if (!this.permissionStatus.getBoolean(permission2, false)) continue;
            ifJustOneIsDeniedForEver = true;
            this.remainedPermissionsList.add(permission2);
        }
        return ifJustOneIsDeniedForEver;
    }

    private boolean shouldShowRequestPermissionRationaleForAll() {
        boolean oneNotGranted = false;
        this.remainedPermissionsList.clear();
        for (String permission2 : this.permissionsArray) {
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.mActivity, (String)permission2)) continue;
            oneNotGranted = true;
            this.remainedPermissionsList.add(permission2);
        }
        return oneNotGranted;
    }

    private boolean checkIfNotGrantedOneOfPermissions() {
        this.remainedPermissionsList.clear();
        boolean oneNotGranted = false;
        for (String permission2 : this.permissionsArray) {
            if (ActivityCompat.checkSelfPermission((Context)this, (String)permission2) == 0) continue;
            oneNotGranted = true;
            this.remainedPermissionsList.add(permission2);
        }
        return oneNotGranted;
    }

    private void initialize(String[] permissions, @Nullable String message, boolean sticky, PermissionCallBack mPermissionCallBack) {
        this.mActivity = this;
        this.permissionCallBack = mPermissionCallBack;
        this.context = this;
        this.permissionsArray = permissions;
        this.mSticky = sticky;
        this.customMessage = this.customMessage;
        this.permissionStatus = this.getSharedPreferences("permissionStatus", 0);
    }

    private void showPermissionDialog(final String[] permissions) {
        AlertDialog.Builder alertDialog = new AlertDialog.Builder(this.context);
        alertDialog.setMessage((CharSequence)MessageGenerator.makeAlertDialogMessage(permissions, (Context)this)).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                PermissionHandlerActivity.this.askForPermission(permissions);
            }
        }).setNegativeButton((CharSequence)"cancel", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (PermissionHandlerActivity.this.mSticky) {
                    PermissionHandlerActivity.this.openSettingsForPermission();
                } else if (PermissionHandlerActivity.this.permissionCallBack != null) {
                    PermissionHandlerActivity.this.permissionCallBack.onPermissionsDenied(permissions);
                }
            }
        }).setIcon(17301543).show();
    }

    private void askForPermission(String[] permissions) {
        ActivityCompat.requestPermissions((Activity)this.mActivity, (String[])permissions, (int)100);
    }

    public static interface PermissionCallBack {
        public void onPermissionsGranted();

        public void onPermissionsDenied(String[] var1);
    }
}

