package ir.map.sdk_services.repository;

import android.graphics.Bitmap;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import ir.map.sdk_common.MapirLatLng;
import ir.map.sdk_services.PublicTransportMode;
import ir.map.sdk_services.RouteMode;
import ir.map.sdk_services.models.MapirAuthenticateResponse;
import ir.map.sdk_services.models.MapirBookmark;
import ir.map.sdk_services.models.MapirForgotEntity;
import ir.map.sdk_services.models.MapirLoginResponse;
import ir.map.sdk_services.models.MapirMedia;
import ir.map.sdk_services.models.MapirNetworkEntity;
import ir.map.sdk_services.models.MapirProfileResponse;
import ir.map.sdk_services.models.MapirPublicTransportResponse;
import ir.map.sdk_services.models.MapirResendVerification;
import ir.map.sdk_services.models.MapirReverse;
import ir.map.sdk_services.models.MapirRouteResponse;
import ir.map.sdk_services.models.MapirSearchPostCode;
import ir.map.sdk_services.models.MapirSearchResponse;
import ir.map.sdk_services.models.MapirSimpleNetworkEntity;
import ir.map.sdk_services.models.MapirTag;
import ir.map.sdk_services.models.MapirTicket;
import ir.map.sdk_services.models.MapirWeatherItem;
import ir.map.sdk_services.network.RestApi;
import ir.map.sdk_services.network.RestApiImpl;
import okhttp3.RequestBody;
import rx.Observable;

/**
 * @author Haniyeh Khaksar
 */

public class NetworkRepository implements INetworkRepository {

    private RestApi restApi = null;

    public NetworkRepository() {
        restApi = new RestApiImpl();
    }

    @Override
    public Observable<MapirReverse> getReverseGeoInfo(String params) {
        return restApi.getReverseGeoInfo(params);
    }

    @Override
    public Observable<MapirWeatherItem> getWeatherInfo(String params) {
        return restApi.getWeatherInfo(params);
    }

    @Override
    public Observable<List<MapirWeatherItem>> getAllWeatherInfo() {
        return restApi.getAllWeatherInfo();
    }

//    @Override
//    public Observable<List<MapirSearch>> getPointOfInterests() {
//        return restApi.getPointOfInterests();
//    }

    @Override
    public Observable<MapirSimpleNetworkEntity> sendTicket(String token, String params) {
        return restApi.sendTicket(token, params);
    }

    @Override
    public Observable<MapirSimpleNetworkEntity> sendReportTicket(String token, String params) {
        return restApi.sendReportTicket(token, params);
    }

    @Override
    public Observable<List<MapirTicket>> getTicketList(String token) {
        return restApi.getTicketList(token);
    }

    @Override
    public Observable<MapirMedia> uploadMediaByPath(String token, String path) {
        return restApi.uploadMediaByPath(token, path);
    }

    @Override
    public Observable<MapirMedia> uploadMediaByFile(String token, File file) {
        return restApi.uploadMediaByFile(token, file);
    }

    @Override
    public Observable<MapirSimpleNetworkEntity> createOrModifyTag(String token, String params) {
        return restApi.createOrModifyTag(token, params);
    }

    @Override
    public Observable<ArrayList<MapirTag>> getTagList(int type, String token, int skip) {
        return restApi.getTagList(type, token, skip);
    }

    @Override
    public Observable<MapirSimpleNetworkEntity> deleteTag(String token, String id) {
        return restApi.deleteTag(token, id);
    }

    @Override
    public Observable<MapirSearchResponse> search(String params) {
        return restApi.search(params);
    }

    @Override
    public Observable<MapirSearchResponse> autoCompleteSearch(String params) {
        return restApi.autoCompleteSearch(params);
    }

    @Override
    public Observable<MapirSearchPostCode> searchPostCode(String params) {
        return restApi.searchPostCode(params);
    }

    @Override
    public Observable<MapirSimpleNetworkEntity> createBookmark(String token, String params) {
        return restApi.createBookmark(token, params);
    }

    @Override
    public Observable<List<MapirBookmark>> getBookmarkList(String token, int skip) {
        return restApi.getBookmarkList(token, skip);
    }

    @Override
    public Observable<MapirSimpleNetworkEntity> deleteBookmark(String token, String id) {
        return restApi.deleteBookmark(token, id);
    }

    @Override
    public Observable<MapirRouteResponse> getRouteInfo(MapirLatLng startPosition, MapirLatLng endPosition, RouteMode routeMode) {
        return restApi.getRouteInfo(startPosition, endPosition, routeMode);
    }

    @Override
    public Observable<MapirRouteResponse> getMultipleRouteInfo(MapirLatLng startPosition, List<MapirLatLng> destinations, RouteMode routeMode) {
        return restApi.getMultipleRouteInfo(startPosition, destinations, routeMode);
    }

    @Override
    public Observable<MapirRouteResponse> getGlobalRouteInfo(MapirLatLng startPosition, MapirLatLng endPosition, RouteMode routeMode) {
        return restApi.getGlobalRouteInfo(startPosition, endPosition, routeMode);
    }

    @Override
    public Observable<Bitmap> getStaticMap(double latitude, double longitude, int zoom) {
        return restApi.getStaticMap(latitude, longitude, zoom);
    }

    @Override
    public Observable<MapirNetworkEntity> sendFeedback(RequestBody body) {
        return restApi.sendFeedback(body);
    }

    @Override
    public Observable<MapirLoginResponse> loginUser(String params) {
        return restApi.loginUser(params);
    }

    @Override
    public Observable<MapirForgotEntity> forgetPassword(String params) {
        return restApi.forgetPassword(params);
    }

    @Override
    public Observable<MapirAuthenticateResponse> signupUser(String authParams) {
        return restApi.signupUser(authParams);
    }

    @Override
    public Observable<MapirSimpleNetworkEntity> signoutUser(String token) {
        return restApi.signoutUser(token);
    }

    @Override
    public Observable<MapirLoginResponse> loginUserByGmail(String token) {
        return restApi.loginUserByGmail(token);
    }

    @Override
    public Observable<MapirAuthenticateResponse> verifyUser(String params) {
        return restApi.verifyUser(params);
    }

    @Override
    public Observable<MapirResendVerification> resendVerificationCode(String params) {
        return restApi.resendVerificationCode(params);
    }

    @Override
    public Observable<List<MapirTag>> getTag(String token, String params) {
        return restApi.getTag(token, params);
    }

    @Override
    public Observable<MapirProfileResponse> getProfile(String userName, String token) {
        return restApi.getProfile(userName, token);
    }

    @Override
    public Observable<MapirProfileResponse> updateProfile(String userName, String token, String params) {
        return restApi.updateProfile(userName, token, params);
    }

    @Override
    public Observable<MapirPublicTransportResponse> getPublicTrnasportRoute(MapirLatLng startPosition,
                                                                            MapirLatLng endPosition,
                                                                            Double walkDistance,
                                                                            PublicTransportMode routeMode) {
        return restApi.getPublicTransportRoute(startPosition, endPosition, walkDistance, routeMode);
    }

}
