package ir.map.sdk_services;

import android.graphics.Bitmap;

import com.google.gson.Gson;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import ir.map.sdk_common.MapirLatLng;
import ir.map.sdk_services.models.MapirAuthenticate;
import ir.map.sdk_services.models.MapirAuthenticateResponse;
import ir.map.sdk_services.models.MapirBookmark;
import ir.map.sdk_services.models.MapirError;
import ir.map.sdk_services.models.MapirForgotEntity;
import ir.map.sdk_services.models.MapirGeometry;
import ir.map.sdk_services.models.MapirLogin;
import ir.map.sdk_services.models.MapirLoginResponse;
import ir.map.sdk_services.models.MapirMedia;
import ir.map.sdk_services.models.MapirNetworkEntity;
import ir.map.sdk_services.models.MapirProfile;
import ir.map.sdk_services.models.MapirProfileResponse;
import ir.map.sdk_services.models.MapirPublicTransportResponse;
import ir.map.sdk_services.models.MapirReportTicket;
import ir.map.sdk_services.models.MapirResendVerification;
import ir.map.sdk_services.models.MapirReverse;
import ir.map.sdk_services.models.MapirRouteResponse;
import ir.map.sdk_services.models.MapirSearch;
import ir.map.sdk_services.models.MapirSearchPostCode;
import ir.map.sdk_services.models.MapirSearchResponse;
import ir.map.sdk_services.models.MapirSimpleNetworkEntity;
import ir.map.sdk_services.models.MapirTag;
import ir.map.sdk_services.models.MapirTicket;
import ir.map.sdk_services.models.MapirWeatherItem;
import ir.map.sdk_services.models.base.ResponseListener;
import ir.map.sdk_services.repository.NetworkRepository;
import okhttp3.RequestBody;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.schedulers.Schedulers;

/**
 * @author haniyeh khaksar
 */

public class ServiceHelper {

    private NetworkRepository repository;

    public ServiceHelper() {
        repository = new NetworkRepository();
    }

    public void getWeatherInfo(Double latitude, Double longitude, final ResponseListener<MapirWeatherItem> listener) {
//        String params = String.format("lat=%s&lon=%s&units=metric&appid=%s", latitude, longitude, URLHelper.OPEN_WEATEHR_MAP_KEY);
        repository.getWeatherInfo(latitude + "," + longitude).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MapirWeatherItem>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MapirError(e.getMessage()));
                    }

                    @Override
                    public void onNext(MapirWeatherItem maptexWeatherItem) {
                        listener.onSuccess(maptexWeatherItem);
                    }
                });
    }

    public void getAllWeatherInfo(final ResponseListener<List<MapirWeatherItem>> listener) {
        repository.getAllWeatherInfo().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<List<MapirWeatherItem>>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MapirError(e.getMessage()));
                    }

                    @Override
                    public void onNext(List<MapirWeatherItem> maptexWeatherItem) {
                        listener.onSuccess(maptexWeatherItem);
                    }
                });
    }

    private void sendTicket(String token, final MapirTicket ticket, final ResponseListener<MapirSimpleNetworkEntity> listener) {

        String ticketJson = new Gson().toJson(ticket);
        repository.sendTicket(token, ticketJson).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MapirSimpleNetworkEntity>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MapirError(e.getMessage()));
                    }

                    @Override
                    public void onNext(MapirSimpleNetworkEntity maptexSimpleNetworkEntity) {
                        listener.onSuccess(maptexSimpleNetworkEntity);
                    }
                });


    }

    private void sendReportTag(String token, final String tagId, final ResponseListener<MapirSimpleNetworkEntity> listener) {
        MapirReportTicket reportTicket = new MapirReportTicket();
        reportTicket.description = "tag:" + tagId;
        String ticketJson = new Gson().toJson(reportTicket);
        repository.sendReportTicket(token, ticketJson).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MapirSimpleNetworkEntity>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MapirError(e.getMessage()));
                    }

                    @Override
                    public void onNext(MapirSimpleNetworkEntity maptexSimpleNetworkEntity) {
                        listener.onSuccess(maptexSimpleNetworkEntity);
                    }
                });


    }

    public void getReverseGeoInfo(Double latitude, Double longitude, final ResponseListener<MapirReverse> listener) {
        String params = String.format("lat=%s&lon=%s", latitude, longitude);
        repository.getReverseGeoInfo(params).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MapirReverse>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MapirError(e.getMessage()));
                    }

                    @Override
                    public void onNext(MapirReverse maptexReverse) {
                        listener.onSuccess(maptexReverse);
                    }
                });
    }

    private void getTicketList(String token, final ResponseListener<List<MapirTicket>> listener) {
        repository.getTicketList(token).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<List<MapirTicket>>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MapirError(e.getMessage()));
                    }

                    @Override
                    public void onNext(List<MapirTicket> maptexTickets) {
                        listener.onSuccess(maptexTickets);
                    }
                });


    }

    private void uploadMediasByPath(String token, final List<String> mediaPaths, final ResponseListener<List<MapirMedia>> listener) {
        final List<MapirMedia> medias = new ArrayList<>();
        for (String path : mediaPaths) {
            repository.uploadMediaByPath(token, path).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                    .subscribe(new Subscriber<MapirMedia>() {
                        @Override
                        public void onCompleted() {

                        }

                        @Override
                        public void onError(Throwable e) {
                            listener.onError(new MapirError(e.getMessage()));
                        }

                        @Override
                        public void onNext(MapirMedia maptexMedia) {
                            medias.add(maptexMedia);
                            if (medias.size() == mediaPaths.size()) {
                                listener.onSuccess(medias);
                            }
                        }
                    });
        }

    }

    private void uploadMediasByFile(String token, final List<File> mediaFiles, final ResponseListener<List<MapirMedia>> listener) {
        final List<MapirMedia> medias = new ArrayList<>();
        for (File file : mediaFiles) {
            repository.uploadMediaByFile(token, file).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                    .subscribe(new Subscriber<MapirMedia>() {
                        @Override
                        public void onCompleted() {

                        }

                        @Override
                        public void onError(Throwable e) {
                            listener.onError(new MapirError(e.getMessage()));
                        }

                        @Override
                        public void onNext(MapirMedia maptexMedia) {
                            medias.add(maptexMedia);
                            if (medias.size() == mediaFiles.size()) {
                                listener.onSuccess(medias);
                            }
                        }
                    });
        }

    }

    private void createOrModifyTag(String token, final MapirTag maptexTag, final ResponseListener<MapirSimpleNetworkEntity> listener) {

        String tagJson = new Gson().toJson(maptexTag);
        repository.createOrModifyTag(token, tagJson).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MapirSimpleNetworkEntity>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MapirError(e.getMessage()));
                    }

                    @Override
                    public void onNext(MapirSimpleNetworkEntity simpleNetworkEntity) {
                        listener.onSuccess(simpleNetworkEntity);
                    }
                });

    }

    private void getTagList(int type, String token, final int skip, final ResponseListener<ArrayList<MapirTag>> listener) {

        repository.getTagList(type, token, skip).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<ArrayList<MapirTag>>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MapirError(e.getMessage()));
                    }

                    @Override
                    public void onNext(ArrayList<MapirTag> maptexTags) {
                        listener.onSuccess(maptexTags);
                    }
                });

    }

    private void deleteTag(String token, final String id, final ResponseListener<MapirSimpleNetworkEntity> listener) {

        repository.deleteTag(token, id).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MapirSimpleNetworkEntity>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MapirError(e.getMessage()));
                    }

                    @Override
                    public void onNext(MapirSimpleNetworkEntity maptexTags) {
                        listener.onSuccess(maptexTags);
                    }
                });

    }

    public void search(String text, Double lat, Double lng, List<MapirLatLng> coordinates, final ResponseListener<MapirSearchResponse> listener) {
        MapirSearch maptexSearch = new MapirSearch();
        maptexSearch.text = text;
        maptexSearch.location = new MapirGeometry();
        maptexSearch.location.coordinates = new ArrayList<>();
        maptexSearch.location.coordinates.add(lng == null ? 0.0 : lng);
        maptexSearch.location.coordinates.add(lat == null ? 0.0 : lat);
        maptexSearch.location.type = "Point";
//        maptexSearch.top = "10";
        if (coordinates != null && !coordinates.isEmpty()) {
            maptexSearch.geom = new MapirSearch.MaptexPosition();
            maptexSearch.geom.coordinates = new ArrayList<>();
            List<Double> pos;
            for (int i = 0; i < coordinates.size(); i++) {
                pos = new ArrayList<>();
                pos.add(coordinates.get(i).longitude);
                pos.add(coordinates.get(i).latitude);
                maptexSearch.geom.coordinates.add(pos);
                if (i == coordinates.size() - 1) {
                    pos = new ArrayList<>();
                    pos.add(coordinates.get(0).longitude);
                    pos.add(coordinates.get(0).latitude);
                    maptexSearch.geom.coordinates.add(pos);
                }
            }
            maptexSearch.geom.type = "Polygon";
        }

        String searchJson = new Gson().toJson(maptexSearch);
        repository.search(searchJson).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MapirSearchResponse>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MapirError(e.getMessage()));
                    }

                    @Override
                    public void onNext(MapirSearchResponse maptexSearchs) {
                        listener.onSuccess(maptexSearchs);
                    }
                });
    }

    public void searchPostCode(String text, final ResponseListener<MapirSearchPostCode> listener) {
        repository.searchPostCode(text).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MapirSearchPostCode>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MapirError(e.getMessage()));
                    }

                    @Override
                    public void onNext(MapirSearchPostCode maptexSearchs) {
                        listener.onSuccess(maptexSearchs);
                    }
                });
    }

    public void autoCompleteSearch(String text, Double lat, Double lng, List<MapirLatLng> coordinates, final ResponseListener<MapirSearchResponse> listener) {
        MapirSearch maptexSearch = new MapirSearch();
        maptexSearch.text = text;
        maptexSearch.location = new MapirGeometry();
        maptexSearch.location.coordinates = new ArrayList<>();
        maptexSearch.location.coordinates.add(lng == null ? 0.0 : lng);
        maptexSearch.location.coordinates.add(lat == null ? 0.0 : lat);
        maptexSearch.location.type = "Point";

        String searchJson = new Gson().toJson(maptexSearch);
        repository.autoCompleteSearch(searchJson).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MapirSearchResponse>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MapirError(e.getMessage()));
                    }

                    @Override
                    public void onNext(MapirSearchResponse maptexSearchs) {
                        listener.onSuccess(maptexSearchs);
                    }
                });
    }

    private void createBookmark(String token, final MapirBookmark maptexBookmark, final ResponseListener<MapirSimpleNetworkEntity> listener) {

        String bookmarkJson = new Gson().toJson(maptexBookmark);
        repository.createBookmark(token, bookmarkJson).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MapirSimpleNetworkEntity>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MapirError(e.getMessage()));
                    }

                    @Override
                    public void onNext(MapirSimpleNetworkEntity simpleNetworkEntity) {
                        listener.onSuccess(simpleNetworkEntity);
                    }
                });

    }

    private void getBookmarkList(String token, final int skip, final ResponseListener<List<MapirBookmark>> listener) {

        repository.getBookmarkList(token, skip).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<List<MapirBookmark>>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MapirError(e.getMessage()));
                    }

                    @Override
                    public void onNext(List<MapirBookmark> maptexBookmarks) {
                        listener.onSuccess(maptexBookmarks);
                    }
                });


    }

    private void deleteBookmark(String token, final String id, final ResponseListener<MapirSimpleNetworkEntity> listener) {
        repository.deleteBookmark(token, id).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MapirSimpleNetworkEntity>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MapirError(e.getMessage()));
                    }

                    @Override
                    public void onNext(MapirSimpleNetworkEntity maptexTags) {
                        listener.onSuccess(maptexTags);
                    }
                });
    }

    public void getRouteInfo(MapirLatLng startPosition, MapirLatLng endPosition, RouteMode routeMode,
                             final ResponseListener<MapirRouteResponse> listener) {

        repository.getRouteInfo(startPosition, endPosition, routeMode).subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MapirRouteResponse>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MapirError(e.getMessage()));
                    }

                    @Override
                    public void onNext(MapirRouteResponse maptexRouteInfo) {
                        listener.onSuccess(maptexRouteInfo);
                    }
                });
    }

    public void getMultipleRouteInfo(MapirLatLng startPosition, List<MapirLatLng> destinations, RouteMode routeMode,
                             final ResponseListener<MapirRouteResponse> listener) {

        repository.getMultipleRouteInfo(startPosition, destinations, routeMode).subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MapirRouteResponse>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MapirError(e.getMessage()));
                    }

                    @Override
                    public void onNext(MapirRouteResponse maptexRouteInfo) {
                        listener.onSuccess(maptexRouteInfo);
                    }
                });
    }

    public void getPublicTrnasportRoute(MapirLatLng startPosition, MapirLatLng endPosition, PublicTransportMode routeMode,
                                        Double walkDistance,
                                        final ResponseListener<MapirPublicTransportResponse> listener) {

        repository.getPublicTrnasportRoute(startPosition, endPosition, walkDistance, routeMode).subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MapirPublicTransportResponse>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MapirError(e.getMessage()));
                    }

                    @Override
                    public void onNext(MapirPublicTransportResponse maptexRouteInfo) {
                        listener.onSuccess(maptexRouteInfo);
                    }
                });
    }

    public void getGlobalRouteInfo(MapirLatLng startPosition, MapirLatLng endPosition, RouteMode routeMode,
                                   final ResponseListener<MapirRouteResponse> listener) {

        repository.getGlobalRouteInfo(startPosition, endPosition, routeMode).subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MapirRouteResponse>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MapirError(e.getMessage()));
                    }

                    @Override
                    public void onNext(MapirRouteResponse maptexRouteInfo) {
                        listener.onSuccess(maptexRouteInfo);
                    }
                });
    }

    public void getStaticMap(double latitude, double longitude, int zoom, final ResponseListener<Bitmap> listener) {

        repository.getStaticMap(latitude, longitude, zoom).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<Bitmap>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        listener.onError(new MapirError(e.getMessage()));
                    }

                    @Override
                    public void onNext(Bitmap bitmap) {
                        listener.onSuccess(bitmap);
                    }
                });
    }

    private void sendFeedback(RequestBody body,
                              final ResponseListener<MapirNetworkEntity> listener) {
        repository.sendFeedback(body).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MapirNetworkEntity>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        String message = e.getMessage();
                        e.printStackTrace();
                        listener.onError(new MapirError(message));
                    }

                    @Override
                    public void onNext(MapirNetworkEntity maptexNetworkEntity) {
                        listener.onSuccess(maptexNetworkEntity);
                    }
                });
    }

    private void signupUser(MapirAuthenticate authenticate, final ResponseListener<MapirAuthenticateResponse> listener) {
        String params = new Gson().toJson(authenticate);
        repository.signupUser(params).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MapirAuthenticateResponse>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        String message = e.getMessage();
                        e.printStackTrace();
                        listener.onError(new MapirError(message));
                    }

                    @Override
                    public void onNext(MapirAuthenticateResponse maptexLoginResponse) {
                        listener.onSuccess(maptexLoginResponse);
                    }
                });
    }

    private void verifyUser(String code, String phoneNumber, final ResponseListener<MapirAuthenticateResponse> listener) {
        String params = "/" + phoneNumber + "/" + code;
        repository.verifyUser(params).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MapirAuthenticateResponse>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        String message = e.getMessage();
                        e.printStackTrace();
                        listener.onError(new MapirError(message));
                    }

                    @Override
                    public void onNext(MapirAuthenticateResponse maptexLoginResponse) {

                        listener.onSuccess(maptexLoginResponse);
                    }
                });
    }

    private void resendVerificationCode(String phoneNumber, final ResponseListener<MapirResendVerification> listener) {
        String params = "/" + phoneNumber;
        repository.resendVerificationCode(params).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MapirResendVerification>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        String message = e.getMessage();
                        e.printStackTrace();
                        listener.onError(new MapirError(message));
                    }

                    @Override
                    public void onNext(MapirResendVerification maptexResendVerification) {
                        listener.onSuccess(maptexResendVerification);
                    }
                });
    }

    private void loginUser(final LoginResponse loginResponse) {
        MapirLogin login = new MapirLogin();
        login.user = "hani";
        login.pass = "123456789";
        String loginParams = new Gson().toJson(login);
        repository.loginUser(loginParams).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MapirLoginResponse>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        String message = e.getMessage();
                        e.printStackTrace();
                        loginResponse.loginUserFailed(message);
                    }

                    @Override
                    public void onNext(MapirLoginResponse maptexLoginResponse) {

                        loginResponse.loginUserSuccessful();
                    }
                });
    }

    private void loginUser(MapirLogin login, final ResponseListener<MapirLoginResponse> loginResponse) {
        String loginParams = new Gson().toJson(login);
        repository.loginUser(loginParams).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MapirLoginResponse>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        String message = e.getMessage();
                        e.printStackTrace();
                        loginResponse.onError(new MapirError(message));
                    }

                    @Override
                    public void onNext(MapirLoginResponse maptexLoginResponse) {

                        loginResponse.onSuccess(maptexLoginResponse);
                    }
                });
    }

    private void forgetPassword(String username, final ResponseListener<MapirForgotEntity> loginResponse) {
        repository.forgetPassword(username).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MapirForgotEntity>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        String message = e.getMessage();
                        e.printStackTrace();
                        loginResponse.onError(new MapirError(message));
                    }

                    @Override
                    public void onNext(MapirForgotEntity message) {
                        loginResponse.onSuccess(message);
                    }
                });
    }

    private void loginUserByGmail(String token, final ResponseListener<MapirLoginResponse> responseListener) {
        repository.loginUserByGmail(token).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MapirLoginResponse>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        String message = e.getMessage();
                        e.printStackTrace();
                        responseListener.onError(new MapirError(message));
                    }

                    @Override
                    public void onNext(MapirLoginResponse maptexLoginResponse) {

                        responseListener.onSuccess(maptexLoginResponse);
                    }
                });
    }

    private void signoutUser(String token, final ResponseListener<MapirSimpleNetworkEntity> listener) {
        repository.signoutUser(token).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MapirSimpleNetworkEntity>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        String message = e.getMessage();
                        e.printStackTrace();
                        listener.onError(new MapirError(message));
                    }

                    @Override
                    public void onNext(MapirSimpleNetworkEntity maptexLoginResponse) {

                        listener.onSuccess(maptexLoginResponse);
                    }
                });
    }

    private void getTag(String token, String tagId, final ResponseListener<MapirTag> listener) {
        repository.getTag(token, tagId).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<List<MapirTag>>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        String message = e.getMessage();
                        e.printStackTrace();
                        listener.onError(new MapirError(message));
                    }

                    @Override
                    public void onNext(List<MapirTag> maptexTag) {

                        listener.onSuccess(maptexTag.get(0));
                    }
                });
    }

    private void getProfile(String userName, String token, final ResponseListener<MapirProfileResponse> listener) {
        repository.getProfile(userName, token).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MapirProfileResponse>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        String message = e.getMessage();
                        e.printStackTrace();
                        listener.onError(new MapirError(message));
                    }

                    @Override
                    public void onNext(MapirProfileResponse profileResponses) {

                        listener.onSuccess(profileResponses);
                    }
                });
    }

    private void updateProfile(String userName, String token, String nickname, String phone,
                               String mail, String address, final ResponseListener<MapirProfileResponse> listener) {
        MapirProfile profile = new MapirProfile();
        MapirProfile.ProfileData data = new MapirProfile.ProfileData();
        data.nickname = new String[]{nickname};
        data.phone = new String[]{phone};
        data.email = new String[]{mail};
        data.address = new String[]{address};
        profile.data = data;

        String profileJson = new Gson().toJson(profile);

        repository.updateProfile(userName, token, profileJson).subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MapirProfileResponse>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        String message = e.getMessage();
                        e.printStackTrace();
                        listener.onError(new MapirError(message));
                    }

                    @Override
                    public void onNext(MapirProfileResponse profileResponses) {

                        listener.onSuccess(profileResponses);
                    }
                });

    }

    private interface LoginResponse {
        void loginUserSuccessful();

        void loginUserFailed(String error);
    }
}
