package ir.map.sdk_services;


import android.annotation.SuppressLint;

import ir.map.sdk_common.MapirLatLng;

/**
 * @author Haniyeh Khaksar
 */

public class URLHelper {

    public static final int FIRST_POS = 0;
    public static final int SECOND_POS = 1;
    public static final int THIRD_POS = 2;

    public static final byte[] MAP_LAYERS = new byte[]{'S', 'h', 'i', 'v', 'e', 'h', ':', 'S', 'h', 'i', 'v', 'e', 'h'};
    public static final byte[] SHIVEH_BASE_URL = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r'};// 'o', 'l', 'd', '.',
    //    public static final byte[] ROUTE_SHIVEH_BASE_URL = new byte[]{'h','t','t','p',':','/','/','r','o','u','t','e','.','m','a','p','.','i','r','/'};
    public static final byte[] MAP_BASE_URL = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 's', 'h', 'i', 'v', 'e', 'h', '?'};
    public static final byte[] MAP_REVERSE_GEO_URL = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 'r', 'e', 'v', 'e', 'r', 's', 'e', '?'};
    public static final byte[] MESSAGE_URL = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'j', 's', 'o', 'n', 'p', 'l', 'a', 'c', 'e', 'h', 'o', 'l', 'd', 'e', 'r', '.', 't', 'y', 'p', 'i', 'c', 'o', 'd', 'e', '.', 'c', 'o', 'm', '/', 'p', 'o', 's', 't', 's'};
    public static final byte[] SIGN_IN_OUT_URL = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 'a', 'u', 't', 'h', 'e', 'n', 't', 'i', 'c', 'a', 't', 'e'};
    public static final byte[] FORGOT_PASSWORD_URL = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 'a', 'u', 't', 'h', '/', 'f', 'o', 'r', 'g', 'o', 't', '-', 'p', 'a', 's', 's', 'w', 'o', 'r', 'd', '?'};
    public static final String TILE_COMPLITION = "shiveh?" +
            "service=WMS" +
            "&version=1.1.0" +
            "&EXCEPTIONS=application/vnd.ogc.se_inimage" +
            "&request=GetMap" +
            "&layers=Shiveh:Shiveh" +
            "&width=256" +
            "&height=256" +
            "&srs=EPSG:3857" +
            "&format=image/png" +
            "&bbox=%f,%f,%f,%f";
    public static final byte[] MAP_CREATE_TICKET_URL = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 't', 'b', 't', '/', 't', 'i', 'c', 'k', 'e', 't', 's'};
    public static final byte[] MAP_CREATE_REPORT_TICKET_URL = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 't', 'b', 't', '/', 't', 'i', 'c', 'k', 'e', 't', 's', '/', 'r', 'e', 'p', 'o', 'r', 't'};
    public static final byte[] MAP_TICKET_URL = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 't', 'b', 't', '/', 't', 'i', 'c', 'k', 'e', 't', 's'};
    public static final byte[] UPLOAD_MEDIA_URL = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 'm', 'e', 'd', 'i', 'a', '/'};
    public static final byte[] WEATHER_URL = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 'w', 'e', 'a', 't', 'h', 'e', 'r', '/', 'w', 'e', 'a', 't', 'h', 'e', 'r', '/'};
    public static final byte[] WEATHER_ALL_URL = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 'w', 'e', 'a', 't', 'h', 'e', 'r', '/', 'w', 'e', 'a', 't', 'h', 'e', 'r', 's', '/', 'a', 'l', 'l', '/'};
    public static final byte[] TAG_BASE_URL = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 't', 'b', 't', '/', 't', 'a', 'g', 's'};
    public static final byte[] SEARCH_ADDRESS_API = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 's', 'e', 'a', 'r', 'c', 'h'};

    public static final byte[] SEARCH_AUTO_COMPLETE_API = new byte[] {'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 's', 'e', 'a', 'r', 'c', 'h', '/', 'a', 'u', 't', 'o', 'c', 'o', 'm', 'p', 'l', 'e', 't', 'e'};

    public static final byte[] SEARCH_POST_CODE_API = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'o', 'l', 'd', '.', 'm', 'a', 'p', '.', 'i', 'r', '/', 'g', 'e', 'o', 'c', 'o', 'd', 'e', '/', 'p', 'o', 's', 't', 'c', 'o', 'd', 'e', '/', 's', 'e', 'a', 'r', 'c', 'h', '/'};
    public static final byte[] MAP_BOOKMARK_URL = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 't', 'b', 't', '/', 'b', 'o', 'o', 'k', 'm', 'a', 'r', 'k', 's'};
    public static final byte[] MAP_BOOKMARK_URL_LIST = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 't', 'b', 't', '/', 'b', 'o', 'o', 'k', 'm', 'a', 'r', 'k', 's'};
    public static final byte[] BICYCLE_ROUTE_DRIVING_URL = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 'r', 'o', 'u', 't', 'e', 's', '/', 'b', 'i', 'c', 'y', 'c', 'l', 'e', '/', 'v', '1', '/', 'd', 'r', 'i', 'v', 'i', 'n', 'g', '/'};
    public static final byte[] BICYCLE_GLOBAL_ROUTE_DRIVING_URL = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'w', 'o', 'r', 'l', 'd', '.', 'm', 'a', 'p', '.', 'i', 'r', '/', 'r', 'o', 'u', 't', 'e', 's', '/', 'b', 'i', 'c', 'y', 'c', 'l', 'e', '/', 'v', '1', '/', 'd', 'r', 'i', 'v', 'i', 'n', 'g', '/'};
    public static final byte[] WALK_ROUTE_DRIVING_URL = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 'r', 'o', 'u', 't', 'e', 's', '/', 'f', 'o', 'o', 't', '/', 'v', '1', '/', 'd', 'r', 'i', 'v', 'i', 'n', 'g', '/'};
    //https://world.map.ir/routes/foot/v1/driving/51.503906,35.710838;42.099609,33.155948?alternatives=true&steps=true&overview=false&hints=;
    public static final byte[] WALK_GLOBAL_ROUTE_DRIVING_URL = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'w', 'o', 'r', 'l', 'd', '.', 'm', 'a', 'p', '.', 'i', 'r', '/', 'r', 'o', 'u', 't', 'e', 's', '/', 'f', 'o', 'o', 't', '/', 'v', '1', '/', 'd', 'r', 'i', 'v', 'i', 'n', 'g', '/'};
    public static final byte[] POI_SEARCH_ADDRESS_API = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 's', 'e', 'a', 'r', 'c', 'h'};
    public static final byte[] LOCAL_URL_GMAIL_LOGIN = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 'a', 'u', 't', 'h', '/', 's', 'o', 'c', 'i', 'a', 'l', '/', 'm', 'o', 'b', 'i', 'l', 'e', '/', 'r', 'e', 'd', 'i', 'r', 'e', 'c', 't', '?', 't', 'o', 'k', 'e', 'n', '='};
    public static final byte[] DEFAULT_ROUTE_DRIVING_URL = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 'r', 'o', 'u', 't', 'e', 's', '/', 'r', 'o', 'u', 't', 'e', '/', 'v', '1', '/', 'd', 'r', 'i', 'v', 'i', 'n', 'g', '/'};
    public static final byte[] DEFAULT_GLOBAL_ROUTE_DRIVING_URL = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'w', 'o', 'r', 'l', 'd', '.', 'm', 'a', 'p', '.', 'i', 'r', '/', 'r', 'o', 'u', 't', 'e', 's', '/', 'r', 'o', 'u', 't', 'e', '/', 'v', '1', '/', 'd', 'r', 'i', 'v', 'i', 'n', 'g', '/'};
    public static final byte[] DEFAULT_ROUTE_DRIVING_URL_TEMP = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 'r', 'o', 'u', 't', 'e', 's', '/', 'f', 'u', 'l', 'l', '/', 'v', '1', '/', 'd', 'r', 'i', 'v', 'i', 'n', 'g', '/'};
    //   'h','t','t','p',':','/','/','m','a','p','.','i','r','/','r','o','u','t','e','s','/','f','o','o','t','/','v','1','/','d','r','i','v','i','n','g','/'
    public static final byte[] EVENODD_ROUTE_DRIVING_URL = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 'r', 'o', 'u', 't', 'e', 's', '/', 'z', 'o', 'j', 'o', 'f', 'a', 'r', 'd', '/', 'v', '1', '/', 'd', 'r', 'i', 'v', 'i', 'n', 'g', '/'};
    public static final byte[] EVENODD_GLOBAL_ROUTE_DRIVING_URL = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'w', 'o', 'r', 'l', 'd', '.', 'm', 'a', 'p', '.', 'i', 'r', '/', 'r', 'o', 'u', 't', 'e', 's', '/', 'z', 'o', 'j', 'o', 'f', 'a', 'r', 'd', '/', 'v', '1', '/', 'd', 'r', 'i', 'v', 'i', 'n', 'g', '/'};
    public static final byte[] TRAFFIC_ROUTE_DRIVING_URL = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 'r', 'o', 'u', 't', 'e', 's', '/', 't', 'a', 'r', 'h', '/', 'v', '1', '/', 'd', 'r', 'i', 'v', 'i', 'n', 'g', '/'};
    public static final byte[] TRAFFIC_GLOBAL_ROUTE_DRIVING_URL = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'w', 'o', 'r', 'l', 'd', '.', 'm', 'a', 'p', '.', 'i', 'r', '/', 'r', 'o', 'u', 't', 'e', 's', '/', 't', 'a', 'r', 'h', '/', 'v', '1', '/', 'd', 'r', 'i', 'v', 'i', 'n', 'g', '/'};
    public static final String STATIC_MAP = new String(SHIVEH_BASE_URL) + "/static?width=%s&height=%s&markers=color:blue|%s,%s&&zoom_level=%s";
    public static final byte[] SIGN_UP_URL = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 'a', 'u', 't', 'h', '/', 'u', 's', 'e', 'r', 's'};
    public static final byte[] VERIFICATION_CODE_URL = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 'a', 'u', 't', 'h', '/', 's', 'm', 's'};
    public static final byte[] SUPPORT_MAP_URL = new byte[]{'h', 't', 't', 'p', ':', '/', '/', 's', 'u', 'p', 'p', 'o', 'r', 't', '.', 'm', 'a', 'p', '.', 'i', 'r', '/', 'a', 'p', 'i', '/', 'i', 'n', 'd', 'e', 'x', '.', 'p', 'h', 'p', '/', 'T', 'i', 'c', 'k', 'e', 't', 's', '/', 'T', 'i', 'c', 'k', 'e', 't'};
    public static final byte[] GET_TAG_URL = new byte[]{'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 't', 'b', 't', '/', 't', 'a', 'g', 's', '/'};
    public static final int FAILED_RESULT_CODE = 99909;
    public static final int BACK_PRESSED_RESULT_CODE = 99009;
    public static final int MIN_LENGTH_PASSWORD = 8;
    public static final String WEATHER_IMAGE_BASE_URL = "http://openweathermap.org/img/w/";
    public static final byte[] GET_PROFILE = {'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 'a', 'u', 't', 'h', '/', 'u', 's', 'e', 'r', 's', '/'};
    public static final byte[] UPDATE_PROFILE = {'h', 't', 't', 'p', 's', ':', '/', '/', 'm', 'a', 'p', '.', 'i', 'r', '/', 'a', 'u', 't', 'h', '/', 'u', 's', 'e', 'r', 's', '/'};
    public static final String BASE_ROUTE_URL = "https://map.ir/routes/";

    public static String getLoadMoreTag(int type, int skip) {
        String apiUrl;
        if (skip == 0) {
            if (type == 0) {
                //public
                apiUrl = new String(TAG_BASE_URL) + "?$filter=accessibility eq public";
            } else {
                //privte
                apiUrl = new String(TAG_BASE_URL) + "?$filter=accessibility eq self";
            }
        } else {
            if (type == 0) {
                //public
                apiUrl = new String(TAG_BASE_URL) + "?$filter=accessibility eq public&$skip=" + skip;
            } else {
                //privte
                apiUrl = new String(TAG_BASE_URL) + "?$filter=accessibility eq self&$skip=" + skip;
            }
//            apiUrl = new String(TAG_BASE_URL) + "?$skip=" + skip;
        }


        return apiUrl;
    }

    public static String deleteTagURL(String params) {
        return new String(SHIVEH_BASE_URL) + "/tbt/tags/" + params;
    }

    public static String getBookmarkListURL(int skip) {
        String apiUrl;
        if (skip == 0) {
            apiUrl = new String(MAP_BOOKMARK_URL_LIST);
        } else {
            apiUrl = new String(MAP_BOOKMARK_URL_LIST) + "?$skip=" + skip;
        }
        return apiUrl;
    }

    public static String deleteBookmarkURL(String body) {
        return new String(SHIVEH_BASE_URL) + "/tbt/bookmarks/" + body;
    }

  public static String getMapSharingBody(MapirLatLng position) {
        return new String(SHIVEH_BASE_URL) + "/lat/" + position.latitude + "/lng/" + position.longitude + "/z/17";
    }

    public static String getTagURL(String body) {
        //TODO:: Change with real URL
        return new String(GET_TAG_URL) + body;
    }

    @SuppressLint("DefaultLocale")
    public static String getPublicTransportURL(MapirLatLng startPosition, MapirLatLng endPosition,
                                               String currentTime, String currentDate, Double walkDistance,
                                               String routeMode) {

        return String.format("http://192.168.30.61:8281/otp/routers/default/plan?" +
                        "fromPlace=%f,%f&toPlace=%f,%f&time=%s&date=%s&mode=%s&maxWalkDistance=%f&arriveBy=false&wheelchair=false&locale=en",
                startPosition.latitude, startPosition.longitude,
                endPosition.latitude, endPosition.longitude, currentTime, currentDate, routeMode,
                walkDistance == null ? 804.672 : walkDistance / 1609.344);

    }
}
