package ir.map.sdk_services.network;

import android.graphics.Bitmap;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import ir.map.sdk_common.MapirLatLng;
import ir.map.sdk_services.PublicTransportMode;
import ir.map.sdk_services.RouteMode;
import ir.map.sdk_services.models.MapirAuthenticateResponse;
import ir.map.sdk_services.models.MapirBookmark;
import ir.map.sdk_services.models.MapirForgotEntity;
import ir.map.sdk_services.models.MapirLoginResponse;
import ir.map.sdk_services.models.MapirMedia;
import ir.map.sdk_services.models.MapirNetworkEntity;
import ir.map.sdk_services.models.MapirProfileResponse;
import ir.map.sdk_services.models.MapirPublicTransportResponse;
import ir.map.sdk_services.models.MapirResendVerification;
import ir.map.sdk_services.models.MapirReverse;
import ir.map.sdk_services.models.MapirRouteResponse;
import ir.map.sdk_services.models.MapirSearchPostCode;
import ir.map.sdk_services.models.MapirSearchResponse;
import ir.map.sdk_services.models.MapirSimpleNetworkEntity;
import ir.map.sdk_services.models.MapirTag;
import ir.map.sdk_services.models.MapirTicket;
import ir.map.sdk_services.models.MapirWeatherItem;
import okhttp3.RequestBody;
import rx.Observable;

/**
 * @author Haniyeh Khaksar
 */

public interface RestApi {

  Observable<MapirReverse> getReverseGeoInfo(String params);

//    Observable<List<MapirSearch>> getPointOfInterests();

  Observable<MapirSimpleNetworkEntity> sendTicket(String token, String params);

  Observable<MapirSimpleNetworkEntity> sendReportTicket(String token, String params);

  Observable<List<MapirTicket>> getTicketList(String token);

  Observable<MapirMedia> uploadMediaByPath(String token, String path);

  Observable<MapirMedia> uploadMediaByFile(String token, File file);

  Observable<MapirSimpleNetworkEntity> createOrModifyTag(String token, String params);

  Observable<ArrayList<MapirTag>> getTagList(int type, String token, int skip);

  Observable<MapirSimpleNetworkEntity> deleteTag(String token, String id);

  Observable<MapirSearchResponse> search(String params);

  Observable<MapirSearchPostCode> searchPostCode(String params);

  Observable<MapirSimpleNetworkEntity> createBookmark(String token, String params);

  Observable<List<MapirBookmark>> getBookmarkList(String token, int skip);

  Observable<MapirSimpleNetworkEntity> deleteBookmark(String token, String id);

  Observable<MapirRouteResponse> getRouteInfo(MapirLatLng startPosition, MapirLatLng endPosition, RouteMode routeMode);

  Observable<MapirRouteResponse> getGlobalRouteInfo(MapirLatLng startPosition, MapirLatLng endPosition, RouteMode routeMode);

  Observable<MapirLoginResponse> loginUser(String params);

  Observable<MapirForgotEntity> forgetPassword(String params);

    Observable<Bitmap> getStaticMap(double latitude, double longitude, int zoom);

  Observable<MapirNetworkEntity> sendFeedback(RequestBody body);

  Observable<MapirAuthenticateResponse> signupUser(String params);

  Observable<MapirSimpleNetworkEntity> signoutUser(String token);

  Observable<MapirLoginResponse> loginUserByGmail(String token);

  Observable<MapirAuthenticateResponse> verifyUser(String params);

  Observable<MapirResendVerification> resendVerificationCode(String params);

  Observable<MapirWeatherItem> getWeatherInfo(String params);

  Observable<List<MapirWeatherItem>> getAllWeatherInfo();

  Observable<List<MapirTag>> getTag(String token, String params);

  Observable<MapirProfileResponse> getProfile(String userName, String token);

  Observable<MapirProfileResponse> updateProfile(String userName, String token, String body);

  Observable<MapirPublicTransportResponse> getPublicTrnasportRoute(MapirLatLng startPosition, MapirLatLng endPosition, Double walkDistance, PublicTransportMode routeMode);
}
