package ir.map.sdk_services;

public enum PublicTransportMode {

    TRANSIT("TRANSIT,WALK"),
    BUS_ONLY("BUS,WALK"),
    RAIL_ONLY("TRAM,RAIL,SUBWAY,SUBWAY,FUNICULAR,GONDOLA,WALK"),
    AIRPLANE_ONLY("AIRPLANE,WALK"),
    BICYCLE_ONLY("BICYCLE"),
    BICYCLE_TRANSIT("TRANSIT,BICYCLE"),
    WLAK_ONLY("WALK"),
    DRIVE_ONLY("CAR"),
    PARK_RIDE("CAR_PRAK,WALK,TRANSIT"),
    KISS_RIDE("CAR,WALK,TRANSIT"),
    BIKE_RIDE("BICYCLE_PARK,WALK,TRANSIT"),
    RENTED_BICYCLE("WALK,BICYCLE_RENT"),
    TRANSIT_RENTED_BICYCLE("TRANSIT,WALK,BICYCLE_RENT");

    private String params;

    PublicTransportMode(String params) {
        this.params = params;
    }

    public String params() {
        return params;
    }

}
