package ir.map.sdk_services.repository;

import android.graphics.Bitmap;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import ir.map.sdk_common.MaptexLatLng;
import ir.map.sdk_services.RouteMode;
import ir.map.sdk_services.models.MaptexAuthenticateResponse;
import ir.map.sdk_services.models.MaptexBookmark;
import ir.map.sdk_services.models.MaptexForgotEntity;
import ir.map.sdk_services.models.MaptexLoginResponse;
import ir.map.sdk_services.models.MaptexMedia;
import ir.map.sdk_services.models.MaptexNetworkEntity;
import ir.map.sdk_services.models.MaptexProfileResponse;
import ir.map.sdk_services.models.MaptexResendVerification;
import ir.map.sdk_services.models.MaptexReverse;
import ir.map.sdk_services.models.MaptexRouteResponse;
import ir.map.sdk_services.models.MaptexSearchPostCode;
import ir.map.sdk_services.models.MaptexSearchResponse;
import ir.map.sdk_services.models.MaptexSimpleNetworkEntity;
import ir.map.sdk_services.models.MaptexTag;
import ir.map.sdk_services.models.MaptexTicket;
import ir.map.sdk_services.models.MaptexWeatherItem;
import okhttp3.RequestBody;
import rx.Observable;

/**
 * @author Haniyeh Khaksar
 */

public interface INetworkRepository {

    Observable<MaptexReverse> getReverseGeoInfo(String params);

    Observable<MaptexSimpleNetworkEntity> sendTicket(String token, String params);

    Observable<MaptexSimpleNetworkEntity> sendReportTicket(String token, String params);

    Observable<List<MaptexTicket>> getTicketList(String token);

    Observable<MaptexMedia> uploadMediaByPath(String token, String path);

    Observable<MaptexMedia> uploadMediaByFile(String token, File file);

    Observable<MaptexSimpleNetworkEntity> createOrModifyTag(String token, String params);

    Observable<ArrayList<MaptexTag>> getTagList(int type, String token, int skip);

    Observable<MaptexSimpleNetworkEntity> deleteTag(String token, String id);

    Observable<MaptexSearchResponse> search(String params);

    Observable<MaptexSearchPostCode> searchPostCode(String params);

    Observable<MaptexSimpleNetworkEntity> createBookmark(String token, String params);

    Observable<List<MaptexBookmark>> getBookmarkList(String token, int skip);

    Observable<MaptexSimpleNetworkEntity> deleteBookmark(String token, String id);

    Observable<MaptexRouteResponse> getRouteInfo(MaptexLatLng startPosition, MaptexLatLng endPosition, RouteMode routeMode);

    Observable<MaptexRouteResponse> getGlobalRouteInfo(MaptexLatLng startPosition, MaptexLatLng endPosition, RouteMode routeMode);

    Observable<MaptexLoginResponse> loginUser(String params);

    Observable<MaptexForgotEntity> forgetPassword(String params);

    Observable<Bitmap> getStaticMap(double latitude, double longitude, int zoom);

    Observable<MaptexNetworkEntity> sendFeedback(RequestBody body);

    Observable<MaptexAuthenticateResponse> signupUser(String authParams);

    Observable<MaptexSimpleNetworkEntity> signoutUser(String token);

    Observable<MaptexLoginResponse> loginUserByGmail(String token);

    Observable<MaptexAuthenticateResponse> verifyUser(String params);

    Observable<MaptexResendVerification> resendVerificationCode(String params);

    Observable<MaptexWeatherItem> getWeatherInfo(String params);

    Observable<List<MaptexWeatherItem>> getAllWeatherInfo();

    Observable<List<MaptexTag>> getTag(String token, String params);

    Observable<MaptexProfileResponse> getProfile(String userName, String token);

    Observable<MaptexProfileResponse> updateProfile(String userName, String token, String params);
}
