/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.utils;

import android.os.AsyncTask;
import java.io.File;
import java.lang.ref.WeakReference;

public class FileUtils {

    public static class CheckFileWritePermissionTask
    extends AsyncTask<File, Void, Boolean> {
        private final WeakReference<OnCheckFileWritePermissionListener> listenerWeakReference;

        public CheckFileWritePermissionTask(OnCheckFileWritePermissionListener listener) {
            this.listenerWeakReference = new WeakReference<OnCheckFileWritePermissionListener>(listener);
        }

        protected Boolean doInBackground(File ... files) {
            try {
                return files[0].canWrite();
            }
            catch (Exception ex) {
                return false;
            }
        }

        protected void onCancelled() {
            OnCheckFileWritePermissionListener listener = (OnCheckFileWritePermissionListener)this.listenerWeakReference.get();
            if (listener != null) {
                listener.onError();
            }
        }

        protected void onPostExecute(Boolean result) {
            OnCheckFileWritePermissionListener listener = (OnCheckFileWritePermissionListener)this.listenerWeakReference.get();
            if (listener != null) {
                if (result.booleanValue()) {
                    listener.onWritePermissionGranted();
                } else {
                    listener.onError();
                }
            }
        }
    }

    public static class CheckFileReadPermissionTask
    extends AsyncTask<File, Void, Boolean> {
        private final WeakReference<OnCheckFileReadPermissionListener> listenerWeakReference;

        public CheckFileReadPermissionTask(OnCheckFileReadPermissionListener listener) {
            this.listenerWeakReference = new WeakReference<OnCheckFileReadPermissionListener>(listener);
        }

        protected Boolean doInBackground(File ... files) {
            try {
                return files[0].canRead();
            }
            catch (Exception ex) {
                return false;
            }
        }

        protected void onCancelled() {
            OnCheckFileReadPermissionListener listener = (OnCheckFileReadPermissionListener)this.listenerWeakReference.get();
            if (listener != null) {
                listener.onError();
            }
        }

        protected void onPostExecute(Boolean result) {
            OnCheckFileReadPermissionListener listener = (OnCheckFileReadPermissionListener)this.listenerWeakReference.get();
            if (listener != null) {
                if (result.booleanValue()) {
                    listener.onReadPermissionGranted();
                } else {
                    listener.onError();
                }
            }
        }
    }

    public static interface OnCheckFileWritePermissionListener {
        public void onWritePermissionGranted();

        public void onError();
    }

    public static interface OnCheckFileReadPermissionListener {
        public void onReadPermissionGranted();

        public void onError();
    }
}

