/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.view.View;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class BitmapUtils {
    public static Bitmap createBitmapFromView(@NonNull View view) {
        view.setDrawingCacheEnabled(true);
        view.setDrawingCacheQuality(524288);
        view.buildDrawingCache();
        if (view.getDrawingCache() == null) {
            return null;
        }
        Bitmap snapshot = Bitmap.createBitmap((Bitmap)view.getDrawingCache());
        view.setDrawingCacheEnabled(false);
        view.destroyDrawingCache();
        return snapshot;
    }

    public static Bitmap mergeBitmap(@NonNull Bitmap background, @NonNull Bitmap foreground) {
        Bitmap result = Bitmap.createBitmap((int)background.getWidth(), (int)background.getHeight(), (Bitmap.Config)background.getConfig());
        Canvas canvas = new Canvas(result);
        canvas.drawBitmap(background, 0.0f, 0.0f, null);
        canvas.drawBitmap(foreground, 10.0f, 10.0f, null);
        return result;
    }

    public static Bitmap getBitmapFromDrawable(Drawable sourceDrawable) {
        if (sourceDrawable == null) {
            return null;
        }
        if (sourceDrawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)sourceDrawable).getBitmap();
        }
        Drawable.ConstantState constantState = sourceDrawable.getConstantState();
        if (constantState == null) {
            return null;
        }
        Drawable drawable2 = constantState.newDrawable().mutate();
        Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    public static byte[] getByteArrayFromDrawable(Drawable drawable2) {
        if (drawable2 == null) {
            return null;
        }
        Bitmap bitmap = BitmapUtils.getBitmapFromDrawable(drawable2);
        if (bitmap == null) {
            return null;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
        return stream.toByteArray();
    }

    public static Drawable getDrawableFromByteArray(Context context, byte[] array) {
        if (array == null) {
            return null;
        }
        Bitmap compass = BitmapFactory.decodeByteArray((byte[])array, (int)0, (int)array.length);
        return new BitmapDrawable(context.getResources(), compass);
    }
}

