/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.style.sources;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.UiThread;
import com.mapbox.geojson.Feature;
import ir.map.sdk_map.style.expressions.Expression;
import ir.map.sdk_map.style.sources.Source;
import ir.map.sdk_map.style.sources.TileSet;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@UiThread
public class VectorSource
extends Source {
    @Keep
    VectorSource(long nativePtr) {
        super(nativePtr);
    }

    public VectorSource(String id2, URL url) {
        this(id2, url.toExternalForm());
    }

    public VectorSource(String id2, String url) {
        this.initialize(id2, url);
    }

    public VectorSource(String id2, TileSet tileSet) {
        this.initialize(id2, tileSet.toValueObject());
    }

    @NonNull
    public List<Feature> querySourceFeatures(@Size(min=1L) String[] sourceLayerIds, @Nullable Expression filter) {
        this.checkThread();
        Feature[] features = this.querySourceFeatures(sourceLayerIds, filter != null ? filter.toArray() : null);
        return features != null ? Arrays.asList(features) : new ArrayList<Feature>();
    }

    @Nullable
    public String getUrl() {
        this.checkThread();
        return this.nativeGetUrl();
    }

    @Keep
    protected native void initialize(String var1, Object var2);

    @Keep
    protected native void finalize() throws Throwable;

    @Keep
    protected native String nativeGetUrl();

    @Keep
    private native Feature[] querySourceFeatures(String[] var1, Object[] var2);
}

