/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.style.light;

import android.support.annotation.ColorInt;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import ir.map.sdk_map.style.layers.PropertyFactory;
import ir.map.sdk_map.style.layers.TransitionOptions;
import ir.map.sdk_map.style.light.Position;
import ir.map.sdk_map.utils.ThreadUtils;

@UiThread
public class Light {
    @Keep
    private long nativePtr;

    @Keep
    Light(long nativePtr) {
        this.checkThread();
        this.nativePtr = nativePtr;
    }

    public String getAnchor() {
        this.checkThread();
        return this.nativeGetAnchor();
    }

    public void setAnchor(String anchor) {
        this.checkThread();
        this.nativeSetAnchor(anchor);
    }

    public Position getPosition() {
        this.checkThread();
        return this.nativeGetPosition();
    }

    public void setPosition(@NonNull Position position) {
        this.checkThread();
        this.nativeSetPosition(position);
    }

    public TransitionOptions getPositionTransition() {
        this.checkThread();
        return this.nativeGetPositionTransition();
    }

    public void setPositionTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetPositionTransition(options.getDuration(), options.getDelay());
    }

    public void setColor(@ColorInt int color2) {
        this.checkThread();
        this.nativeSetColor(PropertyFactory.colorToRgbaString(color2));
    }

    public String getColor() {
        this.checkThread();
        return this.nativeGetColor();
    }

    public void setColor(String color2) {
        this.checkThread();
        this.nativeSetColor(color2);
    }

    public TransitionOptions getColorTransition() {
        this.checkThread();
        return this.nativeGetColorTransition();
    }

    public void setColorTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetColorTransition(options.getDuration(), options.getDelay());
    }

    public float getIntensity() {
        this.checkThread();
        return this.nativeGetIntensity();
    }

    public void setIntensity(float intensity) {
        this.checkThread();
        this.nativeSetIntensity(intensity);
    }

    public TransitionOptions getIntensityTransition() {
        this.checkThread();
        return this.nativeGetIntensityTransition();
    }

    public void setIntensityTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetIntensityTransition(options.getDuration(), options.getDelay());
    }

    private void checkThread() {
        ThreadUtils.checkThread("Light");
    }

    @Keep
    private native void nativeSetAnchor(String var1);

    @Keep
    private native String nativeGetAnchor();

    @Keep
    private native void nativeSetPosition(Position var1);

    @Keep
    private native Position nativeGetPosition();

    @Keep
    private native TransitionOptions nativeGetPositionTransition();

    @Keep
    private native void nativeSetPositionTransition(long var1, long var3);

    @Keep
    private native void nativeSetColor(String var1);

    @Keep
    private native String nativeGetColor();

    @Keep
    private native TransitionOptions nativeGetColorTransition();

    @Keep
    private native void nativeSetColorTransition(long var1, long var3);

    @Keep
    private native void nativeSetIntensity(float var1);

    @Keep
    private native float nativeGetIntensity();

    @Keep
    private native TransitionOptions nativeGetIntensityTransition();

    @Keep
    private native void nativeSetIntensityTransition(long var1, long var3);
}

