/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.style.layers;

import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.JsonArray;
import ir.map.sdk_map.MapStrictMode;
import ir.map.sdk_map.exceptions.ConversionException;
import ir.map.sdk_map.log.Logger;
import ir.map.sdk_map.style.expressions.Expression;
import ir.map.sdk_map.utils.ColorUtils;

public class PropertyValue<T> {
    private static final String TAG = "Mbgl-PropertyValue";
    public final String name;
    public final T value;

    public PropertyValue(@NonNull String name, T value) {
        this.name = name;
        this.value = value;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean isExpression() {
        return !this.isNull() && (this.value instanceof JsonArray || this.value instanceof Expression);
    }

    @Nullable
    public Expression getExpression() {
        if (this.isExpression()) {
            return this.value instanceof JsonArray ? Expression.Converter.convert((JsonArray)this.value) : (Expression)this.value;
        }
        Logger.w(TAG, "not an expression, try PropertyValue#getValue()");
        return null;
    }

    public boolean isValue() {
        return !this.isNull() && !this.isExpression();
    }

    @Nullable
    public T getValue() {
        if (this.isValue()) {
            return this.value;
        }
        Logger.w(TAG, "not a value, try PropertyValue#getExpression()");
        return null;
    }

    @ColorInt
    @Nullable
    public Integer getColorInt() {
        if (!this.isValue() || !(this.value instanceof String)) {
            Logger.e(TAG, String.format("%s is not a String value and can not be converted to a color it", this.name));
            return null;
        }
        try {
            return ColorUtils.rgbaToColor((String)this.value);
        }
        catch (ConversionException ex) {
            Logger.e(TAG, String.format("%s could not be converted to a Color int: %s", this.name, ex.getMessage()));
            MapStrictMode.strictModeViolation(ex);
            return null;
        }
    }

    public String toString() {
        return String.format("%s: %s", this.name, this.value);
    }
}

