/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.style.layers;

import android.support.annotation.Keep;
import com.google.gson.JsonElement;
import ir.map.sdk_map.style.expressions.Expression;
import ir.map.sdk_map.style.layers.PaintPropertyValue;
import ir.map.sdk_map.style.layers.PropertyValue;
import ir.map.sdk_map.utils.ThreadUtils;

public abstract class Layer {
    @Keep
    private long nativePtr;
    @Keep
    private boolean invalidated;

    @Keep
    protected Layer(long nativePtr) {
        this.checkThread();
        this.nativePtr = nativePtr;
    }

    public Layer() {
        this.checkThread();
    }

    protected void checkThread() {
        ThreadUtils.checkThread("Layer");
    }

    public void setProperties(PropertyValue<?> ... properties) {
        this.checkThread();
        if (properties.length == 0) {
            return;
        }
        for (PropertyValue<?> property : properties) {
            Object converted = this.convertValue(property.value);
            if (property instanceof PaintPropertyValue) {
                this.nativeSetPaintProperty(property.name, converted);
                continue;
            }
            this.nativeSetLayoutProperty(property.name, converted);
        }
    }

    public String getId() {
        this.checkThread();
        return this.nativeGetId();
    }

    public PropertyValue<String> getVisibility() {
        this.checkThread();
        return new PaintPropertyValue<String>("visibility", (String)this.nativeGetVisibility());
    }

    public float getMinZoom() {
        this.checkThread();
        return this.nativeGetMinZoom();
    }

    public void setMinZoom(float zoom) {
        this.checkThread();
        this.nativeSetMinZoom(zoom);
    }

    public float getMaxZoom() {
        this.checkThread();
        return this.nativeGetMaxZoom();
    }

    public void setMaxZoom(float zoom) {
        this.checkThread();
        this.nativeSetMaxZoom(zoom);
    }

    @Keep
    protected native void finalize() throws Throwable;

    @Keep
    protected native String nativeGetId();

    @Keep
    protected native Object nativeGetVisibility();

    @Keep
    protected native void nativeSetLayoutProperty(String var1, Object var2);

    @Keep
    protected native void nativeSetPaintProperty(String var1, Object var2);

    @Keep
    protected native void nativeSetFilter(Object[] var1);

    @Keep
    protected native JsonElement nativeGetFilter();

    @Keep
    protected native void nativeSetSourceLayer(String var1);

    @Keep
    protected native String nativeGetSourceLayer();

    @Keep
    protected native String nativeGetSourceId();

    @Keep
    protected native float nativeGetMinZoom();

    @Keep
    protected native float nativeGetMaxZoom();

    @Keep
    protected native void nativeSetMinZoom(float var1);

    @Keep
    protected native void nativeSetMaxZoom(float var1);

    public long getNativePtr() {
        return this.nativePtr;
    }

    private Object convertValue(Object value) {
        if (value != null && value instanceof Expression) {
            return ((Expression)value).toArray();
        }
        return value;
    }
}

