/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.style.layers;

import android.support.annotation.ColorInt;
import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.google.gson.JsonArray;
import ir.map.sdk_map.style.expressions.Expression;
import ir.map.sdk_map.style.layers.Layer;
import ir.map.sdk_map.style.layers.PropertyValue;
import ir.map.sdk_map.style.layers.TransitionOptions;
import ir.map.sdk_map.utils.ColorUtils;

@UiThread
public class FillLayer
extends Layer {
    @Keep
    FillLayer(long nativePtr) {
        super(nativePtr);
    }

    public FillLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    @Keep
    protected native void initialize(String var1, String var2);

    public FillLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    public String getSourceId() {
        this.checkThread();
        return this.nativeGetSourceId();
    }

    public String getSourceLayer() {
        this.checkThread();
        return this.nativeGetSourceLayer();
    }

    public void setSourceLayer(String sourceLayer) {
        this.checkThread();
        this.nativeSetSourceLayer(sourceLayer);
    }

    public FillLayer withFilter(Expression filter) {
        this.setFilter(filter);
        return this;
    }

    @Nullable
    public Expression getFilter() {
        this.checkThread();
        Expression expression = null;
        JsonArray array = (JsonArray)this.nativeGetFilter();
        if (array != null) {
            expression = Expression.Converter.convert(array);
        }
        return expression;
    }

    public void setFilter(Expression filter) {
        this.checkThread();
        this.nativeSetFilter(filter.toArray());
    }

    public FillLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    public PropertyValue<Boolean> getFillAntialias() {
        this.checkThread();
        return new PropertyValue<Object>("fill-antialias", this.nativeGetFillAntialias());
    }

    public PropertyValue<Float> getFillOpacity() {
        this.checkThread();
        return new PropertyValue<Object>("fill-opacity", this.nativeGetFillOpacity());
    }

    public TransitionOptions getFillOpacityTransition() {
        this.checkThread();
        return this.nativeGetFillOpacityTransition();
    }

    public void setFillOpacityTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetFillOpacityTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getFillColor() {
        this.checkThread();
        return new PropertyValue<Object>("fill-color", this.nativeGetFillColor());
    }

    @ColorInt
    public int getFillColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getFillColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("fill-color was set as a Function");
    }

    public TransitionOptions getFillColorTransition() {
        this.checkThread();
        return this.nativeGetFillColorTransition();
    }

    public void setFillColorTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetFillColorTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getFillOutlineColor() {
        this.checkThread();
        return new PropertyValue<Object>("fill-outline-color", this.nativeGetFillOutlineColor());
    }

    @ColorInt
    public int getFillOutlineColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getFillOutlineColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("fill-outline-color was set as a Function");
    }

    public TransitionOptions getFillOutlineColorTransition() {
        this.checkThread();
        return this.nativeGetFillOutlineColorTransition();
    }

    public void setFillOutlineColorTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetFillOutlineColorTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float[]> getFillTranslate() {
        this.checkThread();
        return new PropertyValue<Object>("fill-translate", this.nativeGetFillTranslate());
    }

    public TransitionOptions getFillTranslateTransition() {
        this.checkThread();
        return this.nativeGetFillTranslateTransition();
    }

    public void setFillTranslateTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetFillTranslateTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getFillTranslateAnchor() {
        this.checkThread();
        return new PropertyValue<Object>("fill-translate-anchor", this.nativeGetFillTranslateAnchor());
    }

    public PropertyValue<String> getFillPattern() {
        this.checkThread();
        return new PropertyValue<Object>("fill-pattern", this.nativeGetFillPattern());
    }

    public TransitionOptions getFillPatternTransition() {
        this.checkThread();
        return this.nativeGetFillPatternTransition();
    }

    public void setFillPatternTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetFillPatternTransition(options.getDuration(), options.getDelay());
    }

    @Keep
    private native Object nativeGetFillAntialias();

    @Keep
    private native Object nativeGetFillOpacity();

    @Keep
    private native TransitionOptions nativeGetFillOpacityTransition();

    @Keep
    private native void nativeSetFillOpacityTransition(long var1, long var3);

    @Keep
    private native Object nativeGetFillColor();

    @Keep
    private native TransitionOptions nativeGetFillColorTransition();

    @Keep
    private native void nativeSetFillColorTransition(long var1, long var3);

    @Keep
    private native Object nativeGetFillOutlineColor();

    @Keep
    private native TransitionOptions nativeGetFillOutlineColorTransition();

    @Keep
    private native void nativeSetFillOutlineColorTransition(long var1, long var3);

    @Keep
    private native Object nativeGetFillTranslate();

    @Keep
    private native TransitionOptions nativeGetFillTranslateTransition();

    @Keep
    private native void nativeSetFillTranslateTransition(long var1, long var3);

    @Keep
    private native Object nativeGetFillTranslateAnchor();

    @Keep
    private native Object nativeGetFillPattern();

    @Keep
    private native TransitionOptions nativeGetFillPatternTransition();

    @Keep
    private native void nativeSetFillPatternTransition(long var1, long var3);

    @Override
    @Keep
    protected native void finalize() throws Throwable;
}

