/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.style.layers;

import android.support.annotation.ColorInt;
import android.support.annotation.Keep;
import android.support.annotation.UiThread;
import ir.map.sdk_map.style.layers.Layer;
import ir.map.sdk_map.style.layers.PropertyValue;
import ir.map.sdk_map.style.layers.TransitionOptions;
import ir.map.sdk_map.utils.ColorUtils;

@UiThread
public class BackgroundLayer
extends Layer {
    @Keep
    BackgroundLayer(long nativePtr) {
        super(nativePtr);
    }

    public BackgroundLayer(String layerId) {
        this.initialize(layerId);
    }

    @Keep
    protected native void initialize(String var1);

    public BackgroundLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    public PropertyValue<String> getBackgroundColor() {
        this.checkThread();
        return new PropertyValue<Object>("background-color", this.nativeGetBackgroundColor());
    }

    @ColorInt
    public int getBackgroundColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getBackgroundColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("background-color was set as a Function");
    }

    public TransitionOptions getBackgroundColorTransition() {
        this.checkThread();
        return this.nativeGetBackgroundColorTransition();
    }

    public void setBackgroundColorTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetBackgroundColorTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getBackgroundPattern() {
        this.checkThread();
        return new PropertyValue<Object>("background-pattern", this.nativeGetBackgroundPattern());
    }

    public TransitionOptions getBackgroundPatternTransition() {
        this.checkThread();
        return this.nativeGetBackgroundPatternTransition();
    }

    public void setBackgroundPatternTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetBackgroundPatternTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getBackgroundOpacity() {
        this.checkThread();
        return new PropertyValue<Object>("background-opacity", this.nativeGetBackgroundOpacity());
    }

    public TransitionOptions getBackgroundOpacityTransition() {
        this.checkThread();
        return this.nativeGetBackgroundOpacityTransition();
    }

    public void setBackgroundOpacityTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetBackgroundOpacityTransition(options.getDuration(), options.getDelay());
    }

    @Keep
    private native Object nativeGetBackgroundColor();

    @Keep
    private native TransitionOptions nativeGetBackgroundColorTransition();

    @Keep
    private native void nativeSetBackgroundColorTransition(long var1, long var3);

    @Keep
    private native Object nativeGetBackgroundPattern();

    @Keep
    private native TransitionOptions nativeGetBackgroundPatternTransition();

    @Keep
    private native void nativeSetBackgroundPatternTransition(long var1, long var3);

    @Keep
    private native Object nativeGetBackgroundOpacity();

    @Keep
    private native TransitionOptions nativeGetBackgroundOpacityTransition();

    @Keep
    private native void nativeSetBackgroundOpacityTransition(long var1, long var3);

    @Override
    @Keep
    protected native void finalize() throws Throwable;
}

