/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.offline;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Keep;
import ir.map.sdk_map.geometry.LatLng;
import ir.map.sdk_map.geometry.LatLngBounds;
import ir.map.sdk_map.offline.OfflineRegionDefinition;

public class OfflineTilePyramidRegionDefinition
implements OfflineRegionDefinition,
Parcelable {
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public OfflineTilePyramidRegionDefinition createFromParcel(Parcel in) {
            return new OfflineTilePyramidRegionDefinition(in);
        }

        public OfflineTilePyramidRegionDefinition[] newArray(int size) {
            return new OfflineTilePyramidRegionDefinition[size];
        }
    };
    @Keep
    private String styleURL;
    @Keep
    private LatLngBounds bounds;
    @Keep
    private double minZoom;
    @Keep
    private double maxZoom;
    @Keep
    private float pixelRatio;

    @Keep
    public OfflineTilePyramidRegionDefinition(String styleURL, LatLngBounds bounds, double minZoom, double maxZoom, float pixelRatio) {
        this.styleURL = styleURL;
        this.bounds = bounds;
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
        this.pixelRatio = pixelRatio;
    }

    public OfflineTilePyramidRegionDefinition(Parcel parcel) {
        this.styleURL = parcel.readString();
        this.bounds = new LatLngBounds.Builder().include(new LatLng(parcel.readDouble(), parcel.readDouble())).include(new LatLng(parcel.readDouble(), parcel.readDouble())).build();
        this.minZoom = parcel.readDouble();
        this.maxZoom = parcel.readDouble();
        this.pixelRatio = parcel.readFloat();
    }

    public String getStyleURL() {
        return this.styleURL;
    }

    @Override
    public LatLngBounds getBounds() {
        return this.bounds;
    }

    public double getMinZoom() {
        return this.minZoom;
    }

    public double getMaxZoom() {
        return this.maxZoom;
    }

    public float getPixelRatio() {
        return this.pixelRatio;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.styleURL);
        dest.writeDouble(this.bounds.getLatNorth());
        dest.writeDouble(this.bounds.getLonEast());
        dest.writeDouble(this.bounds.getLatSouth());
        dest.writeDouble(this.bounds.getLonWest());
        dest.writeDouble(this.minZoom);
        dest.writeDouble(this.maxZoom);
        dest.writeFloat(this.pixelRatio);
    }
}

