/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.offline;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Keep;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.Geometry;
import com.mapbox.turf.TurfMeasurement;
import ir.map.sdk_map.geometry.LatLngBounds;
import ir.map.sdk_map.offline.OfflineRegionDefinition;

public class OfflineGeometryRegionDefinition
implements OfflineRegionDefinition,
Parcelable {
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public OfflineGeometryRegionDefinition createFromParcel(Parcel in) {
            return new OfflineGeometryRegionDefinition(in);
        }

        public OfflineGeometryRegionDefinition[] newArray(int size) {
            return new OfflineGeometryRegionDefinition[size];
        }
    };
    @Keep
    private String styleURL;
    @Keep
    private Geometry geometry;
    @Keep
    private double minZoom;
    @Keep
    private double maxZoom;
    @Keep
    private float pixelRatio;

    @Keep
    public OfflineGeometryRegionDefinition(String styleURL, Geometry geometry, double minZoom, double maxZoom, float pixelRatio) {
        this.styleURL = styleURL;
        this.geometry = geometry;
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
        this.pixelRatio = pixelRatio;
    }

    public OfflineGeometryRegionDefinition(Parcel parcel) {
        this.styleURL = parcel.readString();
        this.geometry = Feature.fromJson((String)parcel.readString()).geometry();
        this.minZoom = parcel.readDouble();
        this.maxZoom = parcel.readDouble();
        this.pixelRatio = parcel.readFloat();
    }

    public String getStyleURL() {
        return this.styleURL;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    @Override
    public LatLngBounds getBounds() {
        if (this.geometry == null) {
            return null;
        }
        double[] bbox = TurfMeasurement.bbox((Geometry)this.geometry);
        return LatLngBounds.from(bbox[3], bbox[2], bbox[1], bbox[0]);
    }

    public double getMinZoom() {
        return this.minZoom;
    }

    public double getMaxZoom() {
        return this.maxZoom;
    }

    public float getPixelRatio() {
        return this.pixelRatio;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.styleURL);
        dest.writeString(Feature.fromGeometry((Geometry)this.geometry).toJson());
        dest.writeDouble(this.minZoom);
        dest.writeDouble(this.maxZoom);
        dest.writeFloat(this.pixelRatio);
    }
}

