/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.module.telemetry;

import android.content.Context;
import android.support.annotation.NonNull;
import com.mapbox.android.telemetry.AppUserTurnstile;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.MapEventFactory;
import com.mapbox.android.telemetry.MapState;
import com.mapbox.android.telemetry.MapboxTelemetry;
import com.mapbox.android.telemetry.SessionInterval;
import com.mapbox.android.telemetry.TelemetryEnabler;
import ir.map.sdk_map.MapStrictMode;
import ir.map.sdk_map.Mapir;
import ir.map.sdk_map.log.Logger;
import ir.map.sdk_map.maps.TelemetryDefinition;
import ir.map.sdk_map.offline.OfflineGeometryRegionDefinition;
import ir.map.sdk_map.offline.OfflineRegionDefinition;
import ir.map.sdk_map.offline.OfflineTilePyramidRegionDefinition;
import java.lang.reflect.Field;

public class TelemetryImpl
implements TelemetryDefinition {
    private static final String TAG = "Mbgl-TelemetryImpl";
    private static TelemetryImpl instance;
    private MapboxTelemetry telemetry;

    private TelemetryImpl() {
        Context appContext = Mapir.getApplicationContext();
        String accessToken = Mapir.getAccessToken();
        this.telemetry = new MapboxTelemetry(appContext, accessToken, "mapir-maps-android/6.7.0-SNAPSHOT");
        TelemetryEnabler.State telemetryState = TelemetryEnabler.retrieveTelemetryStateFromPreferences();
        if (TelemetryEnabler.State.ENABLED.equals((Object)telemetryState)) {
            this.telemetry.enable();
        }
    }

    @Deprecated
    public static synchronized TelemetryImpl getInstance() {
        if (instance == null) {
            instance = new TelemetryImpl();
        }
        return instance;
    }

    @Deprecated
    public static void updateDebugLoggingEnabled(boolean debugLoggingEnabled) {
        TelemetryDefinition definition = Mapir.getTelemetry();
        if (definition != null) {
            definition.setDebugLoggingEnabled(debugLoggingEnabled);
        }
    }

    @Deprecated
    public static boolean updateSessionIdRotationInterval(SessionInterval interval) {
        try {
            Field field = interval.getClass().getDeclaredField("interval");
            field.setAccessible(true);
            Integer intervalValue = (Integer)field.get(interval);
            TelemetryDefinition definition = Mapir.getTelemetry();
            if (definition != null) {
                return definition.setSessionIdRotationInterval(intervalValue);
            }
        }
        catch (Exception exception) {
            Logger.e(TAG, "Exception occurred when updating session id rotation interval", exception);
            MapStrictMode.strictModeViolation(exception);
        }
        return false;
    }

    @Deprecated
    public static void enableOnUserRequest() {
        TelemetryDefinition definition = Mapir.getTelemetry();
        if (definition != null) {
            definition.setUserTelemetryRequestState(true);
        }
    }

    @Deprecated
    public static void disableOnUserRequest() {
        TelemetryDefinition definition = Mapir.getTelemetry();
        if (definition != null) {
            definition.setUserTelemetryRequestState(false);
        }
    }

    @Override
    public void onAppUserTurnstileEvent() {
        AppUserTurnstile turnstileEvent = new AppUserTurnstile("mapir-maps-android", "6.7.0-SNAPSHOT");
        this.telemetry.push((Event)turnstileEvent);
        MapEventFactory mapEventFactory = new MapEventFactory();
        this.telemetry.push(mapEventFactory.createMapLoadEvent(Event.Type.MAP_LOAD));
    }

    @Override
    public void onGestureInteraction(String eventType, double latitude, double longitude, double zoom) {
        MapEventFactory mapEventFactory = new MapEventFactory();
        MapState state = new MapState(latitude, longitude, zoom);
        state.setGesture(eventType);
        this.telemetry.push(mapEventFactory.createMapGestureEvent(Event.Type.MAP_CLICK, state));
    }

    @Override
    public void setUserTelemetryRequestState(boolean enabledTelemetry) {
        if (enabledTelemetry) {
            TelemetryEnabler.updateTelemetryState((TelemetryEnabler.State)TelemetryEnabler.State.ENABLED);
            this.telemetry.enable();
        } else {
            this.telemetry.disable();
            TelemetryEnabler.updateTelemetryState((TelemetryEnabler.State)TelemetryEnabler.State.DISABLED);
        }
    }

    @Override
    public void setDebugLoggingEnabled(boolean debugLoggingEnabled) {
        this.telemetry.updateDebugLoggingEnabled(debugLoggingEnabled);
    }

    @Override
    public boolean setSessionIdRotationInterval(int interval) {
        return this.telemetry.updateSessionIdRotationInterval(new SessionInterval(interval));
    }

    @Override
    public void onCreateOfflineRegion(@NonNull OfflineRegionDefinition offlineDefinition) {
        MapEventFactory mapEventFactory = new MapEventFactory();
        if (offlineDefinition instanceof OfflineTilePyramidRegionDefinition) {
            OfflineTilePyramidRegionDefinition tileDefinition = (OfflineTilePyramidRegionDefinition)offlineDefinition;
            this.telemetry.push(mapEventFactory.createOfflineDownloadStartEvent("tileregion", Double.valueOf(tileDefinition.getMinZoom()), Double.valueOf(tileDefinition.getMaxZoom()), tileDefinition.getStyleURL()));
        } else {
            OfflineGeometryRegionDefinition geometryDefinition = (OfflineGeometryRegionDefinition)offlineDefinition;
            this.telemetry.push(mapEventFactory.createOfflineDownloadStartEvent("shaperegion", Double.valueOf(geometryDefinition.getMinZoom()), Double.valueOf(geometryDefinition.getMaxZoom()), geometryDefinition.getStyleURL()));
        }
    }
}

