/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.maps;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.content.res.ResourcesCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import ir.map.sdk_map.R;
import ir.map.sdk_map.camera.CameraPosition;
import ir.map.sdk_map.maps.AttributionDialogManager;
import ir.map.sdk_map.maps.FocalPointChangeListener;
import ir.map.sdk_map.maps.MapirMapOptions;
import ir.map.sdk_map.maps.Projection;
import ir.map.sdk_map.maps.widgets.CompassView;
import ir.map.sdk_map.utils.BitmapUtils;

public final class UiSettings {
    private final FocalPointChangeListener focalPointChangeListener;
    private final Projection projection;
    private final CompassView compassView;
    private final int[] compassMargins = new int[4];
    private final int[] attributionsMargins = new int[4];
    private final View logoView;
    private final int[] logoMargins = new int[4];
    private final float pixelRatio;
    private AttributionDialogManager attributionDialogManager;
    private boolean rotateGesturesEnabled = true;
    private boolean tiltGesturesEnabled = true;
    private boolean zoomGesturesEnabled = true;
    private boolean scrollGesturesEnabled = true;
    private boolean zoomControlsEnabled;
    private boolean doubleTapGesturesEnabled = true;
    private boolean scaleVelocityAnimationEnabled = true;
    private boolean rotateVelocityAnimationEnabled = true;
    private boolean flingVelocityAnimationEnabled = true;
    private boolean increaseRotateThresholdWhenScaling = true;
    private boolean increaseScaleThresholdWhenRotating = true;
    private boolean deselectMarkersOnTap = true;
    private PointF userProvidedFocalPoint;

    UiSettings(@NonNull Projection projection, @NonNull FocalPointChangeListener listener, @NonNull CompassView compassView, @NonNull View logoView, float pixelRatio) {
        this.projection = projection;
        this.focalPointChangeListener = listener;
        this.compassView = compassView;
        this.logoView = logoView;
        this.pixelRatio = pixelRatio;
    }

    void initialise(@NonNull Context context, @NonNull MapirMapOptions options) {
        Resources resources = context.getResources();
        this.initialiseGestures(options);
        this.initialiseCompass(options, resources);
        this.initialiseLogo(options, resources);
        this.initialiseZoomControl(context);
    }

    void onSaveInstanceState(Bundle outState) {
        this.saveGestures(outState);
        this.saveCompass(outState);
        this.saveLogo(outState);
        this.saveZoomControl(outState);
        this.saveDeselectMarkersOnTap(outState);
        this.saveFocalPoint(outState);
    }

    void onRestoreInstanceState(@NonNull Bundle savedInstanceState) {
        this.restoreGestures(savedInstanceState);
        this.restoreCompass(savedInstanceState);
        this.restoreLogo(savedInstanceState);
        this.restoreZoomControl(savedInstanceState);
        this.restoreDeselectMarkersOnTap(savedInstanceState);
        this.restoreFocalPoint(savedInstanceState);
    }

    private void initialiseGestures(MapirMapOptions options) {
        this.setZoomGesturesEnabled(options.getZoomGesturesEnabled());
        this.setScrollGesturesEnabled(options.getScrollGesturesEnabled());
        this.setRotateGesturesEnabled(options.getRotateGesturesEnabled());
        this.setTiltGesturesEnabled(options.getTiltGesturesEnabled());
        this.setZoomControlsEnabled(options.getZoomControlsEnabled());
        this.setDoubleTapGesturesEnabled(options.getDoubleTapGesturesEnabled());
    }

    private void saveGestures(Bundle outState) {
        outState.putBoolean("mapir_zoomEnabled", this.isZoomGesturesEnabled());
        outState.putBoolean("mapir_scrollEnabled", this.isScrollGesturesEnabled());
        outState.putBoolean("mapir_rotateEnabled", this.isRotateGesturesEnabled());
        outState.putBoolean("mapir_tiltEnabled", this.isTiltGesturesEnabled());
        outState.putBoolean("mapir_doubleTapEnabled", this.isDoubleTapGesturesEnabled());
        outState.putBoolean("mapir_scaleAnimationEnabled", this.isScaleVelocityAnimationEnabled());
        outState.putBoolean("mapir_rotateAnimationEnabled", this.isRotateVelocityAnimationEnabled());
        outState.putBoolean("mapir_flingAnimationEnabled", this.isFlingVelocityAnimationEnabled());
        outState.putBoolean("mapir_increaseRotateThreshold", this.isIncreaseRotateThresholdWhenScaling());
        outState.putBoolean("mapir_increaseScaleThreshold", this.isIncreaseScaleThresholdWhenRotating());
    }

    private void restoreGestures(Bundle savedInstanceState) {
        this.setZoomGesturesEnabled(savedInstanceState.getBoolean("mapir_zoomEnabled"));
        this.setScrollGesturesEnabled(savedInstanceState.getBoolean("mapir_scrollEnabled"));
        this.setRotateGesturesEnabled(savedInstanceState.getBoolean("mapir_rotateEnabled"));
        this.setTiltGesturesEnabled(savedInstanceState.getBoolean("mapir_tiltEnabled"));
        this.setDoubleTapGesturesEnabled(savedInstanceState.getBoolean("mapir_doubleTapEnabled"));
        this.setScaleVelocityAnimationEnabled(savedInstanceState.getBoolean("mapir_scaleAnimationEnabled"));
        this.setRotateVelocityAnimationEnabled(savedInstanceState.getBoolean("mapir_rotateAnimationEnabled"));
        this.setFlingVelocityAnimationEnabled(savedInstanceState.getBoolean("mapir_flingAnimationEnabled"));
        this.setIncreaseRotateThresholdWhenScaling(savedInstanceState.getBoolean("mapir_increaseRotateThreshold"));
        this.setIncreaseScaleThresholdWhenRotating(savedInstanceState.getBoolean("mapir_increaseScaleThreshold"));
    }

    private void initialiseCompass(MapirMapOptions options, Resources resources) {
        this.setCompassEnabled(options.getCompassEnabled());
        this.setCompassGravity(options.getCompassGravity());
        int[] compassMargins = options.getCompassMargins();
        if (compassMargins != null) {
            this.setCompassMargins(compassMargins[0], compassMargins[1], compassMargins[2], compassMargins[3]);
        } else {
            int tenDp = (int)resources.getDimension(R.dimen.mapir_four_dp);
            this.setCompassMargins(tenDp, tenDp, tenDp, tenDp);
        }
        this.setCompassFadeFacingNorth(options.getCompassFadeFacingNorth());
        if (options.getCompassImage() == null) {
            options.compassImage(ResourcesCompat.getDrawable((Resources)resources, (int)R.drawable.mapir_compass_icon, null));
        }
        this.setCompassImage(options.getCompassImage());
    }

    private void saveCompass(Bundle outState) {
        outState.putBoolean("mapir_compassEnabled", this.isCompassEnabled());
        outState.putInt("mapir_compassGravity", this.getCompassGravity());
        outState.putInt("mapir_compassMarginLeft", this.getCompassMarginLeft());
        outState.putInt("mapir_compassMarginTop", this.getCompassMarginTop());
        outState.putInt("mapir_compassMarginBottom", this.getCompassMarginBottom());
        outState.putInt("mapir_compassMarginRight", this.getCompassMarginRight());
        outState.putBoolean("mapir_compassFade", this.isCompassFadeWhenFacingNorth());
        outState.putByteArray("mapir_compassImage", BitmapUtils.getByteArrayFromDrawable(this.getCompassImage()));
    }

    private void restoreCompass(Bundle savedInstanceState) {
        this.setCompassEnabled(savedInstanceState.getBoolean("mapir_compassEnabled"));
        this.setCompassGravity(savedInstanceState.getInt("mapir_compassGravity"));
        this.setCompassMargins(savedInstanceState.getInt("mapir_compassMarginLeft"), savedInstanceState.getInt("mapir_compassMarginTop"), savedInstanceState.getInt("mapir_compassMarginRight"), savedInstanceState.getInt("mapir_compassMarginBottom"));
        this.setCompassFadeFacingNorth(savedInstanceState.getBoolean("mapir_compassFade"));
        this.setCompassImage(BitmapUtils.getDrawableFromByteArray(this.compassView.getContext(), savedInstanceState.getByteArray("mapir_compassImage")));
    }

    private void initialiseLogo(MapirMapOptions options, Resources resources) {
        this.setLogoEnabled(options.getLogoEnabled());
        this.setLogoGravity(options.getLogoGravity());
        this.setLogoMargins(resources, options.getLogoMargins());
    }

    private void setLogoMargins(Resources resources, int[] logoMargins) {
        if (logoMargins != null) {
            this.setLogoMargins(logoMargins[0], logoMargins[1], logoMargins[2], logoMargins[3]);
        } else {
            int fourDp = (int)resources.getDimension(R.dimen.mapir_four_dp);
            this.setLogoMargins(fourDp, fourDp, fourDp, fourDp);
        }
    }

    private void saveLogo(Bundle outState) {
        outState.putInt("mapir_logoGravity", this.getLogoGravity());
        outState.putInt("mapir_logoMarginLeft", this.getLogoMarginLeft());
        outState.putInt("mapir_logoMarginTop", this.getLogoMarginTop());
        outState.putInt("mapir_logoMarginRight", this.getLogoMarginRight());
        outState.putInt("mapir_logoMarginBottom", this.getLogoMarginBottom());
        outState.putBoolean("mapir_logoEnabled", this.isLogoEnabled());
    }

    private void restoreLogo(Bundle savedInstanceState) {
        this.setLogoEnabled(savedInstanceState.getBoolean("mapir_logoEnabled"));
        this.setLogoGravity(savedInstanceState.getInt("mapir_logoGravity"));
        this.setLogoMargins(savedInstanceState.getInt("mapir_logoMarginLeft"), savedInstanceState.getInt("mapir_logoMarginTop"), savedInstanceState.getInt("mapir_logoMarginRight"), savedInstanceState.getInt("mapir_logoMarginBottom"));
    }

    private void initialiseZoomControl(Context context) {
        if (!context.getPackageManager().hasSystemFeature("android.hardware.touchscreen.multitouch")) {
            this.setZoomControlsEnabled(true);
        }
    }

    private void saveZoomControl(Bundle outState) {
        outState.putBoolean("mapir_zoomControlsEnabled", this.isZoomControlsEnabled());
    }

    private void restoreZoomControl(Bundle savedInstanceState) {
        this.setZoomControlsEnabled(savedInstanceState.getBoolean("mapir_zoomControlsEnabled"));
    }

    public boolean isCompassEnabled() {
        return this.compassView.isEnabled();
    }

    public void setCompassEnabled(boolean compassEnabled) {
        this.compassView.setEnabled(compassEnabled);
    }

    public void setCompassFadeFacingNorth(boolean compassFadeFacingNorth) {
        this.compassView.fadeCompassViewFacingNorth(compassFadeFacingNorth);
    }

    public boolean isCompassFadeWhenFacingNorth() {
        return this.compassView.isFadeCompassViewFacingNorth();
    }

    public int getCompassGravity() {
        return ((FrameLayout.LayoutParams)this.compassView.getLayoutParams()).gravity;
    }

    @UiThread
    public void setCompassGravity(int gravity) {
        this.setWidgetGravity((View)this.compassView, gravity);
    }

    @UiThread
    public void setCompassMargins(int left, int top, int right, int bottom) {
        this.setWidgetMargins((View)this.compassView, this.compassMargins, left, top, right, bottom);
    }

    public int getCompassMarginLeft() {
        return this.compassMargins[0];
    }

    public int getCompassMarginTop() {
        return this.compassMargins[1];
    }

    public int getCompassMarginRight() {
        return this.compassMargins[2];
    }

    public int getCompassMarginBottom() {
        return this.compassMargins[3];
    }

    @NonNull
    public Drawable getCompassImage() {
        return this.compassView.getCompassImage();
    }

    public void setCompassImage(@NonNull Drawable compass) {
        this.compassView.setCompassImage(compass);
    }

    void update(@NonNull CameraPosition cameraPosition) {
        if (!this.isCompassEnabled()) {
            return;
        }
        double clockwiseBearing = -cameraPosition.bearing;
        this.compassView.update(clockwiseBearing);
    }

    public boolean isLogoEnabled() {
        return this.logoView.getVisibility() == 0;
    }

    public void setLogoEnabled(boolean enabled) {
        this.logoView.setVisibility(enabled ? 0 : 8);
    }

    public int getLogoGravity() {
        return ((FrameLayout.LayoutParams)this.logoView.getLayoutParams()).gravity;
    }

    public void setLogoGravity(int gravity) {
        this.setWidgetGravity(this.logoView, gravity);
    }

    public void setLogoMargins(int left, int top, int right, int bottom) {
        this.setWidgetMargins(this.logoView, this.logoMargins, left, top, right, bottom);
    }

    public int getLogoMarginLeft() {
        return this.logoMargins[0];
    }

    public int getLogoMarginTop() {
        return this.logoMargins[1];
    }

    public int getLogoMarginRight() {
        return this.logoMargins[2];
    }

    public int getLogoMarginBottom() {
        return this.logoMargins[3];
    }

    @NonNull
    public AttributionDialogManager getAttributionDialogManager() {
        return this.attributionDialogManager;
    }

    public void setAttributionDialogManager(@NonNull AttributionDialogManager attributionDialogManager) {
        this.attributionDialogManager = attributionDialogManager;
    }

    public int getAttributionMarginLeft() {
        return this.attributionsMargins[0];
    }

    public int getAttributionMarginTop() {
        return this.attributionsMargins[1];
    }

    public int getAttributionMarginRight() {
        return this.attributionsMargins[2];
    }

    public int getAttributionMarginBottom() {
        return this.attributionsMargins[3];
    }

    public boolean isRotateGesturesEnabled() {
        return this.rotateGesturesEnabled;
    }

    public void setRotateGesturesEnabled(boolean rotateGesturesEnabled) {
        this.rotateGesturesEnabled = rotateGesturesEnabled;
    }

    public boolean isTiltGesturesEnabled() {
        return this.tiltGesturesEnabled;
    }

    public void setTiltGesturesEnabled(boolean tiltGesturesEnabled) {
        this.tiltGesturesEnabled = tiltGesturesEnabled;
    }

    public boolean isZoomGesturesEnabled() {
        return this.zoomGesturesEnabled;
    }

    public void setZoomGesturesEnabled(boolean zoomGesturesEnabled) {
        this.zoomGesturesEnabled = zoomGesturesEnabled;
    }

    public boolean isZoomControlsEnabled() {
        return this.zoomControlsEnabled;
    }

    @Deprecated
    public void setZoomControlsEnabled(boolean zoomControlsEnabled) {
        this.zoomControlsEnabled = zoomControlsEnabled;
    }

    public boolean isDoubleTapGesturesEnabled() {
        return this.doubleTapGesturesEnabled;
    }

    public void setDoubleTapGesturesEnabled(boolean doubleTapGesturesEnabled) {
        this.doubleTapGesturesEnabled = doubleTapGesturesEnabled;
    }

    private void restoreDeselectMarkersOnTap(Bundle savedInstanceState) {
        this.setDeselectMarkersOnTap(savedInstanceState.getBoolean("mapir_deselectMarkerOnTap"));
    }

    private void saveDeselectMarkersOnTap(Bundle outState) {
        outState.putBoolean("mapir_deselectMarkerOnTap", this.isDeselectMarkersOnTap());
    }

    public boolean isDeselectMarkersOnTap() {
        return this.deselectMarkersOnTap;
    }

    public void setDeselectMarkersOnTap(boolean deselectMarkersOnTap) {
        this.deselectMarkersOnTap = deselectMarkersOnTap;
    }

    public boolean isScrollGesturesEnabled() {
        return this.scrollGesturesEnabled;
    }

    public void setScrollGesturesEnabled(boolean scrollGesturesEnabled) {
        this.scrollGesturesEnabled = scrollGesturesEnabled;
    }

    public boolean isScaleVelocityAnimationEnabled() {
        return this.scaleVelocityAnimationEnabled;
    }

    public void setScaleVelocityAnimationEnabled(boolean scaleVelocityAnimationEnabled) {
        this.scaleVelocityAnimationEnabled = scaleVelocityAnimationEnabled;
    }

    public boolean isRotateVelocityAnimationEnabled() {
        return this.rotateVelocityAnimationEnabled;
    }

    public void setRotateVelocityAnimationEnabled(boolean rotateVelocityAnimationEnabled) {
        this.rotateVelocityAnimationEnabled = rotateVelocityAnimationEnabled;
    }

    public boolean isFlingVelocityAnimationEnabled() {
        return this.flingVelocityAnimationEnabled;
    }

    public void setFlingVelocityAnimationEnabled(boolean flingVelocityAnimationEnabled) {
        this.flingVelocityAnimationEnabled = flingVelocityAnimationEnabled;
    }

    public void setAllVelocityAnimationsEnabled(boolean allVelocityAnimationsEnabled) {
        this.setScaleVelocityAnimationEnabled(allVelocityAnimationsEnabled);
        this.setRotateVelocityAnimationEnabled(allVelocityAnimationsEnabled);
        this.setFlingVelocityAnimationEnabled(allVelocityAnimationsEnabled);
    }

    public boolean isIncreaseRotateThresholdWhenScaling() {
        return this.increaseRotateThresholdWhenScaling;
    }

    public void setIncreaseRotateThresholdWhenScaling(boolean increaseRotateThresholdWhenScaling) {
        this.increaseRotateThresholdWhenScaling = increaseRotateThresholdWhenScaling;
    }

    public boolean isIncreaseScaleThresholdWhenRotating() {
        return this.increaseScaleThresholdWhenRotating;
    }

    public void setIncreaseScaleThresholdWhenRotating(boolean increaseScaleThresholdWhenRotating) {
        this.increaseScaleThresholdWhenRotating = increaseScaleThresholdWhenRotating;
    }

    public void setAllGesturesEnabled(boolean enabled) {
        this.setScrollGesturesEnabled(enabled);
        this.setRotateGesturesEnabled(enabled);
        this.setTiltGesturesEnabled(enabled);
        this.setZoomGesturesEnabled(enabled);
        this.setDoubleTapGesturesEnabled(enabled);
    }

    private void saveFocalPoint(Bundle outState) {
        outState.putParcelable("mapir_userFocalPoint", (Parcelable)this.getFocalPoint());
    }

    private void restoreFocalPoint(Bundle savedInstanceState) {
        PointF pointF = (PointF)savedInstanceState.getParcelable("mapir_userFocalPoint");
        if (pointF != null) {
            this.setFocalPoint(pointF);
        }
    }

    public PointF getFocalPoint() {
        return this.userProvidedFocalPoint;
    }

    public void setFocalPoint(@Nullable PointF focalPoint) {
        this.userProvidedFocalPoint = focalPoint;
        this.focalPointChangeListener.onFocalPointChanged(focalPoint);
    }

    public float getHeight() {
        return this.projection.getHeight();
    }

    public float getWidth() {
        return this.projection.getWidth();
    }

    float getPixelRatio() {
        return this.pixelRatio;
    }

    public void invalidate() {
        this.setLogoMargins(this.getLogoMarginLeft(), this.getLogoMarginTop(), this.getLogoMarginRight(), this.getLogoMarginBottom());
        this.setCompassMargins(this.getCompassMarginLeft(), this.getCompassMarginTop(), this.getCompassMarginRight(), this.getCompassMarginBottom());
    }

    private void setWidgetGravity(@NonNull View view, int gravity) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        layoutParams.gravity = gravity;
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void setWidgetMargins(@NonNull View view, int[] initMargins, int left, int top, int right, int bottom) {
        initMargins[0] = left;
        initMargins[1] = top;
        initMargins[2] = right;
        initMargins[3] = bottom;
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        layoutParams.setMargins(left, top, right, bottom);
        if (Build.VERSION.SDK_INT >= 17) {
            layoutParams.setMarginStart(left);
            layoutParams.setMarginEnd(right);
        }
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }
}

