/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.maps;

import android.graphics.PointF;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import ir.map.sdk_map.annotations.MarkerViewManager;
import ir.map.sdk_map.camera.CameraPosition;
import ir.map.sdk_map.camera.CameraUpdate;
import ir.map.sdk_map.camera.CameraUpdateFactory;
import ir.map.sdk_map.geometry.LatLng;
import ir.map.sdk_map.log.Logger;
import ir.map.sdk_map.maps.CameraChangeDispatcher;
import ir.map.sdk_map.maps.MapView;
import ir.map.sdk_map.maps.MapirMap;
import ir.map.sdk_map.maps.MapirMapOptions;
import ir.map.sdk_map.maps.NativeMapView;

final class Transform
implements MapView.OnMapChangedListener {
    private static final String TAG = "Mbgl-Transform";
    private final NativeMapView mapView;
    private final MarkerViewManager markerViewManager;
    private final Handler handler = new Handler();
    private CameraPosition cameraPosition;
    private MapirMap.CancelableCallback cameraCancelableCallback;
    private MapirMap.OnCameraChangeListener onCameraChangeListener;
    private CameraChangeDispatcher cameraChangeDispatcher;

    Transform(NativeMapView mapView, MarkerViewManager markerViewManager, CameraChangeDispatcher cameraChangeDispatcher) {
        this.mapView = mapView;
        this.markerViewManager = markerViewManager;
        this.cameraChangeDispatcher = cameraChangeDispatcher;
    }

    void initialise(@NonNull MapirMap mapirMap, @NonNull MapirMapOptions options) {
        CameraPosition position = options.getCamera();
        if (position != null && !position.equals(CameraPosition.DEFAULT)) {
            this.moveCamera(mapirMap, CameraUpdateFactory.newCameraPosition(position), null);
        }
        this.setMinZoom(options.getMinZoomPreference());
        this.setMaxZoom(options.getMaxZoomPreference());
    }

    @UiThread
    public final CameraPosition getCameraPosition() {
        if (this.cameraPosition == null) {
            this.cameraPosition = this.invalidateCameraPosition();
        }
        return this.cameraPosition;
    }

    @UiThread
    void updateCameraPosition(@NonNull CameraPosition position) {
        this.markerViewManager.setTilt((float)position.tilt);
    }

    @Override
    public void onMapChanged(int change) {
        if (change == 4) {
            this.updateCameraPosition(this.invalidateCameraPosition());
            if (this.cameraCancelableCallback != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (Transform.this.cameraCancelableCallback != null) {
                            Transform.this.cameraCancelableCallback.onFinish();
                            Transform.this.cameraCancelableCallback = null;
                        }
                    }
                });
            }
            this.cameraChangeDispatcher.onCameraIdle();
            this.mapView.removeOnMapChangedListener(this);
        }
    }

    @UiThread
    final void moveCamera(MapirMap mapirMap, CameraUpdate update, final MapirMap.CancelableCallback callback) {
        CameraPosition cameraPosition = update.getCameraPosition(mapirMap);
        if (this.isValidCameraPosition(cameraPosition)) {
            this.cancelTransitions();
            this.cameraChangeDispatcher.onCameraMoveStarted(3);
            this.mapView.jumpTo(cameraPosition.bearing, cameraPosition.target, cameraPosition.tilt, cameraPosition.zoom);
            this.cameraChangeDispatcher.onCameraIdle();
            this.invalidateCameraPosition();
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    if (callback != null) {
                        callback.onFinish();
                    }
                }
            });
        }
    }

    @UiThread
    final void easeCamera(MapirMap mapirMap, CameraUpdate update, int durationMs, boolean easingInterpolator, MapirMap.CancelableCallback callback, boolean isDismissable) {
        CameraPosition cameraPosition = update.getCameraPosition(mapirMap);
        if (this.isValidCameraPosition(cameraPosition)) {
            this.cancelTransitions();
            this.cameraChangeDispatcher.onCameraMoveStarted(3);
            if (callback != null) {
                this.cameraCancelableCallback = callback;
            }
            this.mapView.addOnMapChangedListener(this);
            this.mapView.easeTo(cameraPosition.bearing, cameraPosition.target, durationMs, cameraPosition.tilt, cameraPosition.zoom, easingInterpolator);
        }
    }

    @UiThread
    final void animateCamera(MapirMap mapirMap, CameraUpdate update, int durationMs, MapirMap.CancelableCallback callback) {
        CameraPosition cameraPosition = update.getCameraPosition(mapirMap);
        if (this.isValidCameraPosition(cameraPosition)) {
            this.cancelTransitions();
            this.cameraChangeDispatcher.onCameraMoveStarted(3);
            if (callback != null) {
                this.cameraCancelableCallback = callback;
            }
            this.mapView.addOnMapChangedListener(this);
            this.mapView.flyTo(cameraPosition.bearing, cameraPosition.target, durationMs, cameraPosition.tilt, cameraPosition.zoom);
        }
    }

    private boolean isValidCameraPosition(@Nullable CameraPosition cameraPosition) {
        return cameraPosition != null && !cameraPosition.equals(this.cameraPosition);
    }

    @UiThread
    @Nullable
    CameraPosition invalidateCameraPosition() {
        if (this.mapView != null) {
            CameraPosition cameraPosition = this.mapView.getCameraPosition();
            if (this.cameraPosition != null && !this.cameraPosition.equals(cameraPosition)) {
                this.cameraChangeDispatcher.onCameraMove();
            }
            if (this.isComponentUpdateRequired(cameraPosition)) {
                this.updateCameraPosition(cameraPosition);
            }
            this.cameraPosition = cameraPosition;
            if (this.onCameraChangeListener != null) {
                this.onCameraChangeListener.onCameraChange(this.cameraPosition);
            }
        }
        return this.cameraPosition;
    }

    private boolean isComponentUpdateRequired(@NonNull CameraPosition cameraPosition) {
        return this.cameraPosition != null && (this.cameraPosition.tilt != cameraPosition.tilt || this.cameraPosition.bearing != cameraPosition.bearing);
    }

    void cancelTransitions() {
        this.cameraChangeDispatcher.onCameraMoveCanceled();
        if (this.cameraCancelableCallback != null) {
            final MapirMap.CancelableCallback callback = this.cameraCancelableCallback;
            this.cameraChangeDispatcher.onCameraIdle();
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    callback.onCancel();
                }
            });
            this.cameraCancelableCallback = null;
        }
        this.mapView.cancelTransitions();
        this.cameraChangeDispatcher.onCameraIdle();
    }

    @UiThread
    void resetNorth() {
        this.cancelTransitions();
        this.mapView.resetNorth();
    }

    void setOnCameraChangeListener(@Nullable MapirMap.OnCameraChangeListener listener) {
        this.onCameraChangeListener = listener;
    }

    double getRawZoom() {
        return this.mapView.getZoom();
    }

    void zoomBy(double zoomAddition, @NonNull PointF focalPoint) {
        this.setZoom(this.mapView.getZoom() + zoomAddition, focalPoint);
    }

    void setZoom(double zoom, @NonNull PointF focalPoint) {
        this.setZoom(zoom, focalPoint, 0L);
    }

    void setZoom(double zoom, @NonNull PointF focalPoint, final long duration) {
        if (this.mapView != null) {
            this.mapView.addOnMapChangedListener(new MapView.OnMapChangedListener(){

                @Override
                public void onMapChanged(int change) {
                    if (change == 4) {
                        if (duration > 0L) {
                            Transform.this.cameraChangeDispatcher.onCameraIdle();
                        }
                        Transform.this.mapView.removeOnMapChangedListener(this);
                    }
                }
            });
            this.mapView.setZoom(zoom, focalPoint, duration);
        }
    }

    double getBearing() {
        double direction;
        for (direction = -this.mapView.getBearing(); direction > 360.0; direction -= 360.0) {
        }
        while (direction < 0.0) {
            direction += 360.0;
        }
        return direction;
    }

    void setBearing(double bearing) {
        this.mapView.setBearing(bearing);
    }

    double getRawBearing() {
        return this.mapView.getBearing();
    }

    void setBearing(double bearing, float focalX, float focalY) {
        this.mapView.setBearing(bearing, focalX, focalY);
    }

    void setBearing(double bearing, float focalX, float focalY, long duration) {
        this.mapView.setBearing(bearing, focalX, focalY, duration);
    }

    LatLng getLatLng() {
        return this.mapView.getLatLng();
    }

    double getTilt() {
        return this.mapView.getPitch();
    }

    void setTilt(Double pitch) {
        this.markerViewManager.setTilt(pitch.floatValue());
        this.mapView.setPitch(pitch, 0L);
    }

    LatLng getCenterCoordinate() {
        return this.mapView.getLatLng();
    }

    void setCenterCoordinate(LatLng centerCoordinate) {
        this.mapView.setLatLng(centerCoordinate);
    }

    void setGestureInProgress(boolean gestureInProgress) {
        this.mapView.setGestureInProgress(gestureInProgress);
        if (!gestureInProgress) {
            this.invalidateCameraPosition();
        }
    }

    void moveBy(double offsetX, double offsetY, long duration) {
        if (duration > 0L) {
            this.mapView.addOnMapChangedListener(new MapView.OnMapChangedListener(){

                @Override
                public void onMapChanged(int change) {
                    if (change == 4) {
                        Transform.this.mapView.removeOnMapChangedListener(this);
                        Transform.this.cameraChangeDispatcher.onCameraIdle();
                    }
                }
            });
        }
        this.mapView.moveBy(offsetX, offsetY, duration);
    }

    double getMinZoom() {
        return this.mapView.getMinZoom();
    }

    void setMinZoom(double minZoom) {
        if (minZoom < 0.0 || minZoom > 25.5) {
            Logger.e(TAG, String.format("Not setting minZoomPreference, value is in unsupported range: %s", minZoom));
            return;
        }
        this.mapView.setMinZoom(minZoom);
    }

    double getMaxZoom() {
        return this.mapView.getMaxZoom();
    }

    void setMaxZoom(double maxZoom) {
        if (maxZoom < 0.0 || maxZoom > 25.5) {
            Logger.e(TAG, String.format("Not setting maxZoomPreference, value is in unsupported range: %s", maxZoom));
            return;
        }
        this.mapView.setMaxZoom(maxZoom);
    }
}

