/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.maps;

import android.graphics.RectF;
import android.support.v4.util.LongSparseArray;
import ir.map.sdk_map.annotations.Annotation;
import ir.map.sdk_map.maps.NativeMapView;
import ir.map.sdk_map.maps.ShapeAnnotations;
import java.util.ArrayList;
import java.util.List;

class ShapeAnnotationContainer
implements ShapeAnnotations {
    private final NativeMapView nativeMapView;
    private final LongSparseArray<Annotation> annotations;

    ShapeAnnotationContainer(NativeMapView nativeMapView, LongSparseArray<Annotation> annotations) {
        this.nativeMapView = nativeMapView;
        this.annotations = annotations;
    }

    @Override
    public List<Annotation> obtainAllIn(RectF rectangle) {
        RectF rect = this.nativeMapView.getDensityDependantRectangle(rectangle);
        long[] annotationIds = this.nativeMapView.queryShapeAnnotations(rect);
        return this.getAnnotationsFromIds(annotationIds);
    }

    private List<Annotation> getAnnotationsFromIds(long[] annotationIds) {
        ArrayList<Annotation> shapeAnnotations = new ArrayList<Annotation>();
        for (long annotationId : annotationIds) {
            Annotation annotation = (Annotation)this.annotations.get(annotationId);
            if (annotation == null) continue;
            shapeAnnotations.add(annotation);
        }
        return shapeAnnotations;
    }
}

