/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.maps;

import android.support.annotation.NonNull;
import android.support.v4.util.LongSparseArray;
import ir.map.sdk_map.annotations.Annotation;
import ir.map.sdk_map.annotations.Polyline;
import ir.map.sdk_map.annotations.PolylineOptions;
import ir.map.sdk_map.maps.MapirMap;
import ir.map.sdk_map.maps.NativeMapView;
import ir.map.sdk_map.maps.Polylines;
import java.util.ArrayList;
import java.util.List;

class PolylineContainer
implements Polylines {
    private final NativeMapView nativeMapView;
    private final LongSparseArray<Annotation> annotations;

    PolylineContainer(NativeMapView nativeMapView, LongSparseArray<Annotation> annotations) {
        this.nativeMapView = nativeMapView;
        this.annotations = annotations;
    }

    @Override
    public Polyline addBy(@NonNull PolylineOptions polylineOptions, @NonNull MapirMap mapirMap) {
        Polyline polyline = polylineOptions.getPolyline();
        if (!polyline.getPoints().isEmpty()) {
            long id2 = this.nativeMapView != null ? this.nativeMapView.addPolyline(polyline) : 0L;
            polyline.setMapirMap(mapirMap);
            polyline.setId(id2);
            this.annotations.put(id2, (Object)polyline);
        }
        return polyline;
    }

    @Override
    public List<Polyline> addBy(@NonNull List<PolylineOptions> polylineOptionsList, @NonNull MapirMap mapirMap) {
        int count = polylineOptionsList.size();
        ArrayList<Polyline> polylines = new ArrayList<Polyline>(count);
        if (this.nativeMapView != null && count > 0) {
            for (PolylineOptions options : polylineOptionsList) {
                Polyline polyline = options.getPolyline();
                if (polyline.getPoints().isEmpty()) continue;
                polylines.add(polyline);
            }
            long[] ids = this.nativeMapView.addPolylines(polylines);
            for (int i = 0; i < ids.length; ++i) {
                Polyline polylineCreated = (Polyline)polylines.get(i);
                polylineCreated.setMapirMap(mapirMap);
                polylineCreated.setId(ids[i]);
                this.annotations.put(ids[i], (Object)polylineCreated);
            }
        }
        return polylines;
    }

    @Override
    public void update(Polyline polyline) {
        this.nativeMapView.updatePolyline(polyline);
        this.annotations.setValueAt(this.annotations.indexOfKey(polyline.getId()), (Object)polyline);
    }

    @Override
    public List<Polyline> obtainAll() {
        ArrayList<Polyline> polylines = new ArrayList<Polyline>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            Annotation annotation = (Annotation)this.annotations.get(this.annotations.keyAt(i));
            if (!(annotation instanceof Polyline)) continue;
            polylines.add((Polyline)annotation);
        }
        return polylines;
    }
}

