/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.maps;

import android.support.annotation.NonNull;
import android.support.v4.util.LongSparseArray;
import ir.map.sdk_map.annotations.Annotation;
import ir.map.sdk_map.annotations.Polygon;
import ir.map.sdk_map.annotations.PolygonOptions;
import ir.map.sdk_map.maps.MapirMap;
import ir.map.sdk_map.maps.NativeMapView;
import ir.map.sdk_map.maps.Polygons;
import java.util.ArrayList;
import java.util.List;

class PolygonContainer
implements Polygons {
    private final NativeMapView nativeMapView;
    private final LongSparseArray<Annotation> annotations;

    PolygonContainer(NativeMapView nativeMapView, LongSparseArray<Annotation> annotations) {
        this.nativeMapView = nativeMapView;
        this.annotations = annotations;
    }

    @Override
    public Polygon addBy(@NonNull PolygonOptions polygonOptions, @NonNull MapirMap mapirMap) {
        Polygon polygon = polygonOptions.getPolygon();
        if (!polygon.getPoints().isEmpty()) {
            long id2 = this.nativeMapView != null ? this.nativeMapView.addPolygon(polygon) : 0L;
            polygon.setId(id2);
            polygon.setMapirMap(mapirMap);
            this.annotations.put(id2, (Object)polygon);
        }
        return polygon;
    }

    @Override
    public List<Polygon> addBy(@NonNull List<PolygonOptions> polygonOptionsList, @NonNull MapirMap mapirMap) {
        int count = polygonOptionsList.size();
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(count);
        if (this.nativeMapView != null && count > 0) {
            Polygon polygon;
            for (PolygonOptions polygonOptions : polygonOptionsList) {
                polygon = polygonOptions.getPolygon();
                if (polygon.getPoints().isEmpty()) continue;
                polygons.add(polygon);
            }
            long[] ids = this.nativeMapView.addPolygons(polygons);
            for (int i = 0; i < ids.length; ++i) {
                polygon = (Polygon)polygons.get(i);
                polygon.setMapirMap(mapirMap);
                polygon.setId(ids[i]);
                this.annotations.put(ids[i], (Object)polygon);
            }
        }
        return polygons;
    }

    @Override
    public void update(Polygon polygon) {
        this.nativeMapView.updatePolygon(polygon);
        this.annotations.setValueAt(this.annotations.indexOfKey(polygon.getId()), (Object)polygon);
    }

    @Override
    public List<Polygon> obtainAll() {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            Annotation annotation = (Annotation)this.annotations.get(this.annotations.keyAt(i));
            if (!(annotation instanceof Polygon)) continue;
            polygons.add((Polygon)annotation);
        }
        return polygons;
    }
}

