/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.maps;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.res.ResourcesCompat;
import android.util.AttributeSet;
import ir.map.sdk_map.R;
import ir.map.sdk_map.camera.CameraPosition;
import ir.map.sdk_map.utils.BitmapUtils;
import java.util.Arrays;

public class MapirMapOptions
implements Parcelable {
    public static final Parcelable.Creator<MapirMapOptions> CREATOR = new Parcelable.Creator<MapirMapOptions>(){

        public MapirMapOptions createFromParcel(Parcel in) {
            return new MapirMapOptions(in);
        }

        public MapirMapOptions[] newArray(int size) {
            return new MapirMapOptions[size];
        }
    };
    private static final int LIGHT_GRAY = -988703;
    private static final float FOUR_DP = 4.0f;
    private static final float NINETY_TWO_DP = 92.0f;
    private static final int UNDEFINED_COLOR = -1;
    private CameraPosition cameraPosition;
    private boolean debugActive;
    private boolean compassEnabled = true;
    private boolean fadeCompassFacingNorth = true;
    private int compassGravity = 8388661;
    private int[] compassMargins;
    private Drawable compassImage;
    private boolean logoEnabled = true;
    private int logoGravity = 8388691;
    private int[] logoMargins;
    @ColorInt
    private int attributionTintColor = -1;
    private boolean attributionEnabled = true;
    private int attributionGravity = 8388691;
    private int[] attributionMargins;
    private double minZoom = 0.0;
    private double maxZoom = 25.5;
    private boolean rotateGesturesEnabled = true;
    private boolean scrollGesturesEnabled = true;
    private boolean tiltGesturesEnabled = true;
    private boolean zoomGesturesEnabled = true;
    private boolean zoomControlsEnabled = false;
    private boolean doubleTapGesturesEnabled = true;
    private boolean prefetchesTiles = true;
    private boolean zMediaOverlay = false;
    private String localIdeographFontFamily;
    private String apiBaseUrl;
    private boolean textureMode;
    private boolean translucentTextureSurface;
    @ColorInt
    private int foregroundLoadColor;
    private String styleUrl;
    private String styleJson;
    private float pixelRatio;
    private boolean crossSourceCollisions = true;

    public MapirMapOptions() {
    }

    private MapirMapOptions(Parcel in) {
        this.cameraPosition = (CameraPosition)in.readParcelable(CameraPosition.class.getClassLoader());
        this.debugActive = in.readByte() != 0;
        this.compassEnabled = in.readByte() != 0;
        this.compassGravity = in.readInt();
        this.compassMargins = in.createIntArray();
        this.fadeCompassFacingNorth = in.readByte() != 0;
        Bitmap compassBitmap = (Bitmap)in.readParcelable(this.getClass().getClassLoader());
        if (compassBitmap != null) {
            this.compassImage = new BitmapDrawable(compassBitmap);
        }
        this.logoEnabled = in.readByte() != 0;
        this.logoGravity = in.readInt();
        this.logoMargins = in.createIntArray();
        this.attributionEnabled = in.readByte() != 0;
        this.attributionGravity = in.readInt();
        this.attributionMargins = in.createIntArray();
        this.attributionTintColor = in.readInt();
        this.minZoom = in.readDouble();
        this.maxZoom = in.readDouble();
        this.rotateGesturesEnabled = in.readByte() != 0;
        this.scrollGesturesEnabled = in.readByte() != 0;
        this.tiltGesturesEnabled = in.readByte() != 0;
        this.zoomControlsEnabled = in.readByte() != 0;
        this.zoomGesturesEnabled = in.readByte() != 0;
        this.doubleTapGesturesEnabled = in.readByte() != 0;
        this.styleUrl = in.readString();
        this.styleJson = in.readString();
        this.apiBaseUrl = in.readString();
        this.textureMode = in.readByte() != 0;
        this.translucentTextureSurface = in.readByte() != 0;
        this.prefetchesTiles = in.readByte() != 0;
        this.zMediaOverlay = in.readByte() != 0;
        this.localIdeographFontFamily = in.readString();
        this.pixelRatio = in.readFloat();
        this.foregroundLoadColor = in.readInt();
        this.crossSourceCollisions = in.readByte() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MapirMapOptions createFromAttributes(@NonNull Context context, @Nullable AttributeSet attrs) {
        MapirMapOptions mapirMapOptions = new MapirMapOptions();
        float pxlRatio = context.getResources().getDisplayMetrics().density;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.mapir_MapView, 0, 0);
        try {
            mapirMapOptions.camera(new CameraPosition.Builder(typedArray).build());
            mapirMapOptions.styleUrl(typedArray.getString(R.styleable.mapir_MapView_mapir_styleUrl));
            mapirMapOptions.styleJson(typedArray.getString(R.styleable.mapir_MapView_mapir_styleJson));
            mapirMapOptions.apiBaseUrl(typedArray.getString(R.styleable.mapir_MapView_mapir_apiBaseUrl));
            mapirMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.mapir_MapView_mapir_uiZoomGestures, true));
            mapirMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.mapir_MapView_mapir_uiScrollGestures, true));
            mapirMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.mapir_MapView_mapir_uiRotateGestures, true));
            mapirMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.mapir_MapView_mapir_uiTiltGestures, true));
            mapirMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.mapir_MapView_mapir_uiZoomControls, false));
            mapirMapOptions.doubleTapGesturesEnabled(typedArray.getBoolean(R.styleable.mapir_MapView_mapir_uiDoubleTapGestures, true));
            mapirMapOptions.maxZoomPreference(typedArray.getFloat(R.styleable.mapir_MapView_mapir_cameraZoomMax, 25.5f));
            mapirMapOptions.minZoomPreference(typedArray.getFloat(R.styleable.mapir_MapView_mapir_cameraZoomMin, 0.0f));
            mapirMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.mapir_MapView_mapir_uiCompass, true));
            mapirMapOptions.compassGravity(typedArray.getInt(R.styleable.mapir_MapView_mapir_uiCompassGravity, 8388661));
            mapirMapOptions.compassMargins(new int[]{(int)typedArray.getDimension(R.styleable.mapir_MapView_mapir_uiCompassMarginLeft, 4.0f * pxlRatio), (int)typedArray.getDimension(R.styleable.mapir_MapView_mapir_uiCompassMarginTop, 4.0f * pxlRatio), (int)typedArray.getDimension(R.styleable.mapir_MapView_mapir_uiCompassMarginRight, 4.0f * pxlRatio), (int)typedArray.getDimension(R.styleable.mapir_MapView_mapir_uiCompassMarginBottom, 4.0f * pxlRatio)});
            mapirMapOptions.compassFadesWhenFacingNorth(typedArray.getBoolean(R.styleable.mapir_MapView_mapir_uiCompassFadeFacingNorth, true));
            Drawable compassDrawable = typedArray.getDrawable(R.styleable.mapir_MapView_mapir_uiCompassDrawable);
            if (compassDrawable == null) {
                compassDrawable = ResourcesCompat.getDrawable((Resources)context.getResources(), (int)R.drawable.mapir_compass_icon, null);
            }
            mapirMapOptions.compassImage(compassDrawable);
            mapirMapOptions.logoEnabled(typedArray.getBoolean(R.styleable.mapir_MapView_mapir_uiLogo, true));
            mapirMapOptions.logoGravity(typedArray.getInt(R.styleable.mapir_MapView_mapir_uiLogoGravity, 8388691));
            mapirMapOptions.logoMargins(new int[]{(int)typedArray.getDimension(R.styleable.mapir_MapView_mapir_uiLogoMarginLeft, 4.0f * pxlRatio), (int)typedArray.getDimension(R.styleable.mapir_MapView_mapir_uiLogoMarginTop, 4.0f * pxlRatio), (int)typedArray.getDimension(R.styleable.mapir_MapView_mapir_uiLogoMarginRight, 4.0f * pxlRatio), (int)typedArray.getDimension(R.styleable.mapir_MapView_mapir_uiLogoMarginBottom, 4.0f * pxlRatio)});
            mapirMapOptions.attributionTintColor(typedArray.getColor(R.styleable.mapir_MapView_mapir_uiAttributionTintColor, -1));
            mapirMapOptions.attributionEnabled(typedArray.getBoolean(R.styleable.mapir_MapView_mapir_uiAttribution, true));
            mapirMapOptions.attributionGravity(typedArray.getInt(R.styleable.mapir_MapView_mapir_uiAttributionGravity, 8388691));
            mapirMapOptions.attributionMargins(new int[]{(int)typedArray.getDimension(R.styleable.mapir_MapView_mapir_uiAttributionMarginLeft, 92.0f * pxlRatio), (int)typedArray.getDimension(R.styleable.mapir_MapView_mapir_uiAttributionMarginTop, 4.0f * pxlRatio), (int)typedArray.getDimension(R.styleable.mapir_MapView_mapir_uiAttributionMarginRight, 4.0f * pxlRatio), (int)typedArray.getDimension(R.styleable.mapir_MapView_mapir_uiAttributionMarginBottom, 4.0f * pxlRatio)});
            mapirMapOptions.textureMode(typedArray.getBoolean(R.styleable.mapir_MapView_mapir_renderTextureMode, false));
            mapirMapOptions.translucentTextureSurface(typedArray.getBoolean(R.styleable.mapir_MapView_mapir_renderTextureTranslucentSurface, false));
            mapirMapOptions.setPrefetchesTiles(typedArray.getBoolean(R.styleable.mapir_MapView_mapir_enableTilePrefetch, true));
            mapirMapOptions.renderSurfaceOnTop(typedArray.getBoolean(R.styleable.mapir_MapView_mapir_enableZMediaOverlay, false));
            mapirMapOptions.localIdeographFontFamily(typedArray.getString(R.styleable.mapir_MapView_mapir_localIdeographFontFamily));
            mapirMapOptions.pixelRatio(typedArray.getFloat(R.styleable.mapir_MapView_mapir_pixelRatio, 0.0f));
            mapirMapOptions.foregroundLoadColor(typedArray.getInt(R.styleable.mapir_MapView_mapir_foregroundLoadColor, -988703));
            mapirMapOptions.crossSourceCollisions(typedArray.getBoolean(R.styleable.mapir_MapView_mapir_cross_source_collisions, true));
        }
        finally {
            typedArray.recycle();
        }
        return mapirMapOptions;
    }

    public MapirMapOptions apiBaseUrl(String apiBaseUrl) {
        this.apiBaseUrl = apiBaseUrl;
        return this;
    }

    public MapirMapOptions camera(CameraPosition cameraPosition) {
        this.cameraPosition = cameraPosition;
        return this;
    }

    public MapirMapOptions styleUrl(String styleUrl) {
        this.styleUrl = styleUrl;
        return this;
    }

    public MapirMapOptions styleJson(String styleJson) {
        this.styleJson = styleJson;
        return this;
    }

    public MapirMapOptions debugActive(boolean enabled) {
        this.debugActive = enabled;
        return this;
    }

    public MapirMapOptions minZoomPreference(double minZoom) {
        this.minZoom = minZoom;
        return this;
    }

    public MapirMapOptions maxZoomPreference(double maxZoom) {
        this.maxZoom = maxZoom;
        return this;
    }

    public MapirMapOptions compassEnabled(boolean enabled) {
        this.compassEnabled = enabled;
        return this;
    }

    public MapirMapOptions compassGravity(int gravity) {
        this.compassGravity = gravity;
        return this;
    }

    public MapirMapOptions compassMargins(int[] margins) {
        this.compassMargins = margins;
        return this;
    }

    public MapirMapOptions compassFadesWhenFacingNorth(boolean compassFadeWhenFacingNorth) {
        this.fadeCompassFacingNorth = compassFadeWhenFacingNorth;
        return this;
    }

    public MapirMapOptions compassImage(Drawable compass) {
        this.compassImage = compass;
        return this;
    }

    public MapirMapOptions logoEnabled(boolean enabled) {
        this.logoEnabled = enabled;
        return this;
    }

    public MapirMapOptions logoGravity(int gravity) {
        this.logoGravity = gravity;
        return this;
    }

    public MapirMapOptions logoMargins(int[] margins) {
        this.logoMargins = margins;
        return this;
    }

    public MapirMapOptions attributionEnabled(boolean enabled) {
        this.attributionEnabled = enabled;
        return this;
    }

    public MapirMapOptions attributionGravity(int gravity) {
        this.attributionGravity = gravity;
        return this;
    }

    public MapirMapOptions attributionMargins(int[] margins) {
        this.attributionMargins = margins;
        return this;
    }

    public MapirMapOptions attributionTintColor(@ColorInt int color) {
        this.attributionTintColor = color;
        return this;
    }

    public MapirMapOptions rotateGesturesEnabled(boolean enabled) {
        this.rotateGesturesEnabled = enabled;
        return this;
    }

    public MapirMapOptions scrollGesturesEnabled(boolean enabled) {
        this.scrollGesturesEnabled = enabled;
        return this;
    }

    public MapirMapOptions tiltGesturesEnabled(boolean enabled) {
        this.tiltGesturesEnabled = enabled;
        return this;
    }

    @Deprecated
    public MapirMapOptions zoomControlsEnabled(boolean enabled) {
        this.zoomControlsEnabled = enabled;
        return this;
    }

    public MapirMapOptions zoomGesturesEnabled(boolean enabled) {
        this.zoomGesturesEnabled = enabled;
        return this;
    }

    public MapirMapOptions doubleTapGesturesEnabled(boolean enabled) {
        this.doubleTapGesturesEnabled = enabled;
        return this;
    }

    public MapirMapOptions textureMode(boolean textureMode) {
        this.textureMode = textureMode;
        return this;
    }

    public MapirMapOptions translucentTextureSurface(boolean translucentTextureSurface) {
        this.translucentTextureSurface = translucentTextureSurface;
        return this;
    }

    public MapirMapOptions foregroundLoadColor(@ColorInt int loadColor) {
        this.foregroundLoadColor = loadColor;
        return this;
    }

    public MapirMapOptions crossSourceCollisions(boolean crossSourceCollisions) {
        this.crossSourceCollisions = crossSourceCollisions;
        return this;
    }

    public MapirMapOptions localIdeographFontFamily(String fontFamily) {
        this.localIdeographFontFamily = fontFamily;
        return this;
    }

    public MapirMapOptions pixelRatio(float pixelRatio) {
        this.pixelRatio = pixelRatio;
        return this;
    }

    public boolean getPrefetchesTiles() {
        return this.prefetchesTiles;
    }

    public MapirMapOptions setPrefetchesTiles(boolean enable) {
        this.prefetchesTiles = enable;
        return this;
    }

    public boolean getCrossSourceCollisions() {
        return this.crossSourceCollisions;
    }

    public void renderSurfaceOnTop(boolean renderOnTop) {
        this.zMediaOverlay = renderOnTop;
    }

    public boolean getRenderSurfaceOnTop() {
        return this.zMediaOverlay;
    }

    public String getApiBaseUrl() {
        return this.apiBaseUrl;
    }

    public CameraPosition getCamera() {
        return this.cameraPosition;
    }

    public double getMinZoomPreference() {
        return this.minZoom;
    }

    public double getMaxZoomPreference() {
        return this.maxZoom;
    }

    public boolean getCompassEnabled() {
        return this.compassEnabled;
    }

    public int getCompassGravity() {
        return this.compassGravity;
    }

    public int[] getCompassMargins() {
        return this.compassMargins;
    }

    public boolean getCompassFadeFacingNorth() {
        return this.fadeCompassFacingNorth;
    }

    public Drawable getCompassImage() {
        return this.compassImage;
    }

    public boolean getLogoEnabled() {
        return this.logoEnabled;
    }

    public int getLogoGravity() {
        return this.logoGravity;
    }

    public int[] getLogoMargins() {
        return this.logoMargins;
    }

    public String getStyleUrl() {
        return this.styleUrl;
    }

    public String getStyleJson() {
        return this.styleJson;
    }

    public boolean getRotateGesturesEnabled() {
        return this.rotateGesturesEnabled;
    }

    public boolean getScrollGesturesEnabled() {
        return this.scrollGesturesEnabled;
    }

    public boolean getTiltGesturesEnabled() {
        return this.tiltGesturesEnabled;
    }

    public boolean getZoomControlsEnabled() {
        return this.zoomControlsEnabled;
    }

    public boolean getZoomGesturesEnabled() {
        return this.zoomGesturesEnabled;
    }

    public boolean getDoubleTapGesturesEnabled() {
        return this.doubleTapGesturesEnabled;
    }

    public boolean getAttributionEnabled() {
        return this.attributionEnabled;
    }

    public int getAttributionGravity() {
        return this.attributionGravity;
    }

    public int[] getAttributionMargins() {
        return this.attributionMargins;
    }

    @ColorInt
    public int getAttributionTintColor() {
        return this.attributionTintColor;
    }

    public boolean getDebugActive() {
        return this.debugActive;
    }

    public boolean getTextureMode() {
        return this.textureMode;
    }

    public boolean getTranslucentTextureSurface() {
        return this.translucentTextureSurface;
    }

    @ColorInt
    public int getForegroundLoadColor() {
        return this.foregroundLoadColor;
    }

    public String getLocalIdeographFontFamily() {
        return this.localIdeographFontFamily;
    }

    public float getPixelRatio() {
        return this.pixelRatio;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.cameraPosition, flags);
        dest.writeByte((byte)(this.debugActive ? 1 : 0));
        dest.writeByte((byte)(this.compassEnabled ? 1 : 0));
        dest.writeInt(this.compassGravity);
        dest.writeIntArray(this.compassMargins);
        dest.writeByte((byte)(this.fadeCompassFacingNorth ? 1 : 0));
        dest.writeParcelable((Parcelable)(this.compassImage != null ? BitmapUtils.getBitmapFromDrawable(this.compassImage) : null), flags);
        dest.writeByte((byte)(this.logoEnabled ? 1 : 0));
        dest.writeInt(this.logoGravity);
        dest.writeIntArray(this.logoMargins);
        dest.writeByte((byte)(this.attributionEnabled ? 1 : 0));
        dest.writeInt(this.attributionGravity);
        dest.writeIntArray(this.attributionMargins);
        dest.writeInt(this.attributionTintColor);
        dest.writeDouble(this.minZoom);
        dest.writeDouble(this.maxZoom);
        dest.writeByte((byte)(this.rotateGesturesEnabled ? 1 : 0));
        dest.writeByte((byte)(this.scrollGesturesEnabled ? 1 : 0));
        dest.writeByte((byte)(this.tiltGesturesEnabled ? 1 : 0));
        dest.writeByte((byte)(this.zoomControlsEnabled ? 1 : 0));
        dest.writeByte((byte)(this.zoomGesturesEnabled ? 1 : 0));
        dest.writeByte((byte)(this.doubleTapGesturesEnabled ? 1 : 0));
        dest.writeString(this.styleUrl);
        dest.writeString(this.styleJson);
        dest.writeString(this.apiBaseUrl);
        dest.writeByte((byte)(this.textureMode ? 1 : 0));
        dest.writeByte((byte)(this.translucentTextureSurface ? 1 : 0));
        dest.writeByte((byte)(this.prefetchesTiles ? 1 : 0));
        dest.writeByte((byte)(this.zMediaOverlay ? 1 : 0));
        dest.writeString(this.localIdeographFontFamily);
        dest.writeFloat(this.pixelRatio);
        dest.writeInt(this.foregroundLoadColor);
        dest.writeByte((byte)(this.crossSourceCollisions ? 1 : 0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapirMapOptions options = (MapirMapOptions)o;
        if (this.debugActive != options.debugActive) {
            return false;
        }
        if (this.compassEnabled != options.compassEnabled) {
            return false;
        }
        if (this.fadeCompassFacingNorth != options.fadeCompassFacingNorth) {
            return false;
        }
        if (this.compassImage != null ? !this.compassImage.equals(options.compassImage) : options.compassImage != null) {
            return false;
        }
        if (this.compassGravity != options.compassGravity) {
            return false;
        }
        if (this.logoEnabled != options.logoEnabled) {
            return false;
        }
        if (this.logoGravity != options.logoGravity) {
            return false;
        }
        if (this.attributionTintColor != options.attributionTintColor) {
            return false;
        }
        if (this.attributionEnabled != options.attributionEnabled) {
            return false;
        }
        if (this.attributionGravity != options.attributionGravity) {
            return false;
        }
        if (Double.compare(options.minZoom, this.minZoom) != 0) {
            return false;
        }
        if (Double.compare(options.maxZoom, this.maxZoom) != 0) {
            return false;
        }
        if (this.rotateGesturesEnabled != options.rotateGesturesEnabled) {
            return false;
        }
        if (this.scrollGesturesEnabled != options.scrollGesturesEnabled) {
            return false;
        }
        if (this.tiltGesturesEnabled != options.tiltGesturesEnabled) {
            return false;
        }
        if (this.zoomGesturesEnabled != options.zoomGesturesEnabled) {
            return false;
        }
        if (this.zoomControlsEnabled != options.zoomControlsEnabled) {
            return false;
        }
        if (this.doubleTapGesturesEnabled != options.doubleTapGesturesEnabled) {
            return false;
        }
        if (this.cameraPosition != null ? !this.cameraPosition.equals(options.cameraPosition) : options.cameraPosition != null) {
            return false;
        }
        if (!Arrays.equals(this.compassMargins, options.compassMargins)) {
            return false;
        }
        if (!Arrays.equals(this.logoMargins, options.logoMargins)) {
            return false;
        }
        if (!Arrays.equals(this.attributionMargins, options.attributionMargins)) {
            return false;
        }
        if (this.styleUrl != null ? !this.styleUrl.equals(options.styleUrl) : options.styleUrl != null) {
            return false;
        }
        if (this.styleJson != null ? !this.styleJson.equals(options.styleJson) : options.styleJson != null) {
            return false;
        }
        if (this.apiBaseUrl != null ? !this.apiBaseUrl.equals(options.apiBaseUrl) : options.apiBaseUrl != null) {
            return false;
        }
        if (this.prefetchesTiles != options.prefetchesTiles) {
            return false;
        }
        if (this.zMediaOverlay != options.zMediaOverlay) {
            return false;
        }
        if (!this.localIdeographFontFamily.equals(options.localIdeographFontFamily)) {
            return false;
        }
        if (this.pixelRatio != options.pixelRatio) {
            return false;
        }
        if (this.crossSourceCollisions != options.crossSourceCollisions) {
            return false;
        }
        return false;
    }

    public int hashCode() {
        int result = this.cameraPosition != null ? this.cameraPosition.hashCode() : 0;
        result = 31 * result + (this.debugActive ? 1 : 0);
        result = 31 * result + (this.compassEnabled ? 1 : 0);
        result = 31 * result + (this.fadeCompassFacingNorth ? 1 : 0);
        result = 31 * result + this.compassGravity;
        result = 31 * result + (this.compassImage != null ? this.compassImage.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.compassMargins);
        result = 31 * result + (this.logoEnabled ? 1 : 0);
        result = 31 * result + this.logoGravity;
        result = 31 * result + Arrays.hashCode(this.logoMargins);
        result = 31 * result + this.attributionTintColor;
        result = 31 * result + (this.attributionEnabled ? 1 : 0);
        result = 31 * result + this.attributionGravity;
        result = 31 * result + Arrays.hashCode(this.attributionMargins);
        long temp = Double.doubleToLongBits(this.minZoom);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxZoom);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.rotateGesturesEnabled ? 1 : 0);
        result = 31 * result + (this.scrollGesturesEnabled ? 1 : 0);
        result = 31 * result + (this.tiltGesturesEnabled ? 1 : 0);
        result = 31 * result + (this.zoomGesturesEnabled ? 1 : 0);
        result = 31 * result + (this.zoomControlsEnabled ? 1 : 0);
        result = 31 * result + (this.doubleTapGesturesEnabled ? 1 : 0);
        result = 31 * result + (this.apiBaseUrl != null ? this.apiBaseUrl.hashCode() : 0);
        result = 31 * result + (this.textureMode ? 1 : 0);
        result = 31 * result + (this.translucentTextureSurface ? 1 : 0);
        result = 31 * result + (this.styleUrl != null ? this.styleUrl.hashCode() : 0);
        result = 31 * result + (this.styleJson != null ? this.styleJson.hashCode() : 0);
        result = 31 * result + (this.prefetchesTiles ? 1 : 0);
        result = 31 * result + (this.zMediaOverlay ? 1 : 0);
        result = 31 * result + (this.localIdeographFontFamily != null ? this.localIdeographFontFamily.hashCode() : 0);
        result = 31 * result + (int)this.pixelRatio;
        result = 31 * result + (this.crossSourceCollisions ? 1 : 0);
        return result;
    }
}

