/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.maps;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import ir.map.sdk_map.annotations.InfoWindow;
import ir.map.sdk_map.annotations.Marker;
import ir.map.sdk_map.maps.MapirMap;
import java.util.ArrayList;
import java.util.List;

class InfoWindowManager {
    private final List<InfoWindow> infoWindows = new ArrayList<InfoWindow>();
    private MapirMap.InfoWindowAdapter infoWindowAdapter;
    private boolean allowConcurrentMultipleInfoWindows;
    private MapirMap.OnInfoWindowClickListener onInfoWindowClickListener;
    private MapirMap.OnInfoWindowLongClickListener onInfoWindowLongClickListener;
    private MapirMap.OnInfoWindowCloseListener onInfoWindowCloseListener;

    InfoWindowManager() {
    }

    void update() {
        if (!this.infoWindows.isEmpty()) {
            for (InfoWindow infoWindow : this.infoWindows) {
                infoWindow.update();
            }
        }
    }

    MapirMap.InfoWindowAdapter getInfoWindowAdapter() {
        return this.infoWindowAdapter;
    }

    void setInfoWindowAdapter(@Nullable MapirMap.InfoWindowAdapter infoWindowAdapter) {
        this.infoWindowAdapter = infoWindowAdapter;
    }

    boolean isAllowConcurrentMultipleOpenInfoWindows() {
        return this.allowConcurrentMultipleInfoWindows;
    }

    void setAllowConcurrentMultipleOpenInfoWindows(boolean allow) {
        this.allowConcurrentMultipleInfoWindows = allow;
    }

    boolean isInfoWindowValidForMarker(Marker marker) {
        return marker != null && (!TextUtils.isEmpty((CharSequence)marker.getTitle()) || !TextUtils.isEmpty((CharSequence)marker.getSnippet()));
    }

    MapirMap.OnInfoWindowClickListener getOnInfoWindowClickListener() {
        return this.onInfoWindowClickListener;
    }

    void setOnInfoWindowClickListener(@Nullable MapirMap.OnInfoWindowClickListener listener) {
        this.onInfoWindowClickListener = listener;
    }

    MapirMap.OnInfoWindowLongClickListener getOnInfoWindowLongClickListener() {
        return this.onInfoWindowLongClickListener;
    }

    void setOnInfoWindowLongClickListener(@Nullable MapirMap.OnInfoWindowLongClickListener listener) {
        this.onInfoWindowLongClickListener = listener;
    }

    MapirMap.OnInfoWindowCloseListener getOnInfoWindowCloseListener() {
        return this.onInfoWindowCloseListener;
    }

    void setOnInfoWindowCloseListener(@Nullable MapirMap.OnInfoWindowCloseListener listener) {
        this.onInfoWindowCloseListener = listener;
    }

    public void add(InfoWindow infoWindow) {
        this.infoWindows.add(infoWindow);
    }
}

