/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.maps;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.Toast;
import ir.map.sdk_map.MapStrictMode;
import ir.map.sdk_map.Mapir;
import ir.map.sdk_map.R;
import ir.map.sdk_map.attribution.Attribution;
import ir.map.sdk_map.attribution.AttributionParser;
import ir.map.sdk_map.camera.CameraPosition;
import ir.map.sdk_map.maps.MapirMap;
import ir.map.sdk_map.maps.TelemetryDefinition;
import ir.map.sdk_map.style.sources.Source;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;

public class AttributionDialogManager
implements View.OnClickListener,
DialogInterface.OnClickListener {
    private static final String MAP_FEEDBACK_URL = "https://www.mapbox.com/map-feedback";
    private static final String MAP_FEEDBACK_LOCATION_FORMAT = "https://www.mapbox.com/map-feedback/#/%f/%f/%d";
    private final Context context;
    private final MapirMap mapirMap;
    private Set<Attribution> attributionSet;

    public AttributionDialogManager(@NonNull Context context, @NonNull MapirMap mapirMap) {
        this.context = context;
        this.mapirMap = mapirMap;
    }

    public void onClick(View view) {
        this.attributionSet = new AttributionBuilder(this.mapirMap, view.getContext()).build();
        boolean isActivityFinishing = false;
        if (this.context instanceof Activity) {
            isActivityFinishing = ((Activity)this.context).isFinishing();
        }
        if (!isActivityFinishing) {
            this.showAttributionDialog(this.getAttributionTitles());
        }
    }

    protected void showAttributionDialog(String[] attributionTitles) {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.context);
        builder.setTitle(R.string.mapir_attributionsDialogTitle);
        builder.setAdapter((ListAdapter)new ArrayAdapter(this.context, R.layout.mapir_attribution_list_item, (Object[])attributionTitles), (DialogInterface.OnClickListener)this);
        builder.show();
    }

    private String[] getAttributionTitles() {
        ArrayList<String> titles = new ArrayList<String>();
        for (Attribution attribution : this.attributionSet) {
            titles.add(attribution.getTitle());
        }
        return titles.toArray(new String[titles.size()]);
    }

    public void onClick(DialogInterface dialog, int which) {
        if (this.isLatestEntry(which)) {
            this.showTelemetryDialog();
        } else {
            this.showMapFeedbackWebPage(which);
        }
    }

    private boolean isLatestEntry(int attributionKeyIndex) {
        return attributionKeyIndex == this.getAttributionTitles().length - 1;
    }

    private void showTelemetryDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.context);
        builder.setTitle(R.string.mapir_attributionTelemetryTitle);
        builder.setMessage(R.string.mapir_attributionTelemetryMessage);
        builder.setPositiveButton(R.string.mapir_attributionTelemetryPositive, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                TelemetryDefinition telemetry = Mapir.getTelemetry();
                if (telemetry != null) {
                    telemetry.setUserTelemetryRequestState(true);
                }
                dialog.cancel();
            }
        });
        builder.setNeutralButton(R.string.mapir_attributionTelemetryNeutral, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                AttributionDialogManager.this.showWebPage(AttributionDialogManager.this.context.getResources().getString(R.string.mapir_telemetryLink));
                dialog.cancel();
            }
        });
        builder.setNegativeButton(R.string.mapir_attributionTelemetryNegative, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                TelemetryDefinition telemetry = Mapir.getTelemetry();
                if (telemetry != null) {
                    telemetry.setUserTelemetryRequestState(false);
                }
                dialog.cancel();
            }
        });
        builder.show();
    }

    private void showMapFeedbackWebPage(int which) {
        Attribution[] attributions = this.attributionSet.toArray(new Attribution[this.attributionSet.size()]);
        String url = attributions[which].getUrl();
        if (url.contains(MAP_FEEDBACK_URL)) {
            url = this.buildMapFeedbackMapUrl(this.mapirMap.getCameraPosition());
        }
        this.showWebPage(url);
    }

    private String buildMapFeedbackMapUrl(CameraPosition cameraPosition) {
        return cameraPosition != null ? String.format(Locale.getDefault(), MAP_FEEDBACK_LOCATION_FORMAT, cameraPosition.target.getLongitude(), cameraPosition.target.getLatitude(), (int)cameraPosition.zoom) : MAP_FEEDBACK_URL;
    }

    private void showWebPage(@NonNull String url) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
            this.context.startActivity(intent);
        }
        catch (ActivityNotFoundException exception) {
            Toast.makeText((Context)this.context, (int)R.string.mapir_attributionErrorNoBrowser, (int)1).show();
            MapStrictMode.strictModeViolation((Exception)((Object)exception));
        }
    }

    private static class AttributionBuilder {
        private final MapirMap mapirMap;
        private final WeakReference<Context> context;

        AttributionBuilder(MapirMap mapirMap, Context context) {
            this.mapirMap = mapirMap;
            this.context = new WeakReference<Context>(context);
        }

        private Set<Attribution> build() {
            Context context = (Context)this.context.get();
            if (context == null) {
                return Collections.emptySet();
            }
            ArrayList<String> attributions = new ArrayList<String>();
            for (Source source : this.mapirMap.getSources()) {
                String attribution = source.getAttribution();
                if (attribution.isEmpty()) continue;
                attributions.add(source.getAttribution());
            }
            return new AttributionParser.Options().withCopyrightSign(true).withImproveMap(true).withContext(context).withTelemetryAttribution(true).withAttributionData(attributions.toArray(new String[attributions.size()])).build().getAttributions();
        }
    }
}

