/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.maps;

import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.LongSparseArray;
import android.view.View;
import ir.map.sdk_map.Mapir;
import ir.map.sdk_map.R;
import ir.map.sdk_map.annotations.Annotation;
import ir.map.sdk_map.annotations.BaseMarkerOptions;
import ir.map.sdk_map.annotations.BaseMarkerViewOptions;
import ir.map.sdk_map.annotations.Marker;
import ir.map.sdk_map.annotations.MarkerView;
import ir.map.sdk_map.annotations.MarkerViewManager;
import ir.map.sdk_map.annotations.Polygon;
import ir.map.sdk_map.annotations.PolygonOptions;
import ir.map.sdk_map.annotations.Polyline;
import ir.map.sdk_map.annotations.PolylineOptions;
import ir.map.sdk_map.log.Logger;
import ir.map.sdk_map.maps.Annotations;
import ir.map.sdk_map.maps.IconManager;
import ir.map.sdk_map.maps.InfoWindowManager;
import ir.map.sdk_map.maps.MapView;
import ir.map.sdk_map.maps.MapirMap;
import ir.map.sdk_map.maps.Markers;
import ir.map.sdk_map.maps.NativeMapView;
import ir.map.sdk_map.maps.Polygons;
import ir.map.sdk_map.maps.Polylines;
import ir.map.sdk_map.maps.Projection;
import ir.map.sdk_map.maps.ShapeAnnotations;
import java.util.ArrayList;
import java.util.List;

class AnnotationManager {
    private static final String TAG = "Mbgl-AnnotationManager";
    private static final long NO_ANNOTATION_ID = -1L;
    private final MapView mapView;
    private final IconManager iconManager;
    private final InfoWindowManager infoWindowManager = new InfoWindowManager();
    private final MarkerViewManager markerViewManager;
    private final LongSparseArray<Annotation> annotationsArray;
    private final List<Marker> selectedMarkers = new ArrayList<Marker>();
    private MapirMap mapirMap;
    private MapirMap.OnMarkerClickListener onMarkerClickListener;
    private MapirMap.OnPolygonClickListener onPolygonClickListener;
    private MapirMap.OnPolylineClickListener onPolylineClickListener;
    private Annotations annotations;
    private ShapeAnnotations shapeAnnotations;
    private Markers markers;
    private Polygons polygons;
    private Polylines polylines;

    AnnotationManager(NativeMapView view, MapView mapView, LongSparseArray<Annotation> annotationsArray, MarkerViewManager markerViewManager, IconManager iconManager, Annotations annotations, Markers markers, Polygons polygons, Polylines polylines, ShapeAnnotations shapeAnnotations) {
        this.mapView = mapView;
        this.annotationsArray = annotationsArray;
        this.markerViewManager = markerViewManager;
        this.iconManager = iconManager;
        this.annotations = annotations;
        this.markers = markers;
        this.polygons = polygons;
        this.polylines = polylines;
        this.shapeAnnotations = shapeAnnotations;
        if (view != null) {
            view.addOnMapChangedListener(markerViewManager);
        }
    }

    AnnotationManager bind(MapirMap mapirMap) {
        this.mapirMap = mapirMap;
        this.markerViewManager.bind(mapirMap);
        return this;
    }

    void update() {
        this.markerViewManager.update();
        this.infoWindowManager.update();
    }

    Annotation getAnnotation(long id2) {
        return this.annotations.obtainBy(id2);
    }

    List<Annotation> getAnnotations() {
        return this.annotations.obtainAll();
    }

    void removeAnnotation(long id2) {
        this.annotations.removeBy(id2);
    }

    void removeAnnotation(@NonNull Annotation annotation) {
        if (annotation instanceof Marker) {
            Marker marker = (Marker)annotation;
            marker.hideInfoWindow();
            if (this.selectedMarkers.contains(marker)) {
                this.selectedMarkers.remove(marker);
            }
            if (marker instanceof MarkerView) {
                this.markerViewManager.removeMarkerView((MarkerView)marker);
            } else {
                this.iconManager.iconCleanup(marker.getIcon());
            }
        }
        this.annotations.removeBy(annotation);
    }

    void removeAnnotations(@NonNull List<? extends Annotation> annotationList) {
        for (Annotation annotation : annotationList) {
            if (!(annotation instanceof Marker)) continue;
            Marker marker = (Marker)annotation;
            marker.hideInfoWindow();
            if (this.selectedMarkers.contains(marker)) {
                this.selectedMarkers.remove(marker);
            }
            if (marker instanceof MarkerView) {
                this.markerViewManager.removeMarkerView((MarkerView)marker);
                continue;
            }
            this.iconManager.iconCleanup(marker.getIcon());
        }
        this.annotations.removeBy(annotationList);
    }

    void removeAnnotations() {
        int count = this.annotationsArray.size();
        long[] ids = new long[count];
        this.selectedMarkers.clear();
        for (int i = 0; i < count; ++i) {
            ids[i] = this.annotationsArray.keyAt(i);
            Annotation annotation = (Annotation)this.annotationsArray.get(ids[i]);
            if (!(annotation instanceof Marker)) continue;
            Marker marker = (Marker)annotation;
            marker.hideInfoWindow();
            if (marker instanceof MarkerView) {
                this.markerViewManager.removeMarkerView((MarkerView)marker);
                continue;
            }
            this.iconManager.iconCleanup(marker.getIcon());
        }
        this.annotations.removeAll();
    }

    Marker addMarker(@NonNull BaseMarkerOptions markerOptions, @NonNull MapirMap mapirMap) {
        return this.markers.addBy(markerOptions, mapirMap);
    }

    List<Marker> addMarkers(@NonNull List<? extends BaseMarkerOptions> markerOptionsList, @NonNull MapirMap mapirMap) {
        return this.markers.addBy(markerOptionsList, mapirMap);
    }

    void updateMarker(@NonNull Marker updatedMarker, @NonNull MapirMap mapirMap) {
        if (!this.isAddedToMap(updatedMarker)) {
            this.logNonAdded(updatedMarker);
            return;
        }
        this.markers.update(updatedMarker, mapirMap);
    }

    List<Marker> getMarkers() {
        return this.markers.obtainAll();
    }

    @NonNull
    List<Marker> getMarkersInRect(@NonNull RectF rectangle) {
        return this.markers.obtainAllIn(rectangle);
    }

    MarkerView addMarker(@NonNull BaseMarkerViewOptions markerOptions, @NonNull MapirMap mapirMap, @Nullable MarkerViewManager.OnMarkerViewAddedListener onMarkerViewAddedListener) {
        return this.markers.addViewBy(markerOptions, mapirMap, onMarkerViewAddedListener);
    }

    List<MarkerView> addMarkerViews(@NonNull List<? extends BaseMarkerViewOptions> markerViewOptions, @NonNull MapirMap mapirMap) {
        return this.markers.addViewsBy(markerViewOptions, mapirMap);
    }

    List<MarkerView> getMarkerViewsInRect(@NonNull RectF rectangle) {
        return this.markers.obtainViewsIn(rectangle);
    }

    void reloadMarkers() {
        this.markers.reload();
    }

    Polygon addPolygon(@NonNull PolygonOptions polygonOptions, @NonNull MapirMap mapirMap) {
        return this.polygons.addBy(polygonOptions, mapirMap);
    }

    List<Polygon> addPolygons(@NonNull List<PolygonOptions> polygonOptionsList, @NonNull MapirMap mapirMap) {
        return this.polygons.addBy(polygonOptionsList, mapirMap);
    }

    void updatePolygon(Polygon polygon) {
        if (!this.isAddedToMap(polygon)) {
            this.logNonAdded(polygon);
            return;
        }
        this.polygons.update(polygon);
    }

    List<Polygon> getPolygons() {
        return this.polygons.obtainAll();
    }

    Polyline addPolyline(@NonNull PolylineOptions polylineOptions, @NonNull MapirMap mapirMap) {
        return this.polylines.addBy(polylineOptions, mapirMap);
    }

    List<Polyline> addPolylines(@NonNull List<PolylineOptions> polylineOptionsList, @NonNull MapirMap mapirMap) {
        return this.polylines.addBy(polylineOptionsList, mapirMap);
    }

    void updatePolyline(Polyline polyline) {
        if (!this.isAddedToMap(polyline)) {
            this.logNonAdded(polyline);
            return;
        }
        this.polylines.update(polyline);
    }

    List<Polyline> getPolylines() {
        return this.polylines.obtainAll();
    }

    void setOnMarkerClickListener(@Nullable MapirMap.OnMarkerClickListener listener) {
        this.onMarkerClickListener = listener;
    }

    void setOnPolygonClickListener(@Nullable MapirMap.OnPolygonClickListener listener) {
        this.onPolygonClickListener = listener;
    }

    void setOnPolylineClickListener(@Nullable MapirMap.OnPolylineClickListener listener) {
        this.onPolylineClickListener = listener;
    }

    void selectMarker(@NonNull Marker marker) {
        if (this.selectedMarkers.contains(marker)) {
            return;
        }
        if (!this.infoWindowManager.isAllowConcurrentMultipleOpenInfoWindows()) {
            this.deselectMarkers();
        }
        if (marker instanceof MarkerView) {
            this.markerViewManager.select((MarkerView)marker, false);
            this.markerViewManager.ensureInfoWindowOffset((MarkerView)marker);
        }
        if (this.infoWindowManager.isInfoWindowValidForMarker(marker) || this.infoWindowManager.getInfoWindowAdapter() != null) {
            this.infoWindowManager.add(marker.showInfoWindow(this.mapirMap, this.mapView));
        }
        this.selectedMarkers.add(marker);
    }

    void deselectMarkers() {
        if (this.selectedMarkers.isEmpty()) {
            return;
        }
        for (Marker marker : this.selectedMarkers) {
            if (marker == null) continue;
            if (marker.isInfoWindowShown()) {
                marker.hideInfoWindow();
            }
            if (!(marker instanceof MarkerView)) continue;
            this.markerViewManager.deselect((MarkerView)marker, false);
        }
        this.selectedMarkers.clear();
    }

    void deselectMarker(@NonNull Marker marker) {
        if (!this.selectedMarkers.contains(marker)) {
            return;
        }
        if (marker.isInfoWindowShown()) {
            marker.hideInfoWindow();
        }
        if (marker instanceof MarkerView) {
            this.markerViewManager.deselect((MarkerView)marker, false);
        }
        this.selectedMarkers.remove(marker);
    }

    List<Marker> getSelectedMarkers() {
        return this.selectedMarkers;
    }

    InfoWindowManager getInfoWindowManager() {
        return this.infoWindowManager;
    }

    MarkerViewManager getMarkerViewManager() {
        return this.markerViewManager;
    }

    void adjustTopOffsetPixels(MapirMap mapirMap) {
        int count = this.annotationsArray.size();
        for (int i = 0; i < count; ++i) {
            Annotation annotation = (Annotation)this.annotationsArray.get((long)i);
            if (!(annotation instanceof Marker)) continue;
            Marker marker = (Marker)annotation;
            marker.setTopOffsetPixels(this.iconManager.getTopOffsetPixelsForIcon(marker.getIcon()));
        }
        for (Marker marker : this.selectedMarkers) {
            if (!marker.isInfoWindowShown()) continue;
            marker.hideInfoWindow();
            marker.showInfoWindow(mapirMap, this.mapView);
        }
    }

    private boolean isAddedToMap(Annotation annotation) {
        return annotation != null && annotation.getId() != -1L && this.annotationsArray.indexOfKey(annotation.getId()) > -1;
    }

    private void logNonAdded(Annotation annotation) {
        Logger.w(TAG, String.format("Attempting to update non-added %s with value %s", annotation.getClass().getCanonicalName(), annotation));
    }

    boolean onTap(PointF tapPoint) {
        MarkerHit markerHit = this.getMarkerHitFromTouchArea(tapPoint);
        long markerId = new MarkerHitResolver(this.mapirMap).execute(markerHit);
        if (markerId != -1L && this.isClickHandledForMarker(markerId)) {
            return true;
        }
        ShapeAnnotationHit shapeAnnotationHit = this.getShapeAnnotationHitFromTap(tapPoint);
        Annotation annotation = new ShapeAnnotationHitResolver(this.shapeAnnotations).execute(shapeAnnotationHit);
        return annotation != null && this.handleClickForShapeAnnotation(annotation);
    }

    private ShapeAnnotationHit getShapeAnnotationHitFromTap(PointF tapPoint) {
        float touchTargetSide = Mapir.getApplicationContext().getResources().getDimension(R.dimen.mapir_eight_dp);
        RectF tapRect = new RectF(tapPoint.x - touchTargetSide, tapPoint.y - touchTargetSide, tapPoint.x + touchTargetSide, tapPoint.y + touchTargetSide);
        return new ShapeAnnotationHit(tapRect);
    }

    private boolean handleClickForShapeAnnotation(Annotation annotation) {
        if (annotation instanceof Polygon && this.onPolygonClickListener != null) {
            this.onPolygonClickListener.onPolygonClick((Polygon)annotation);
            return true;
        }
        if (annotation instanceof Polyline && this.onPolylineClickListener != null) {
            this.onPolylineClickListener.onPolylineClick((Polyline)annotation);
            return true;
        }
        return false;
    }

    private MarkerHit getMarkerHitFromTouchArea(PointF tapPoint) {
        int touchSurfaceWidth = (int)((double)this.iconManager.getHighestIconHeight() * 1.5);
        int touchSurfaceHeight = (int)((double)this.iconManager.getHighestIconWidth() * 1.5);
        RectF tapRect = new RectF(tapPoint.x - (float)touchSurfaceWidth, tapPoint.y - (float)touchSurfaceHeight, tapPoint.x + (float)touchSurfaceWidth, tapPoint.y + (float)touchSurfaceHeight);
        return new MarkerHit(tapRect, this.getMarkersInRect(tapRect));
    }

    private boolean isClickHandledForMarker(long markerId) {
        Marker marker = (Marker)this.getAnnotation(markerId);
        boolean handledDefaultClick = marker instanceof MarkerView ? this.markerViewManager.onClickMarkerView((MarkerView)marker) : this.onClickMarker(marker);
        if (!handledDefaultClick) {
            this.toggleMarkerSelectionState(marker);
        }
        return true;
    }

    private boolean onClickMarker(Marker marker) {
        return this.onMarkerClickListener != null && this.onMarkerClickListener.onMarkerClick(marker);
    }

    private void toggleMarkerSelectionState(Marker marker) {
        if (!this.selectedMarkers.contains(marker)) {
            this.selectMarker(marker);
        } else {
            this.deselectMarker(marker);
        }
    }

    private static class MarkerHit {
        private final RectF tapRect;
        private final List<Marker> markers;

        MarkerHit(RectF tapRect, List<Marker> markers) {
            this.tapRect = tapRect;
            this.markers = markers;
        }

        float getTapPointX() {
            return this.tapRect.centerX();
        }

        float getTapPointY() {
            return this.tapRect.centerY();
        }
    }

    private static class ShapeAnnotationHit {
        private final RectF tapPoint;

        ShapeAnnotationHit(RectF tapPoint) {
            this.tapPoint = tapPoint;
        }
    }

    private static class MarkerHitResolver {
        private final MarkerViewManager markerViewManager;
        private final Projection projection;
        private final int minimalTouchSize;
        private View view;
        private Bitmap bitmap;
        private int bitmapWidth;
        private int bitmapHeight;
        private PointF markerLocation;
        private Rect hitRectView = new Rect();
        private RectF hitRectMarker = new RectF();
        private RectF highestSurfaceIntersection = new RectF();
        private long closestMarkerId = -1L;

        MarkerHitResolver(@NonNull MapirMap mapirMap) {
            this.markerViewManager = mapirMap.getMarkerViewManager();
            this.projection = mapirMap.getProjection();
            this.minimalTouchSize = (int)(32.0f * Mapir.getApplicationContext().getResources().getDisplayMetrics().density);
        }

        public long execute(MarkerHit markerHit) {
            this.resolveForMarkers(markerHit);
            return this.closestMarkerId;
        }

        private void resolveForMarkers(MarkerHit markerHit) {
            for (Marker marker : markerHit.markers) {
                if (marker instanceof MarkerView) {
                    this.resolveForMarkerView(markerHit, (MarkerView)marker);
                    continue;
                }
                this.resolveForMarker(markerHit, marker);
            }
        }

        private void resolveForMarkerView(MarkerHit markerHit, MarkerView markerView) {
            this.view = this.markerViewManager.getView(markerView);
            if (this.view != null) {
                this.view.getHitRect(this.hitRectView);
                this.hitRectMarker = new RectF(this.hitRectView);
                this.hitTestMarker(markerHit, markerView, this.hitRectMarker);
            }
        }

        private void resolveForMarker(MarkerHit markerHit, Marker marker) {
            this.markerLocation = this.projection.toScreenLocation(marker.getPosition());
            this.bitmap = marker.getIcon().getBitmap();
            this.bitmapHeight = this.bitmap.getHeight();
            if (this.bitmapHeight < this.minimalTouchSize) {
                this.bitmapHeight = this.minimalTouchSize;
            }
            this.bitmapWidth = this.bitmap.getWidth();
            if (this.bitmapWidth < this.minimalTouchSize) {
                this.bitmapWidth = this.minimalTouchSize;
            }
            this.hitRectMarker.set(0.0f, 0.0f, (float)this.bitmapWidth, (float)this.bitmapHeight);
            this.hitRectMarker.offsetTo(this.markerLocation.x - (float)(this.bitmapWidth / 2), this.markerLocation.y - (float)(this.bitmapHeight / 2));
            this.hitTestMarker(markerHit, marker, this.hitRectMarker);
        }

        private void hitTestMarker(MarkerHit markerHit, Marker marker, RectF hitRectMarker) {
            if (hitRectMarker.contains(markerHit.getTapPointX(), markerHit.getTapPointY())) {
                hitRectMarker.intersect(markerHit.tapRect);
                if (this.isRectangleHighestSurfaceIntersection(hitRectMarker)) {
                    this.highestSurfaceIntersection = new RectF(hitRectMarker);
                    this.closestMarkerId = marker.getId();
                }
            }
        }

        private boolean isRectangleHighestSurfaceIntersection(RectF rectF) {
            return rectF.width() * rectF.height() > this.highestSurfaceIntersection.width() * this.highestSurfaceIntersection.height();
        }
    }

    private static class ShapeAnnotationHitResolver {
        private ShapeAnnotations shapeAnnotations;

        ShapeAnnotationHitResolver(ShapeAnnotations shapeAnnotations) {
            this.shapeAnnotations = shapeAnnotations;
        }

        public Annotation execute(ShapeAnnotationHit shapeHit) {
            Annotation foundAnnotation = null;
            List<Annotation> annotations = this.shapeAnnotations.obtainAllIn(shapeHit.tapPoint);
            if (annotations.size() > 0) {
                foundAnnotation = annotations.get(0);
            }
            return foundAnnotation;
        }
    }
}

