/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.maps;

import android.support.annotation.NonNull;
import android.support.v4.util.LongSparseArray;
import ir.map.sdk_map.annotations.Annotation;
import ir.map.sdk_map.maps.Annotations;
import ir.map.sdk_map.maps.NativeMapView;
import java.util.ArrayList;
import java.util.List;

class AnnotationContainer
implements Annotations {
    private final NativeMapView nativeMapView;
    private final LongSparseArray<Annotation> annotations;

    AnnotationContainer(NativeMapView nativeMapView, LongSparseArray<Annotation> annotations) {
        this.nativeMapView = nativeMapView;
        this.annotations = annotations;
    }

    @Override
    public Annotation obtainBy(long id2) {
        return (Annotation)this.annotations.get(id2);
    }

    @Override
    public List<Annotation> obtainAll() {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            annotations.add((Annotation)this.annotations.get(this.annotations.keyAt(i)));
        }
        return annotations;
    }

    @Override
    public void removeBy(long id2) {
        if (this.nativeMapView != null) {
            this.nativeMapView.removeAnnotation(id2);
        }
        this.annotations.remove(id2);
    }

    @Override
    public void removeBy(@NonNull Annotation annotation) {
        long id2 = annotation.getId();
        this.removeBy(id2);
    }

    @Override
    public void removeBy(@NonNull List<? extends Annotation> annotationList) {
        int count = annotationList.size();
        long[] ids = new long[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = annotationList.get(i).getId();
        }
        this.removeNativeAnnotations(ids);
        for (long id2 : ids) {
            this.annotations.remove(id2);
        }
    }

    @Override
    public void removeAll() {
        int count = this.annotations.size();
        long[] ids = new long[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = this.annotations.keyAt(i);
        }
        this.removeNativeAnnotations(ids);
        this.annotations.clear();
    }

    private void removeNativeAnnotations(long[] ids) {
        if (this.nativeMapView != null) {
            this.nativeMapView.removeAnnotations(ids);
        }
    }
}

