/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.location;

import android.graphics.Bitmap;
import android.graphics.PointF;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.Point;
import ir.map.sdk_map.geometry.LatLng;
import ir.map.sdk_map.location.LayerBitmapProvider;
import ir.map.sdk_map.location.LayerFeatureProvider;
import ir.map.sdk_map.location.LayerSourceProvider;
import ir.map.sdk_map.location.LocationComponentOptions;
import ir.map.sdk_map.location.MapirAnimator;
import ir.map.sdk_map.maps.MapirMap;
import ir.map.sdk_map.style.expressions.Expression;
import ir.map.sdk_map.style.layers.Layer;
import ir.map.sdk_map.style.layers.PropertyFactory;
import ir.map.sdk_map.style.layers.SymbolLayer;
import ir.map.sdk_map.style.sources.GeoJsonSource;
import java.util.ArrayList;
import java.util.List;

final class LocationLayerController
implements MapirAnimator.OnLayerAnimationsValuesChangeListener {
    private final MapirMap mapirMap;
    private final LayerSourceProvider layerSourceProvider;
    private final LayerBitmapProvider bitmapProvider;
    private final List<String> layerMap = new ArrayList<String>();
    private int renderMode;
    private LocationComponentOptions options;
    private Feature locationFeature;
    private GeoJsonSource locationSource;
    private boolean isHidden = true;

    LocationLayerController(MapirMap mapirMap, LayerSourceProvider layerSourceProvider, LayerFeatureProvider featureProvider, LayerBitmapProvider bitmapProvider, LocationComponentOptions options) {
        this.mapirMap = mapirMap;
        this.layerSourceProvider = layerSourceProvider;
        this.bitmapProvider = bitmapProvider;
        this.locationFeature = featureProvider.generateLocationFeature(this.locationFeature, options);
        this.initializeComponents(options);
        this.setRenderMode(18);
    }

    void initializeComponents(LocationComponentOptions options) {
        this.addLocationSource();
        this.addLayers(options.layerBelow());
        this.applyStyle(options);
        if (this.isHidden) {
            this.hide();
        } else {
            this.show();
        }
    }

    void applyStyle(@NonNull LocationComponentOptions options) {
        this.options = options;
        float elevation = options.elevation();
        if (elevation > 0.0f) {
            this.styleShadow(options);
        }
        this.styleForeground(options);
        this.styleBackground(options);
        this.styleBearing(options);
        this.styleAccuracy(options.accuracyAlpha(), options.accuracyColor());
        this.styleScaling(options);
        this.determineIconsSource(options);
    }

    int getRenderMode() {
        return this.renderMode;
    }

    void setRenderMode(int renderMode) {
        this.renderMode = renderMode;
        if (!this.isHidden) {
            boolean isStale = this.locationFeature.getBooleanProperty("mapbox-property-location-stale");
            switch (renderMode) {
                case 18: {
                    this.styleForeground(this.options);
                    this.setLayerVisibility("mapbox-location-shadow", true);
                    this.setLayerVisibility("mapbox-location-layer", true);
                    this.setLayerVisibility("mapbox-location-stroke-layer", true);
                    this.setLayerVisibility("mapbox-location-accuracy-layer", !isStale);
                    this.setLayerVisibility("mapbox-location-bearing-layer", false);
                    break;
                }
                case 4: {
                    this.styleForeground(this.options);
                    this.setLayerVisibility("mapbox-location-shadow", true);
                    this.setLayerVisibility("mapbox-location-layer", true);
                    this.setLayerVisibility("mapbox-location-stroke-layer", true);
                    this.setLayerVisibility("mapbox-location-accuracy-layer", !isStale);
                    this.setLayerVisibility("mapbox-location-bearing-layer", true);
                    break;
                }
                case 8: {
                    this.styleForeground(this.options);
                    this.setLayerVisibility("mapbox-location-shadow", false);
                    this.setLayerVisibility("mapbox-location-layer", true);
                    this.setLayerVisibility("mapbox-location-stroke-layer", true);
                    this.setLayerVisibility("mapbox-location-accuracy-layer", false);
                    this.setLayerVisibility("mapbox-location-bearing-layer", false);
                    break;
                }
            }
            this.determineIconsSource(this.options);
        }
    }

    void show() {
        this.isHidden = false;
        this.setRenderMode(this.renderMode);
    }

    void hide() {
        this.isHidden = true;
        for (String layerId : this.layerMap) {
            this.setLayerVisibility(layerId, false);
        }
    }

    void updateForegroundOffset(double tilt) {
        JsonArray foregroundJsonArray = new JsonArray();
        foregroundJsonArray.add((Number)Float.valueOf(0.0f));
        foregroundJsonArray.add((Number)Float.valueOf((float)(-0.05 * tilt)));
        this.locationFeature.addProperty("mapbox-property-foreground-icon-offset", (JsonElement)foregroundJsonArray);
        JsonArray backgroundJsonArray = new JsonArray();
        backgroundJsonArray.add((Number)Float.valueOf(0.0f));
        backgroundJsonArray.add((Number)Float.valueOf((float)(0.05 * tilt)));
        this.locationFeature.addProperty("mapbox-property-shadow-icon-offset", (JsonElement)backgroundJsonArray);
        this.refreshSource();
    }

    void updateForegroundBearing(float bearing) {
        if (this.renderMode != 8) {
            this.setBearingProperty("mapbox-property-gps-bearing", bearing);
        }
    }

    boolean isHidden() {
        return this.isHidden;
    }

    boolean isConsumingCompass() {
        return this.renderMode == 4;
    }

    private void setLayerVisibility(String layerId, boolean visible) {
        Layer layer = this.mapirMap.getLayer(layerId);
        if (layer != null) {
            String targetVisibility;
            String string2 = targetVisibility = visible ? "visible" : "none";
            if (!((String)layer.getVisibility().value).equals(targetVisibility)) {
                layer.setProperties(PropertyFactory.visibility(visible ? "visible" : "none"));
            }
        }
    }

    private void addLayers(String idBelowLayer) {
        this.addSymbolLayer("mapbox-location-bearing-layer", idBelowLayer);
        this.addSymbolLayer("mapbox-location-layer", "mapbox-location-bearing-layer");
        this.addSymbolLayer("mapbox-location-stroke-layer", "mapbox-location-layer");
        this.addSymbolLayer("mapbox-location-shadow", "mapbox-location-stroke-layer");
        this.addAccuracyLayer();
    }

    private void addSymbolLayer(String layerId, String beforeLayerId) {
        Layer layer = this.layerSourceProvider.generateLayer(layerId);
        this.addLayerToMap(layer, beforeLayerId);
    }

    private void addAccuracyLayer() {
        Layer accuracyLayer = this.layerSourceProvider.generateAccuracyLayer();
        this.addLayerToMap(accuracyLayer, "mapbox-location-stroke-layer");
    }

    private void addLayerToMap(Layer layer, @NonNull String idBelowLayer) {
        this.mapirMap.addLayerBelow(layer, idBelowLayer);
        this.layerMap.add(layer.getId());
    }

    private void setBearingProperty(String propertyId, float bearing) {
        this.locationFeature.addNumberProperty(propertyId, (Number)Float.valueOf(bearing));
        this.refreshSource();
    }

    private void updateAccuracyRadius(float accuracy) {
        if (this.renderMode == 4 || this.renderMode == 18) {
            this.locationFeature.addNumberProperty("mapbox-property-accuracy-radius", (Number)Float.valueOf(accuracy));
            this.refreshSource();
        }
    }

    private void addLocationSource() {
        this.locationSource = this.layerSourceProvider.generateSource(this.locationFeature);
        this.mapirMap.addSource(this.locationSource);
    }

    private void refreshSource() {
        GeoJsonSource source = (GeoJsonSource)this.mapirMap.getSourceAs("mapbox-location-source");
        if (source != null) {
            this.locationSource.setGeoJson(this.locationFeature);
        }
    }

    private void setLocationPoint(Point locationPoint) {
        JsonObject properties = this.locationFeature.properties();
        if (properties != null) {
            this.locationFeature = Feature.fromGeometry((Geometry)locationPoint, (JsonObject)properties);
            this.refreshSource();
        }
    }

    private void styleBackground(LocationComponentOptions options) {
        Bitmap backgroundBitmap = this.bitmapProvider.generateBitmap(options.backgroundDrawable(), options.backgroundTintColor());
        Bitmap backgroundStaleBitmap = this.bitmapProvider.generateBitmap(options.backgroundDrawableStale(), options.backgroundStaleTintColor());
        this.mapirMap.addImage("mapbox-location-stroke-icon", backgroundBitmap);
        this.mapirMap.addImage("mapbox-location-background-stale-icon", backgroundStaleBitmap);
    }

    private void styleShadow(LocationComponentOptions options) {
        this.mapirMap.addImage("mapbox-location-shadow-icon", this.bitmapProvider.generateShadowBitmap(options));
    }

    private void styleBearing(LocationComponentOptions options) {
        Bitmap bearingBitmap = this.bitmapProvider.generateBitmap(options.bearingDrawable(), options.bearingTintColor());
        this.mapirMap.addImage("mapbox-location-bearing-icon", bearingBitmap);
    }

    private void styleAccuracy(float accuracyAlpha, @ColorInt int accuracyColor) {
        this.locationFeature.addNumberProperty("mapbox-property-accuracy-alpha", (Number)Float.valueOf(accuracyAlpha));
        this.locationFeature.addStringProperty("mapbox-property-accuracy-color", PropertyFactory.colorToRgbaString(accuracyColor));
        this.refreshSource();
    }

    private void styleForeground(LocationComponentOptions options) {
        Bitmap foregroundBitmap = this.bitmapProvider.generateBitmap(options.foregroundDrawable(), options.foregroundTintColor());
        Bitmap foregroundBitmapStale = this.bitmapProvider.generateBitmap(options.foregroundDrawableStale(), options.foregroundStaleTintColor());
        if (this.renderMode == 8) {
            foregroundBitmap = this.bitmapProvider.generateBitmap(options.gpsDrawable(), options.foregroundTintColor());
            foregroundBitmapStale = this.bitmapProvider.generateBitmap(options.gpsDrawable(), options.foregroundStaleTintColor());
        }
        this.mapirMap.addImage("mapbox-location-icon", foregroundBitmap);
        this.mapirMap.addImage("mapbox-location-stale-icon", foregroundBitmapStale);
    }

    private void styleScaling(LocationComponentOptions options) {
        for (String layerId : this.layerMap) {
            Layer layer = this.mapirMap.getLayer(layerId);
            if (layer == null || !(layer instanceof SymbolLayer)) continue;
            layer.setProperties(PropertyFactory.iconSize(Expression.interpolate(Expression.linear(), Expression.zoom(), Expression.stop(options.minZoom(), Float.valueOf(options.minZoomIconScale())), Expression.stop(options.maxZoom(), Float.valueOf(options.maxZoomIconScale())))));
        }
    }

    private void determineIconsSource(LocationComponentOptions options) {
        String foregroundIconString = this.buildIconString(this.renderMode == 8 ? options.gpsName() : options.foregroundName(), "mapbox-location-icon");
        String foregroundStaleIconString = this.buildIconString(options.foregroundStaleName(), "mapbox-location-stale-icon");
        String backgroundIconString = this.buildIconString(options.backgroundName(), "mapbox-location-stroke-icon");
        String backgroundStaleIconString = this.buildIconString(options.backgroundStaleName(), "mapbox-location-background-stale-icon");
        String bearingIconString = this.buildIconString(options.bearingName(), "mapbox-location-bearing-icon");
        this.locationFeature.addStringProperty("mapbox-property-foreground-icon", foregroundIconString);
        this.locationFeature.addStringProperty("mapbox-property-background-icon", backgroundIconString);
        this.locationFeature.addStringProperty("mapbox-property-foreground-stale-icon", foregroundStaleIconString);
        this.locationFeature.addStringProperty("mapbox-property-background-stale-icon", backgroundStaleIconString);
        this.locationFeature.addStringProperty("mapbox-property-shadow-icon", bearingIconString);
        this.refreshSource();
    }

    private String buildIconString(@Nullable String bitmapName, @NonNull String drawableName) {
        if (bitmapName != null) {
            return bitmapName;
        }
        return drawableName;
    }

    void setLocationsStale(boolean isStale) {
        this.locationFeature.addBooleanProperty("mapbox-property-location-stale", Boolean.valueOf(isStale));
        this.refreshSource();
        if (this.renderMode != 8) {
            this.setLayerVisibility("mapbox-location-accuracy-layer", !isStale);
        }
    }

    boolean onMapClick(LatLng point) {
        PointF screenLoc = this.mapirMap.getProjection().toScreenLocation(point);
        List<Feature> features = this.mapirMap.queryRenderedFeatures(screenLoc, "mapbox-location-stroke-layer", "mapbox-location-layer", "mapbox-location-bearing-layer");
        return !features.isEmpty();
    }

    @Override
    public void onNewLatLngValue(LatLng latLng) {
        Point point = Point.fromLngLat((double)latLng.getLongitude(), (double)latLng.getLatitude());
        this.setLocationPoint(point);
    }

    @Override
    public void onNewGpsBearingValue(float gpsBearing) {
        if (this.renderMode == 8) {
            this.setBearingProperty("mapbox-property-gps-bearing", gpsBearing);
        }
    }

    @Override
    public void onNewCompassBearingValue(float compassBearing) {
        if (this.renderMode == 4) {
            this.setBearingProperty("mapbox-property-compass-bearing", compassBearing);
        }
    }

    @Override
    public void onNewAccuracyRadiusValue(float accuracyRadiusValue) {
        this.updateAccuracyRadius(accuracyRadiusValue);
    }
}

