/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.location;

import android.content.Context;
import android.graphics.PointF;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.view.MotionEvent;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.MoveGestureDetector;
import com.mapbox.android.gestures.RotateGestureDetector;
import ir.map.sdk_map.camera.CameraUpdateFactory;
import ir.map.sdk_map.geometry.LatLng;
import ir.map.sdk_map.location.LocationComponentOptions;
import ir.map.sdk_map.location.MapirAnimator;
import ir.map.sdk_map.location.OnCameraMoveInvalidateListener;
import ir.map.sdk_map.location.OnCameraTrackingChangedListener;
import ir.map.sdk_map.maps.MapirMap;

final class LocationCameraController
implements MapirAnimator.OnCameraAnimationsValuesChangeListener {
    private final MapirMap mapirMap;
    private final OnCameraTrackingChangedListener internalCameraTrackingChangedListener;
    private final MoveGestureDetector moveGestureDetector;
    private final OnCameraMoveInvalidateListener onCameraMoveInvalidateListener;
    private final AndroidGesturesManager initialGesturesManager;
    private final AndroidGesturesManager internalGesturesManager;
    private int cameraMode;
    private LocationComponentOptions options;
    private boolean adjustFocalPoint;
    @VisibleForTesting
    MapirMap.OnMoveListener onMoveListener = new MapirMap.OnMoveListener(){
        private boolean interrupt;

        @Override
        public void onMoveBegin(@NonNull MoveGestureDetector detector) {
            if (LocationCameraController.this.options.trackingGesturesManagement() && detector.getPointersCount() > 1 && detector.getMoveThreshold() != LocationCameraController.this.options.trackingMultiFingerMoveThreshold() && LocationCameraController.this.isLocationTracking()) {
                detector.setMoveThreshold(LocationCameraController.this.options.trackingMultiFingerMoveThreshold());
                this.interrupt = true;
            } else {
                LocationCameraController.this.setCameraMode(8);
            }
        }

        @Override
        public void onMove(@NonNull MoveGestureDetector detector) {
            if (this.interrupt) {
                detector.interrupt();
                return;
            }
            if (LocationCameraController.this.isLocationTracking() || LocationCameraController.this.isBearingTracking()) {
                LocationCameraController.this.setCameraMode(8);
                detector.interrupt();
            }
        }

        @Override
        public void onMoveEnd(@NonNull MoveGestureDetector detector) {
            if (LocationCameraController.this.options.trackingGesturesManagement() && !this.interrupt && LocationCameraController.this.isLocationTracking()) {
                detector.setMoveThreshold(LocationCameraController.this.options.trackingInitialMoveThreshold());
            }
            this.interrupt = false;
        }
    };
    private MapirMap.OnRotateListener onRotateListener = new MapirMap.OnRotateListener(){

        @Override
        public void onRotateBegin(@NonNull RotateGestureDetector detector) {
            if (LocationCameraController.this.isBearingTracking()) {
                LocationCameraController.this.setCameraMode(8);
            }
        }

        @Override
        public void onRotate(@NonNull RotateGestureDetector detector) {
        }

        @Override
        public void onRotateEnd(@NonNull RotateGestureDetector detector) {
        }
    };
    private MapirMap.OnFlingListener onFlingListener = new MapirMap.OnFlingListener(){

        @Override
        public void onFling() {
            LocationCameraController.this.setCameraMode(8);
        }
    };

    LocationCameraController(Context context, MapirMap mapirMap, OnCameraTrackingChangedListener internalCameraTrackingChangedListener, LocationComponentOptions options, OnCameraMoveInvalidateListener onCameraMoveInvalidateListener) {
        this.mapirMap = mapirMap;
        this.initialGesturesManager = mapirMap.getGesturesManager();
        this.internalGesturesManager = new LocationGesturesManager(context);
        this.moveGestureDetector = this.internalGesturesManager.getMoveGestureDetector();
        mapirMap.addOnRotateListener(this.onRotateListener);
        mapirMap.addOnFlingListener(this.onFlingListener);
        mapirMap.addOnMoveListener(this.onMoveListener);
        this.internalCameraTrackingChangedListener = internalCameraTrackingChangedListener;
        this.onCameraMoveInvalidateListener = onCameraMoveInvalidateListener;
        this.initializeOptions(options);
    }

    LocationCameraController(MapirMap mapirMap, MoveGestureDetector moveGestureDetector, OnCameraTrackingChangedListener internalCameraTrackingChangedListener, OnCameraMoveInvalidateListener onCameraMoveInvalidateListener, AndroidGesturesManager initialGesturesManager, AndroidGesturesManager internalGesturesManager) {
        this.mapirMap = mapirMap;
        this.moveGestureDetector = moveGestureDetector;
        this.internalCameraTrackingChangedListener = internalCameraTrackingChangedListener;
        this.onCameraMoveInvalidateListener = onCameraMoveInvalidateListener;
        this.internalGesturesManager = internalGesturesManager;
        this.initialGesturesManager = initialGesturesManager;
    }

    void initializeOptions(LocationComponentOptions options) {
        this.options = options;
        if (options.trackingGesturesManagement()) {
            this.mapirMap.setGesturesManager(this.internalGesturesManager, true, true);
            this.adjustGesturesThresholds();
        } else {
            this.mapirMap.setGesturesManager(this.initialGesturesManager, true, true);
        }
    }

    int getCameraMode() {
        return this.cameraMode;
    }

    void setCameraMode(int cameraMode) {
        boolean wasTracking = this.isLocationTracking();
        this.cameraMode = cameraMode;
        this.mapirMap.cancelTransitions();
        this.adjustGesturesThresholds();
        this.notifyCameraTrackingChangeListener(wasTracking);
    }

    private void setBearing(float bearing) {
        this.mapirMap.moveCamera(CameraUpdateFactory.bearingTo(bearing));
        this.onCameraMoveInvalidateListener.onInvalidateCameraMove();
    }

    private void setLatLng(LatLng latLng) {
        this.mapirMap.moveCamera(CameraUpdateFactory.newLatLng(latLng));
        this.onCameraMoveInvalidateListener.onInvalidateCameraMove();
    }

    private void setZoom(float zoom) {
        this.mapirMap.moveCamera(CameraUpdateFactory.zoomTo(zoom));
        this.onCameraMoveInvalidateListener.onInvalidateCameraMove();
    }

    private void setTilt(float tilt) {
        this.mapirMap.moveCamera(CameraUpdateFactory.tiltTo(tilt));
        this.onCameraMoveInvalidateListener.onInvalidateCameraMove();
    }

    @Override
    public void onNewLatLngValue(LatLng latLng) {
        if (this.cameraMode == 24 || this.cameraMode == 32 || this.cameraMode == 34 || this.cameraMode == 36) {
            this.setLatLng(latLng);
            if (this.adjustFocalPoint) {
                PointF focalPoint = this.mapirMap.getProjection().toScreenLocation(latLng);
                this.mapirMap.getUiSettings().setFocalPoint(focalPoint);
                this.adjustFocalPoint = false;
            }
        }
    }

    @Override
    public void onNewGpsBearingValue(float gpsBearing) {
        boolean trackingNorth;
        boolean bl = trackingNorth = this.cameraMode == 36 && this.mapirMap.getCameraPosition().bearing != 0.0;
        if (this.cameraMode == 34 || this.cameraMode == 22 || trackingNorth) {
            this.setBearing(gpsBearing);
        }
    }

    @Override
    public void onNewCompassBearingValue(float compassBearing) {
        if (this.cameraMode == 32 || this.cameraMode == 16) {
            this.setBearing(compassBearing);
        }
    }

    @Override
    public void onNewZoomValue(float zoom) {
        this.setZoom(zoom);
    }

    @Override
    public void onNewTiltValue(float tilt) {
        this.setTilt(tilt);
    }

    private void adjustGesturesThresholds() {
        if (this.options.trackingGesturesManagement()) {
            if (this.isLocationTracking()) {
                this.adjustFocalPoint = true;
                this.moveGestureDetector.setMoveThreshold(this.options.trackingInitialMoveThreshold());
            } else {
                this.moveGestureDetector.setMoveThreshold(0.0f);
            }
        }
    }

    boolean isConsumingCompass() {
        return this.cameraMode == 32 || this.cameraMode == 16;
    }

    private boolean isLocationTracking() {
        return this.cameraMode == 24 || this.cameraMode == 32 || this.cameraMode == 34 || this.cameraMode == 36;
    }

    private boolean isBearingTracking() {
        return this.cameraMode == 16 || this.cameraMode == 32 || this.cameraMode == 22 || this.cameraMode == 34 || this.cameraMode == 36;
    }

    private void notifyCameraTrackingChangeListener(boolean wasTracking) {
        this.internalCameraTrackingChangedListener.onCameraTrackingChanged(this.cameraMode);
        if (wasTracking && !this.isLocationTracking()) {
            this.mapirMap.getUiSettings().setFocalPoint(null);
            this.internalCameraTrackingChangedListener.onCameraTrackingDismissed();
        }
    }

    private class LocationGesturesManager
    extends AndroidGesturesManager {
        LocationGesturesManager(Context context) {
            super(context);
        }

        public boolean onTouchEvent(MotionEvent motionEvent) {
            int action;
            if (motionEvent != null && (action = motionEvent.getActionMasked()) == 1) {
                LocationCameraController.this.adjustGesturesThresholds();
            }
            return super.onTouchEvent(motionEvent);
        }
    }
}

