/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.location;

import com.mapbox.geojson.Feature;
import ir.map.sdk_map.style.expressions.Expression;
import ir.map.sdk_map.style.layers.CircleLayer;
import ir.map.sdk_map.style.layers.Layer;
import ir.map.sdk_map.style.layers.PropertyFactory;
import ir.map.sdk_map.style.layers.SymbolLayer;
import ir.map.sdk_map.style.sources.GeoJsonOptions;
import ir.map.sdk_map.style.sources.GeoJsonSource;

class LayerSourceProvider {
    private static final String EMPTY_STRING = "";

    LayerSourceProvider() {
    }

    GeoJsonSource generateSource(Feature locationFeature) {
        return new GeoJsonSource("mapbox-location-source", locationFeature, new GeoJsonOptions().withMaxZoom(16));
    }

    Layer generateLayer(String layerId) {
        SymbolLayer layer = new SymbolLayer(layerId, "mapbox-location-source");
        layer.setProperties(PropertyFactory.iconAllowOverlap(true), PropertyFactory.iconIgnorePlacement(true), PropertyFactory.iconRotationAlignment("map"), PropertyFactory.iconRotate(Expression.match(Expression.literal(layerId), Expression.literal(Float.valueOf(0.0f)), Expression.stop("mapbox-location-layer", Expression.get("mapbox-property-gps-bearing")), Expression.stop("mapbox-location-stroke-layer", Expression.get("mapbox-property-gps-bearing")), Expression.stop("mapbox-location-shadow", Expression.get("mapbox-property-gps-bearing")), Expression.stop("mapbox-location-bearing-layer", Expression.get("mapbox-property-compass-bearing")))), PropertyFactory.iconImage(Expression.match(Expression.literal(layerId), Expression.literal(EMPTY_STRING), Expression.stop("mapbox-location-layer", Expression.switchCase(Expression.get("mapbox-property-location-stale"), Expression.get("mapbox-property-foreground-stale-icon"), Expression.get("mapbox-property-foreground-icon"))), Expression.stop("mapbox-location-stroke-layer", Expression.switchCase(Expression.get("mapbox-property-location-stale"), Expression.get("mapbox-property-background-stale-icon"), Expression.get("mapbox-property-background-icon"))), Expression.stop("mapbox-location-shadow", Expression.literal("mapbox-location-shadow-icon")), Expression.stop("mapbox-location-bearing-layer", Expression.get("mapbox-property-shadow-icon")))), PropertyFactory.iconOffset(Expression.match(Expression.literal(layerId), Expression.literal(new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f)}), Expression.stop(Expression.literal("mapbox-location-layer"), Expression.get("mapbox-property-foreground-icon-offset")), Expression.stop(Expression.literal("mapbox-location-shadow"), Expression.get("mapbox-property-shadow-icon-offset")))));
        return layer;
    }

    Layer generateAccuracyLayer() {
        return new CircleLayer("mapbox-location-accuracy-layer", "mapbox-location-source").withProperties(PropertyFactory.circleRadius(Expression.get("mapbox-property-accuracy-radius")), PropertyFactory.circleColor(Expression.get("mapbox-property-accuracy-color")), PropertyFactory.circleOpacity(Expression.get("mapbox-property-accuracy-alpha")), PropertyFactory.circleStrokeColor(Expression.get("mapbox-property-accuracy-color")), PropertyFactory.circlePitchAlignment("map"));
    }
}

