/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.http;

import android.support.annotation.Keep;
import ir.map.sdk_map.Mapir;
import ir.map.sdk_map.http.HttpRequest;
import ir.map.sdk_map.http.HttpResponder;
import ir.map.sdk_map.http.LocalRequestTask;
import java.util.concurrent.locks.ReentrantLock;

@Keep
public class NativeHttpRequest
implements HttpResponder {
    private final HttpRequest httpRequest = Mapir.getModuleProvider().createHttpRequest();
    private final ReentrantLock lock = new ReentrantLock();
    @Keep
    private long nativePtr;

    @Keep
    private NativeHttpRequest(long nativePtr, String resourceUrl, String etag, String modified) {
        this.nativePtr = nativePtr;
        if (resourceUrl.startsWith("local://")) {
            this.executeLocalRequest(resourceUrl);
            return;
        }
        this.httpRequest.executeRequest(this, nativePtr, resourceUrl, etag, modified);
    }

    public void cancel() {
        this.httpRequest.cancelRequest();
        this.lock.lock();
        this.nativePtr = 0L;
        this.lock.unlock();
    }

    @Override
    public void onResponse(int responseCode, String etag, String lastModified, String cacheControl, String expires, String retryAfter, String xRateLimitReset, byte[] body) {
        this.lock.lock();
        if (this.nativePtr != 0L) {
            this.nativeOnResponse(responseCode, etag, lastModified, cacheControl, expires, retryAfter, xRateLimitReset, body);
        }
        this.lock.unlock();
    }

    private void executeLocalRequest(String resourceUrl) {
        new LocalRequestTask(bytes -> {
            if (bytes != null) {
                this.lock.lock();
                if (this.nativePtr != 0L) {
                    this.nativeOnResponse(200, null, null, null, null, null, null, bytes);
                }
                this.lock.unlock();
            }
        }).execute(new String[]{resourceUrl});
    }

    @Override
    public void handleFailure(int type, String errorMessage) {
        this.lock.lock();
        if (this.nativePtr != 0L) {
            this.nativeOnFailure(type, errorMessage);
        }
        this.lock.unlock();
    }

    @Keep
    private native void nativeOnFailure(int var1, String var2);

    @Keep
    private native void nativeOnResponse(int var1, String var2, String var3, String var4, String var5, String var6, String var7, byte[] var8);
}

