/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.annotations;

import android.os.Parcel;
import android.os.Parcelable;
import ir.map.sdk_map.annotations.Polyline;
import ir.map.sdk_map.geometry.LatLng;
import java.util.ArrayList;
import java.util.List;

public final class PolylineOptions
implements Parcelable {
    public static final Parcelable.Creator<PolylineOptions> CREATOR = new Parcelable.Creator<PolylineOptions>(){

        public PolylineOptions createFromParcel(Parcel in) {
            return new PolylineOptions(in);
        }

        public PolylineOptions[] newArray(int size) {
            return new PolylineOptions[size];
        }
    };
    private Polyline polyline = new Polyline();

    private PolylineOptions(Parcel in) {
        ArrayList<LatLng> pointsList = new ArrayList<LatLng>();
        in.readList(pointsList, LatLng.class.getClassLoader());
        this.addAll(pointsList);
        this.alpha(in.readFloat());
        this.color(in.readInt());
        this.width(in.readFloat());
    }

    public PolylineOptions() {
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeList(this.getPoints());
        out.writeFloat(this.getAlpha());
        out.writeInt(this.getColor());
        out.writeFloat(this.getWidth());
    }

    public PolylineOptions add(LatLng point) {
        this.polyline.addPoint(point);
        return this;
    }

    public PolylineOptions add(LatLng ... points) {
        for (LatLng point : points) {
            this.add(point);
        }
        return this;
    }

    public PolylineOptions addAll(Iterable<LatLng> points) {
        for (LatLng point : points) {
            this.add(point);
        }
        return this;
    }

    public PolylineOptions alpha(float alpha) {
        this.polyline.setAlpha(alpha);
        return this;
    }

    public float getAlpha() {
        return this.polyline.getAlpha();
    }

    public PolylineOptions color(int color) {
        this.polyline.setColor(color);
        return this;
    }

    public int getColor() {
        return this.polyline.getColor();
    }

    public Polyline getPolyline() {
        return this.polyline;
    }

    public float getWidth() {
        return this.polyline.getWidth();
    }

    public PolylineOptions width(float width) {
        this.polyline.setWidth(width);
        return this;
    }

    public List<LatLng> getPoints() {
        return this.polyline.getPoints();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolylineOptions polyline = (PolylineOptions)o;
        if (Float.compare(polyline.getAlpha(), this.getAlpha()) != 0) {
            return false;
        }
        if (this.getColor() != polyline.getColor()) {
            return false;
        }
        if (Float.compare(polyline.getWidth(), this.getWidth()) != 0) {
            return false;
        }
        return !(this.getPoints() == null ? polyline.getPoints() != null : !this.getPoints().equals(polyline.getPoints()));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getAlpha() != 0.0f ? Float.floatToIntBits(this.getAlpha()) : 0);
        result = 31 * result + this.getColor();
        result = 31 * result + (this.getWidth() != 0.0f ? Float.floatToIntBits(this.getWidth()) : 0);
        result = 31 * result + (this.getPoints() != null ? this.getPoints().hashCode() : 0);
        return result;
    }
}

