/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.annotations;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import ir.map.sdk_map.R;
import ir.map.sdk_map.annotations.Annotation;
import ir.map.sdk_map.annotations.BaseMarkerOptions;
import ir.map.sdk_map.annotations.BaseMarkerViewOptions;
import ir.map.sdk_map.annotations.Icon;
import ir.map.sdk_map.annotations.InfoWindow;
import ir.map.sdk_map.geometry.LatLng;
import ir.map.sdk_map.maps.MapView;
import ir.map.sdk_map.maps.MapirMap;

public class Marker
extends Annotation {
    @Keep
    private LatLng position;
    private String snippet;
    private Icon icon;
    @Keep
    private String iconId;
    private String title;
    private InfoWindow infoWindow;
    private boolean infoWindowShown;
    private int topOffsetPixels;
    private int rightOffsetPixels;

    Marker() {
    }

    public Marker(BaseMarkerOptions baseMarkerOptions) {
        this(baseMarkerOptions.position, baseMarkerOptions.icon, baseMarkerOptions.title, baseMarkerOptions.snippet);
    }

    Marker(BaseMarkerViewOptions baseMarkerViewOptions) {
        this(baseMarkerViewOptions.position, baseMarkerViewOptions.icon, baseMarkerViewOptions.title, baseMarkerViewOptions.snippet);
    }

    Marker(LatLng position, Icon icon, String title, String snippet) {
        this.position = position;
        this.title = title;
        this.snippet = snippet;
        this.setIcon(icon);
    }

    public LatLng getPosition() {
        return this.position;
    }

    public void setPosition(LatLng position) {
        this.position = position;
        MapirMap map = this.getMapirMap();
        if (map != null) {
            map.updateMarker(this);
        }
    }

    public String getSnippet() {
        return this.snippet;
    }

    public void setSnippet(String snippet) {
        this.snippet = snippet;
        this.refreshInfoWindowContent();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.refreshInfoWindowContent();
    }

    public void hideInfoWindow() {
        if (this.infoWindow != null) {
            this.infoWindow.close();
        }
        this.infoWindowShown = false;
    }

    public boolean isInfoWindowShown() {
        return this.infoWindowShown;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(@Nullable Icon icon) {
        this.icon = icon;
        this.iconId = icon != null ? icon.getId() : null;
        MapirMap map = this.getMapirMap();
        if (map != null) {
            map.updateMarker(this);
        }
    }

    @Nullable
    public InfoWindow getInfoWindow() {
        return this.infoWindow;
    }

    private void refreshInfoWindowContent() {
        if (this.isInfoWindowShown() && this.mapView != null && this.mapirMap != null && this.mapirMap.getInfoWindowAdapter() == null) {
            MapirMap map;
            InfoWindow infoWindow = this.getInfoWindow(this.mapView);
            if (this.mapView.getContext() != null) {
                infoWindow.adaptDefaultMarker(this, this.mapirMap, this.mapView);
            }
            if ((map = this.getMapirMap()) != null) {
                map.updateMarker(this);
            }
            infoWindow.onContentUpdate();
        }
    }

    public InfoWindow showInfoWindow(@NonNull MapirMap mapirMap, @NonNull MapView mapView) {
        View content;
        this.setMapirMap(mapirMap);
        this.setMapView(mapView);
        MapirMap.InfoWindowAdapter infoWindowAdapter = this.getMapirMap().getInfoWindowAdapter();
        if (infoWindowAdapter != null && (content = infoWindowAdapter.getInfoWindow(this)) != null) {
            this.infoWindow = new InfoWindow(content, mapirMap);
            this.showInfoWindow(this.infoWindow, mapView);
            return this.infoWindow;
        }
        InfoWindow infoWindow = this.getInfoWindow(mapView);
        if (mapView.getContext() != null) {
            infoWindow.adaptDefaultMarker(this, mapirMap, mapView);
        }
        return this.showInfoWindow(infoWindow, mapView);
    }

    private InfoWindow showInfoWindow(InfoWindow iw, MapView mapView) {
        iw.open(mapView, this, this.getPosition(), this.rightOffsetPixels, this.topOffsetPixels);
        this.infoWindowShown = true;
        return iw;
    }

    private InfoWindow getInfoWindow(@NonNull MapView mapView) {
        if (this.infoWindow == null && mapView.getContext() != null) {
            this.infoWindow = new InfoWindow(mapView, R.layout.mapir_infowindow_content, this.getMapirMap());
        }
        return this.infoWindow;
    }

    public void setTopOffsetPixels(int topOffsetPixels) {
        this.topOffsetPixels = topOffsetPixels;
    }

    public void setRightOffsetPixels(int rightOffsetPixels) {
        this.rightOffsetPixels = rightOffsetPixels;
    }

    public String toString() {
        return "Marker [position[" + this.getPosition() + "]]";
    }
}

