/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.annotations;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.PointF;
import android.os.Build;
import android.support.annotation.LayoutRes;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.TextView;
import ir.map.sdk_map.R;
import ir.map.sdk_map.annotations.BubbleLayout;
import ir.map.sdk_map.annotations.Marker;
import ir.map.sdk_map.geometry.LatLng;
import ir.map.sdk_map.maps.MapView;
import ir.map.sdk_map.maps.MapirMap;
import java.lang.ref.WeakReference;

public class InfoWindow {
    protected WeakReference<View> view;
    private WeakReference<Marker> boundMarker;
    private WeakReference<MapirMap> mapboxMap;
    private float markerHeightOffset;
    private float markerWidthOffset;
    private float viewWidthOffset;
    private float viewHeightOffset;
    private PointF coordinates;
    private final ViewTreeObserver.OnGlobalLayoutListener contentUpdateListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            View view = (View)InfoWindow.this.view.get();
            if (view != null) {
                if (Build.VERSION.SDK_INT >= 16) {
                    view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                InfoWindow.this.viewHeightOffset = (float)(-view.getMeasuredHeight()) + InfoWindow.this.markerHeightOffset;
                InfoWindow.this.update();
            }
        }
    };
    private boolean isVisible;
    @LayoutRes
    private int layoutRes;

    InfoWindow(MapView mapView, int layoutResId, MapirMap mapirMap) {
        this.layoutRes = layoutResId;
        View view = LayoutInflater.from((Context)mapView.getContext()).inflate(layoutResId, (ViewGroup)mapView, false);
        this.initialize(view, mapirMap);
    }

    InfoWindow(View view, MapirMap mapirMap) {
        this.initialize(view, mapirMap);
    }

    private void initialize(View view, MapirMap mapirMap) {
        this.mapboxMap = new WeakReference<MapirMap>(mapirMap);
        this.isVisible = false;
        this.view = new WeakReference<View>(view);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MapirMap mapirMap = (MapirMap)InfoWindow.this.mapboxMap.get();
                if (mapirMap != null) {
                    MapirMap.OnInfoWindowClickListener onInfoWindowClickListener = mapirMap.getOnInfoWindowClickListener();
                    boolean handledDefaultClick = false;
                    if (onInfoWindowClickListener != null) {
                        handledDefaultClick = onInfoWindowClickListener.onInfoWindowClick(InfoWindow.this.getBoundMarker());
                    }
                    if (!handledDefaultClick) {
                        InfoWindow.this.closeInfoWindow();
                    }
                }
            }
        });
        view.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                MapirMap.OnInfoWindowLongClickListener listener;
                MapirMap mapirMap = (MapirMap)InfoWindow.this.mapboxMap.get();
                if (mapirMap != null && (listener = mapirMap.getOnInfoWindowLongClickListener()) != null) {
                    listener.onInfoWindowLongClick(InfoWindow.this.getBoundMarker());
                }
                return true;
            }
        });
    }

    private void closeInfoWindow() {
        MapirMap mapbox = (MapirMap)this.mapboxMap.get();
        Marker marker = (Marker)this.boundMarker.get();
        if (marker != null && mapbox != null) {
            mapbox.deselectMarker(marker);
        }
        this.close();
    }

    InfoWindow open(MapView mapView, Marker boundMarker, LatLng position, int offsetX, int offsetY) {
        this.setBoundMarker(boundMarker);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, -2);
        MapirMap mapirMap = (MapirMap)this.mapboxMap.get();
        View view = (View)this.view.get();
        if (view != null && mapirMap != null) {
            view.measure(0, 0);
            this.markerHeightOffset = offsetY;
            this.markerWidthOffset = -offsetX;
            this.coordinates = mapirMap.getProjection().toScreenLocation(position);
            float x = this.coordinates.x - (float)(view.getMeasuredWidth() / 2) + (float)offsetX;
            float y = this.coordinates.y - (float)view.getMeasuredHeight() + (float)offsetY;
            if (view instanceof BubbleLayout) {
                Resources resources = mapView.getContext().getResources();
                float rightSideInfowWindow = x + (float)view.getMeasuredWidth();
                float leftSideInfoWindow = x;
                float mapRight = mapView.getRight();
                float mapLeft = mapView.getLeft();
                float marginHorizontal = resources.getDimension(R.dimen.mapir_infowindow_margin);
                float tipViewOffset = resources.getDimension(R.dimen.mapir_infowindow_tipview_width) / 2.0f;
                float tipViewMarginLeft = (float)(view.getMeasuredWidth() / 2) - tipViewOffset;
                boolean outOfBoundsLeft = false;
                boolean outOfBoundsRight = false;
                if (this.coordinates.x >= 0.0f && this.coordinates.x <= (float)mapView.getWidth() && this.coordinates.y >= 0.0f && this.coordinates.y <= (float)mapView.getHeight()) {
                    if (rightSideInfowWindow > mapRight) {
                        outOfBoundsRight = true;
                        x -= rightSideInfowWindow - mapRight;
                        tipViewMarginLeft += rightSideInfowWindow - mapRight + tipViewOffset;
                        rightSideInfowWindow = x + (float)view.getMeasuredWidth();
                    }
                    if (leftSideInfoWindow < mapLeft) {
                        outOfBoundsLeft = true;
                        x += mapLeft - leftSideInfoWindow;
                        tipViewMarginLeft -= mapLeft - leftSideInfoWindow + tipViewOffset;
                        leftSideInfoWindow = x;
                    }
                    if (outOfBoundsRight && mapRight - rightSideInfowWindow < marginHorizontal) {
                        tipViewMarginLeft += marginHorizontal - (mapRight - rightSideInfowWindow) - tipViewOffset;
                        leftSideInfoWindow = x -= marginHorizontal - (mapRight - rightSideInfowWindow);
                    }
                    if (outOfBoundsLeft && leftSideInfoWindow - mapLeft < marginHorizontal) {
                        x += marginHorizontal - (leftSideInfoWindow - mapLeft);
                        tipViewMarginLeft -= marginHorizontal - (leftSideInfoWindow - mapLeft) - tipViewOffset;
                    }
                }
                ((BubbleLayout)view).setArrowPosition(tipViewMarginLeft);
            }
            view.setX(x);
            view.setY(y);
            this.viewWidthOffset = x - this.coordinates.x - (float)offsetX;
            this.viewHeightOffset = -view.getMeasuredHeight() + offsetY;
            this.close();
            mapView.addView(view, (ViewGroup.LayoutParams)lp);
            this.isVisible = true;
        }
        return this;
    }

    InfoWindow close() {
        MapirMap mapirMap = (MapirMap)this.mapboxMap.get();
        if (this.isVisible && mapirMap != null) {
            this.isVisible = false;
            View view = (View)this.view.get();
            if (view != null && view.getParent() != null) {
                ((ViewGroup)view.getParent()).removeView(view);
            }
            Marker marker = this.getBoundMarker();
            MapirMap.OnInfoWindowCloseListener listener = mapirMap.getOnInfoWindowCloseListener();
            if (listener != null) {
                listener.onInfoWindowClose(marker);
            }
            this.setBoundMarker(null);
        }
        return this;
    }

    void adaptDefaultMarker(Marker overlayItem, MapirMap mapirMap, MapView mapView) {
        View view = (View)this.view.get();
        if (view == null) {
            view = LayoutInflater.from((Context)mapView.getContext()).inflate(this.layoutRes, (ViewGroup)mapView, false);
            this.initialize(view, mapirMap);
        }
        this.mapboxMap = new WeakReference<MapirMap>(mapirMap);
        String title = overlayItem.getTitle();
        TextView titleTextView = (TextView)view.findViewById(R.id.infowindow_title);
        if (!TextUtils.isEmpty((CharSequence)title)) {
            titleTextView.setText((CharSequence)title);
            titleTextView.setVisibility(0);
        } else {
            titleTextView.setVisibility(8);
        }
        String snippet = overlayItem.getSnippet();
        TextView snippetTextView = (TextView)view.findViewById(R.id.infowindow_description);
        if (!TextUtils.isEmpty((CharSequence)snippet)) {
            snippetTextView.setText((CharSequence)snippet);
            snippetTextView.setVisibility(0);
        } else {
            snippetTextView.setVisibility(8);
        }
    }

    Marker getBoundMarker() {
        if (this.boundMarker == null) {
            return null;
        }
        return (Marker)this.boundMarker.get();
    }

    InfoWindow setBoundMarker(Marker boundMarker) {
        this.boundMarker = new WeakReference<Marker>(boundMarker);
        return this;
    }

    public void update() {
        MapirMap mapirMap = (MapirMap)this.mapboxMap.get();
        Marker marker = (Marker)this.boundMarker.get();
        View view = (View)this.view.get();
        if (mapirMap != null && marker != null && view != null) {
            this.coordinates = mapirMap.getProjection().toScreenLocation(marker.getPosition());
            if (view instanceof BubbleLayout) {
                view.setX(this.coordinates.x + this.viewWidthOffset - this.markerWidthOffset);
            } else {
                view.setX(this.coordinates.x - (float)(view.getMeasuredWidth() / 2) - this.markerWidthOffset);
            }
            view.setY(this.coordinates.y + this.viewHeightOffset);
        }
    }

    void onContentUpdate() {
        ViewTreeObserver viewTreeObserver;
        View view = (View)this.view.get();
        if (view != null && (viewTreeObserver = view.getViewTreeObserver()).isAlive()) {
            viewTreeObserver.addOnGlobalLayoutListener(this.contentUpdateListener);
        }
    }

    public View getView() {
        return this.view != null ? (View)this.view.get() : null;
    }

    boolean isVisible() {
        return this.isVisible;
    }
}

