/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.annotations;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import ir.map.sdk_map.annotations.ArrowDirection;

class Bubble
extends Drawable {
    private RectF rect;
    private float arrowWidth;
    private float arrowHeight;
    private float arrowPosition;
    private float cornersRadius;
    private Paint paint = new Paint(1);
    private float strokeWidth;
    private Paint strokePaint;
    private Path strokePath;
    private Path path = new Path();

    Bubble(RectF rect, ArrowDirection arrowDirection, float arrowWidth, float arrowHeight, float arrowPosition, float cornersRadius, int bubbleColor, float strokeWidth, int strokeColor) {
        this.rect = rect;
        this.arrowWidth = arrowWidth;
        this.arrowHeight = arrowHeight;
        this.arrowPosition = arrowPosition;
        this.cornersRadius = cornersRadius;
        this.paint.setColor(bubbleColor);
        this.strokeWidth = strokeWidth;
        if (strokeWidth > 0.0f) {
            this.strokePaint = new Paint(1);
            this.strokePaint.setColor(strokeColor);
            this.strokePath = new Path();
            this.initPath(arrowDirection, this.path, strokeWidth);
            this.initPath(arrowDirection, this.strokePath, 0.0f);
        } else {
            this.initPath(arrowDirection, this.path, 0.0f);
        }
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
    }

    public void draw(Canvas canvas) {
        if (this.strokeWidth > 0.0f) {
            canvas.drawPath(this.strokePath, this.strokePaint);
        }
        canvas.drawPath(this.path, this.paint);
    }

    public int getOpacity() {
        return -3;
    }

    public void setAlpha(int alpha) {
        this.paint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.paint.setColorFilter(cf);
    }

    public int getIntrinsicWidth() {
        return (int)this.rect.width();
    }

    public int getIntrinsicHeight() {
        return (int)this.rect.height();
    }

    private void initPath(ArrowDirection arrowDirection, Path path, float strokeWidth) {
        switch (arrowDirection.getValue()) {
            case 0: {
                if (this.cornersRadius <= 0.0f) {
                    this.initLeftSquarePath(this.rect, path, strokeWidth);
                    break;
                }
                if (strokeWidth > 0.0f && strokeWidth > this.cornersRadius) {
                    this.initLeftSquarePath(this.rect, path, strokeWidth);
                    break;
                }
                this.initLeftRoundedPath(this.rect, path, strokeWidth);
                break;
            }
            case 2: {
                if (this.cornersRadius <= 0.0f) {
                    this.initTopSquarePath(this.rect, path, strokeWidth);
                    break;
                }
                if (strokeWidth > 0.0f && strokeWidth > this.cornersRadius) {
                    this.initTopSquarePath(this.rect, path, strokeWidth);
                    break;
                }
                this.initTopRoundedPath(this.rect, path, strokeWidth);
                break;
            }
            case 1: {
                if (this.cornersRadius <= 0.0f) {
                    this.initRightSquarePath(this.rect, path, strokeWidth);
                    break;
                }
                if (strokeWidth > 0.0f && strokeWidth > this.cornersRadius) {
                    this.initRightSquarePath(this.rect, path, strokeWidth);
                    break;
                }
                this.initRightRoundedPath(this.rect, path, strokeWidth);
                break;
            }
            case 3: {
                if (this.cornersRadius <= 0.0f) {
                    this.initBottomSquarePath(this.rect, path, strokeWidth);
                    break;
                }
                if (strokeWidth > 0.0f && strokeWidth > this.cornersRadius) {
                    this.initBottomSquarePath(this.rect, path, strokeWidth);
                    break;
                }
                this.initBottomRoundedPath(this.rect, path, strokeWidth);
            }
        }
    }

    private void initLeftSquarePath(RectF rect, Path path, float strokeWidth) {
        path.moveTo(this.arrowWidth + rect.left + strokeWidth, rect.top + strokeWidth);
        path.lineTo(rect.width() - strokeWidth, rect.top + strokeWidth);
        path.lineTo(rect.right - strokeWidth, rect.bottom - strokeWidth);
        path.lineTo(rect.left + this.arrowWidth + strokeWidth, rect.bottom - strokeWidth);
        path.lineTo(rect.left + this.arrowWidth + strokeWidth, this.arrowHeight + this.arrowPosition - strokeWidth / 2.0f);
        path.lineTo(rect.left + strokeWidth + strokeWidth, this.arrowPosition + this.arrowHeight / 2.0f);
        path.lineTo(rect.left + this.arrowWidth + strokeWidth, this.arrowPosition + strokeWidth / 2.0f);
        path.lineTo(rect.left + this.arrowWidth + strokeWidth, rect.top + strokeWidth);
        path.close();
    }

    private void initLeftRoundedPath(RectF rect, Path path, float strokeWidth) {
        path.moveTo(this.arrowWidth + rect.left + this.cornersRadius + strokeWidth, rect.top + strokeWidth);
        path.lineTo(rect.width() - this.cornersRadius - strokeWidth, rect.top + strokeWidth);
        path.arcTo(new RectF(rect.right - this.cornersRadius, rect.top + strokeWidth, rect.right - strokeWidth, this.cornersRadius + rect.top), 270.0f, 90.0f);
        path.lineTo(rect.right - strokeWidth, rect.bottom - this.cornersRadius - strokeWidth);
        path.arcTo(new RectF(rect.right - this.cornersRadius, rect.bottom - this.cornersRadius, rect.right - strokeWidth, rect.bottom - strokeWidth), 0.0f, 90.0f);
        path.lineTo(rect.left + this.arrowWidth + this.cornersRadius + strokeWidth, rect.bottom - strokeWidth);
        path.arcTo(new RectF(rect.left + this.arrowWidth + strokeWidth, rect.bottom - this.cornersRadius, this.cornersRadius + rect.left + this.arrowWidth, rect.bottom - strokeWidth), 90.0f, 90.0f);
        path.lineTo(rect.left + this.arrowWidth + strokeWidth, this.arrowHeight + this.arrowPosition - strokeWidth / 2.0f);
        path.lineTo(rect.left + strokeWidth + strokeWidth, this.arrowPosition + this.arrowHeight / 2.0f);
        path.lineTo(rect.left + this.arrowWidth + strokeWidth, this.arrowPosition + strokeWidth / 2.0f);
        path.lineTo(rect.left + this.arrowWidth + strokeWidth, rect.top + this.cornersRadius + strokeWidth);
        path.arcTo(new RectF(rect.left + this.arrowWidth + strokeWidth, rect.top + strokeWidth, this.cornersRadius + rect.left + this.arrowWidth, this.cornersRadius + rect.top), 180.0f, 90.0f);
        path.close();
    }

    private void initTopSquarePath(RectF rect, Path path, float strokeWidth) {
        path.moveTo(rect.left + this.arrowPosition + strokeWidth, rect.top + this.arrowHeight + strokeWidth);
        path.lineTo(rect.left + this.arrowPosition + strokeWidth / 2.0f, rect.top + this.arrowHeight + strokeWidth);
        path.lineTo(rect.left + this.arrowWidth / 2.0f + this.arrowPosition, rect.top + strokeWidth + strokeWidth);
        path.lineTo(rect.left + this.arrowWidth + this.arrowPosition - strokeWidth / 2.0f, rect.top + this.arrowHeight + strokeWidth);
        path.lineTo(rect.right - strokeWidth, rect.top + this.arrowHeight + strokeWidth);
        path.lineTo(rect.right - strokeWidth, rect.bottom - strokeWidth);
        path.lineTo(rect.left + strokeWidth, rect.bottom - strokeWidth);
        path.lineTo(rect.left + strokeWidth, rect.top + this.arrowHeight + strokeWidth);
        path.lineTo(rect.left + this.arrowPosition + strokeWidth, rect.top + this.arrowHeight + strokeWidth);
        path.close();
    }

    private void initTopRoundedPath(RectF rect, Path path, float strokeWidth) {
        path.moveTo(rect.left + Math.min(this.arrowPosition, this.cornersRadius) + strokeWidth, rect.top + this.arrowHeight + strokeWidth);
        path.lineTo(rect.left + this.arrowPosition + strokeWidth / 2.0f, rect.top + this.arrowHeight + strokeWidth);
        path.lineTo(rect.left + this.arrowWidth / 2.0f + this.arrowPosition, rect.top + strokeWidth + strokeWidth);
        path.lineTo(rect.left + this.arrowWidth + this.arrowPosition - strokeWidth / 2.0f, rect.top + this.arrowHeight + strokeWidth);
        path.lineTo(rect.right - this.cornersRadius - strokeWidth, rect.top + this.arrowHeight + strokeWidth);
        path.arcTo(new RectF(rect.right - this.cornersRadius, rect.top + this.arrowHeight + strokeWidth, rect.right - strokeWidth, this.cornersRadius + rect.top + this.arrowHeight), 270.0f, 90.0f);
        path.lineTo(rect.right - strokeWidth, rect.bottom - this.cornersRadius - strokeWidth);
        path.arcTo(new RectF(rect.right - this.cornersRadius, rect.bottom - this.cornersRadius, rect.right - strokeWidth, rect.bottom - strokeWidth), 0.0f, 90.0f);
        path.lineTo(rect.left + this.cornersRadius + strokeWidth, rect.bottom - strokeWidth);
        path.arcTo(new RectF(rect.left + strokeWidth, rect.bottom - this.cornersRadius, this.cornersRadius + rect.left, rect.bottom - strokeWidth), 90.0f, 90.0f);
        path.lineTo(rect.left + strokeWidth, rect.top + this.arrowHeight + this.cornersRadius + strokeWidth);
        path.arcTo(new RectF(rect.left + strokeWidth, rect.top + this.arrowHeight + strokeWidth, this.cornersRadius + rect.left, this.cornersRadius + rect.top + this.arrowHeight), 180.0f, 90.0f);
        path.close();
    }

    private void initRightSquarePath(RectF rect, Path path, float strokeWidth) {
        path.moveTo(rect.left + strokeWidth, rect.top + strokeWidth);
        path.lineTo(rect.width() - this.arrowWidth - strokeWidth, rect.top + strokeWidth);
        path.lineTo(rect.right - this.arrowWidth - strokeWidth, this.arrowPosition + strokeWidth / 2.0f);
        path.lineTo(rect.right - strokeWidth - strokeWidth, this.arrowPosition + this.arrowHeight / 2.0f);
        path.lineTo(rect.right - this.arrowWidth - strokeWidth, this.arrowPosition + this.arrowHeight - strokeWidth / 2.0f);
        path.lineTo(rect.right - this.arrowWidth - strokeWidth, rect.bottom - strokeWidth);
        path.lineTo(rect.left + strokeWidth, rect.bottom - strokeWidth);
        path.lineTo(rect.left + strokeWidth, rect.top + strokeWidth);
        path.close();
    }

    private void initRightRoundedPath(RectF rect, Path path, float strokeWidth) {
        path.moveTo(rect.left + this.cornersRadius + strokeWidth, rect.top + strokeWidth);
        path.lineTo(rect.width() - this.cornersRadius - this.arrowWidth - strokeWidth, rect.top + strokeWidth);
        path.arcTo(new RectF(rect.right - this.cornersRadius - this.arrowWidth, rect.top + strokeWidth, rect.right - this.arrowWidth - strokeWidth, this.cornersRadius + rect.top), 270.0f, 90.0f);
        path.lineTo(rect.right - this.arrowWidth - strokeWidth, this.arrowPosition + strokeWidth / 2.0f);
        path.lineTo(rect.right - strokeWidth - strokeWidth, this.arrowPosition + this.arrowHeight / 2.0f);
        path.lineTo(rect.right - this.arrowWidth - strokeWidth, this.arrowPosition + this.arrowHeight - strokeWidth / 2.0f);
        path.lineTo(rect.right - this.arrowWidth - strokeWidth, rect.bottom - this.cornersRadius - strokeWidth);
        path.arcTo(new RectF(rect.right - this.cornersRadius - this.arrowWidth, rect.bottom - this.cornersRadius, rect.right - this.arrowWidth - strokeWidth, rect.bottom - strokeWidth), 0.0f, 90.0f);
        path.lineTo(rect.left + this.arrowWidth + strokeWidth, rect.bottom - strokeWidth);
        path.arcTo(new RectF(rect.left + strokeWidth, rect.bottom - this.cornersRadius, this.cornersRadius + rect.left, rect.bottom - strokeWidth), 90.0f, 90.0f);
        path.arcTo(new RectF(rect.left + strokeWidth, rect.top + strokeWidth, this.cornersRadius + rect.left, this.cornersRadius + rect.top), 180.0f, 90.0f);
        path.close();
    }

    private void initBottomSquarePath(RectF rect, Path path, float strokeWidth) {
        path.moveTo(rect.left + strokeWidth, rect.top + strokeWidth);
        path.lineTo(rect.right - strokeWidth, rect.top + strokeWidth);
        path.lineTo(rect.right - strokeWidth, rect.bottom - this.arrowHeight - strokeWidth);
        path.lineTo(rect.left + this.arrowWidth + this.arrowPosition - strokeWidth / 2.0f, rect.bottom - this.arrowHeight - strokeWidth);
        path.lineTo(rect.left + this.arrowPosition + this.arrowWidth / 2.0f, rect.bottom - strokeWidth - strokeWidth);
        path.lineTo(rect.left + this.arrowPosition + strokeWidth / 2.0f, rect.bottom - this.arrowHeight - strokeWidth);
        path.lineTo(rect.left + this.arrowPosition + strokeWidth, rect.bottom - this.arrowHeight - strokeWidth);
        path.lineTo(rect.left + strokeWidth, rect.bottom - this.arrowHeight - strokeWidth);
        path.lineTo(rect.left + strokeWidth, rect.top + strokeWidth);
        path.close();
    }

    private void initBottomRoundedPath(RectF rect, Path path, float strokeWidth) {
        path.moveTo(rect.left + this.cornersRadius + strokeWidth, rect.top + strokeWidth);
        path.lineTo(rect.width() - this.cornersRadius - strokeWidth, rect.top + strokeWidth);
        path.arcTo(new RectF(rect.right - this.cornersRadius, rect.top + strokeWidth, rect.right - strokeWidth, this.cornersRadius + rect.top), 270.0f, 90.0f);
        path.lineTo(rect.right - strokeWidth, rect.bottom - this.arrowHeight - this.cornersRadius - strokeWidth);
        path.arcTo(new RectF(rect.right - this.cornersRadius, rect.bottom - this.cornersRadius - this.arrowHeight, rect.right - strokeWidth, rect.bottom - this.arrowHeight - strokeWidth), 0.0f, 90.0f);
        path.lineTo(rect.left + this.arrowWidth + this.arrowPosition - strokeWidth / 2.0f, rect.bottom - this.arrowHeight - strokeWidth);
        path.lineTo(rect.left + this.arrowPosition + this.arrowWidth / 2.0f, rect.bottom - strokeWidth - strokeWidth);
        path.lineTo(rect.left + this.arrowPosition + strokeWidth / 2.0f, rect.bottom - this.arrowHeight - strokeWidth);
        path.lineTo(rect.left + Math.min(this.cornersRadius, this.arrowPosition) + strokeWidth, rect.bottom - this.arrowHeight - strokeWidth);
        path.arcTo(new RectF(rect.left + strokeWidth, rect.bottom - this.cornersRadius - this.arrowHeight, this.cornersRadius + rect.left, rect.bottom - this.arrowHeight - strokeWidth), 90.0f, 90.0f);
        path.lineTo(rect.left + strokeWidth, rect.top + this.cornersRadius + strokeWidth);
        path.arcTo(new RectF(rect.left + strokeWidth, rect.top + strokeWidth, this.cornersRadius + rect.left, this.cornersRadius + rect.top), 180.0f, 90.0f);
        path.close();
    }
}

